/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Charsets {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String UTF_8_NAME = "UTF-8";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final ConcurrentMap<String, Charset> CACHE = new ConcurrentHashMap<String, Charset>();

    private Charsets() {
    }

    public static Charset forName(String charsetName) {
        Charset ncs;
        Charset cs = (Charset)CACHE.get(charsetName);
        if (null == cs && null == (cs = CACHE.putIfAbsent(charsetName, ncs = Charset.forName(charsetName)))) {
            cs = ncs;
        }
        return cs;
    }

    public static String toString(byte[] bytes, Charset charset) {
        return charset.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public static byte[] getBytes(String source, Charset charset) {
        ByteBuffer buf = charset.encode(CharBuffer.wrap(source));
        byte[] retval = new byte[buf.limit()];
        buf.get(retval);
        return retval;
    }
}

