/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.test.XMLCompare;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavProppatchAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavResource;
import org.jdom2.Namespace;

public class ProppatchTest
extends ActionTestCase {
    private static final Namespace TEST_NS = Namespace.getNamespace((String)"http://www.open-xchange.com/namespace/webdav-test");
    private WebdavPath INDEX_HTML_URL = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
    }

    public void testBasic() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:set><D:prop><D:displayname>The index page</D:displayname></D:prop><D:prop><OX:test>Hallo</OX:test></D:prop></D:set><D:set><D:prop><OX:test2>N'Abend</OX:test2></D:prop><D:prop><OX:test3>Mogg\u00e4hn!</OX:test3></D:prop></D:set></D:propertyupdate>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><D:displayname /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><OX:test /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><OX:test2 /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><OX:test3 /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString(body);
        req.setUrl(this.INDEX_HTML_URL);
        WebdavProppatchAction action = new WebdavProppatchAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        XMLCompare compare = new XMLCompare();
        ProppatchTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        ProppatchTest.assertEquals((String)"The index page", (String)resource.getDisplayName());
        WebdavProperty prop = resource.getProperty(TEST_NS.getURI(), "test");
        ProppatchTest.assertNotNull((Object)prop);
        ProppatchTest.assertEquals((String)"Hallo", (String)prop.getValue());
        prop = resource.getProperty(TEST_NS.getURI(), "test2");
        ProppatchTest.assertNotNull((Object)prop);
        ProppatchTest.assertEquals((String)"N'Abend", (String)prop.getValue());
        prop = resource.getProperty(TEST_NS.getURI(), "test3");
        ProppatchTest.assertNotNull((Object)prop);
        ProppatchTest.assertEquals((String)"Mogg\u00e4hn!", (String)prop.getValue());
        body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:set><D:prop><OX:test4>Was? Wo!</OX:test4></D:prop></D:set><D:remove><D:prop><OX:test /></D:prop><D:prop><OX:test2 /></D:prop></D:remove><D:remove><D:prop><OX:test3 /></D:prop></D:remove></D:propertyupdate>";
        expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><OX:test4 /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><OX:test /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><OX:test2 /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><OX:test3 /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        req.setBodyAsString(body);
        req.setUrl(this.INDEX_HTML_URL);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        ProppatchTest.assertEquals((int)207, (int)res.getStatus());
        ProppatchTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        prop = resource.getProperty(TEST_NS.getURI(), "test");
        ProppatchTest.assertNull((Object)prop);
        prop = resource.getProperty(TEST_NS.getURI(), "test2");
        ProppatchTest.assertNull((Object)prop);
        prop = resource.getProperty(TEST_NS.getURI(), "test3");
        ProppatchTest.assertNull((Object)prop);
        prop = resource.getProperty(TEST_NS.getURI(), "test4");
        ProppatchTest.assertNotNull((Object)prop);
        ProppatchTest.assertEquals((String)"Was? Wo!", (String)prop.getValue());
    }

    public void testXML() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:set><D:prop><OX:test><OX:gnatzel>GNA!</OX:gnatzel><bla xmlns=\"http://www.open-xchange.com/namespace/webdav-test2\" /></OX:test></D:prop></D:set></D:propertyupdate>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\" xmlns:OX=\"" + TEST_NS.getURI() + "\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><OX:test /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString(body);
        req.setUrl(this.INDEX_HTML_URL);
        WebdavProppatchAction action = new WebdavProppatchAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        ProppatchTest.assertEquals((int)207, (int)res.getStatus());
        XMLCompare compare = new XMLCompare();
        ProppatchTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        WebdavProperty prop = resource.getProperty(TEST_NS.getURI(), "test");
        ProppatchTest.assertNotNull((Object)prop);
        ProppatchTest.assertTrue((boolean)prop.isXML());
        ProppatchTest.assertEquals((String)"<OX:gnatzel xmlns:OX=\"http://www.open-xchange.com/namespace/webdav-test\">GNA!</OX:gnatzel><bla xmlns=\"http://www.open-xchange.com/namespace/webdav-test2\" />", (String)prop.getValue());
    }

    public void testForbidden() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propertyupdate xmlns:D=\"DAV:\"><D:set><D:prop><D:displayname>The index page</D:displayname></D:prop><D:prop><D:getlastmodified>Hallo</D:getlastmodified></D:prop></D:set></D:propertyupdate>";
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:multistatus xmlns:D=\"DAV:\"><D:response><D:href>http://localhost/" + this.INDEX_HTML_URL + "</D:href><D:propstat><D:prop><D:displayname /></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat><D:propstat><D:prop><D:getlastmodified /></D:prop><D:status>HTTP/1.1 403 FORBIDDEN</D:status></D:propstat></D:response></D:multistatus>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propertyupdate xmlns:D=\"DAV:\"><D:set><D:prop><D:displayname>The index page</D:displayname></D:prop><D:prop><D:getlastmodified>Hallo</D:getlastmodified></D:prop></D:set></D:propertyupdate>");
        req.setUrl(this.INDEX_HTML_URL);
        WebdavProppatchAction action = new WebdavProppatchAction(new Protocol());
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        XMLCompare compare = new XMLCompare();
        ProppatchTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }
}

