/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.transformators;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.SimpleCredentials;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class InternetAddressTransformator
implements Transformator {
    private final FixtureLoader fixtureLoader;

    public InternetAddressTransformator(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Object transform(String value) throws OXException {
        if (null == value || 1 > value.length()) {
            return null;
        }
        if (!value.contains(":")) {
            return this.getAddress(value);
        }
        String fixtureName = "users";
        String fixtureEntry = "";
        String[] splitted = value.split(",");
        Pattern patFlags = Pattern.compile("\\((\\w+)\\)");
        String plainMarker = "(plain)";
        boolean[] plainFLags = new boolean[splitted.length];
        for (int i = 0; i < splitted.length; ++i) {
            Matcher mFlag = patFlags.matcher(splitted[i]);
            if (!mFlag.find() || !mFlag.group().contains("(plain)")) continue;
            plainFLags[i] = true;
            splitted[i] = splitted[i].replace("(plain)", "").replace(" ", "");
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(splitted.length);
        for (int i = 0; i < splitted.length; ++i) {
            int idx = splitted[i].indexOf(58);
            if (0 < idx && splitted[i].length() > idx) {
                fixtureName = splitted[i].substring(0, idx);
                fixtureEntry = splitted[i].substring(idx + 1);
            } else {
                fixtureEntry = splitted[i];
            }
            addresses.addAll(this.getAddresses(fixtureName, fixtureEntry, plainFLags[i]));
        }
        return addresses.toArray(new InternetAddress[addresses.size()]);
    }

    private InternetAddress getAddress(String address) throws OXException {
        try {
            return InternetAddress.parse((String)address)[0];
        }
        catch (Exception e) {
            throw OXException.general((String)("Unable to parse e-mail address from " + address));
        }
    }

    private List<InternetAddress> getAddresses(String fixtureName, String fixtureEntry, boolean plainFlags) throws OXException {
        Contact contact;
        Contact contact2 = contact = "users".equals(fixtureName) ? this.fixtureLoader.getFixtures(fixtureName, SimpleCredentials.class).getEntry(fixtureEntry).getEntry().asContact() : this.fixtureLoader.getFixtures(fixtureName, Contact.class).getEntry(fixtureEntry).getEntry();
        if (null == contact) {
            throw OXException.general((String)("Unable to convert " + fixtureName + ":" + fixtureEntry + " into a contact."));
        }
        return this.getAddresses(contact, plainFlags);
    }

    /*
     * Unable to fully structure code
     */
    private List<InternetAddress> getAddresses(Contact contact, boolean plainFlags) throws OXException {
        addresses = new ArrayList<InternetAddress>();
        if (contact.containsDistributionLists()) {
            entries = contact.getDistributionList();
            if (null != entries && 0 < entries.length) {
                for (DistributionListEntryObject entry : entries) {
                    if (null == entry || !entry.containsEmailaddress()) continue;
                    try {
                        addresses.add(new InternetAddress(entry.getEmailaddress()));
                    }
                    catch (AddressException e) {
                        throw new OXException((Throwable)e);
                    }
                }
            }
        } else {
            try {
                if (contact.containsEmail1()) {
                    if (!plainFlags) {
                        addresses.add(new InternetAddress(contact.getEmail1(), contact.getDisplayName()));
                    }
                    addresses.add(new InternetAddress(contact.getEmail1()));
                }
                if (contact.containsEmail2()) {
                    if (!plainFlags) {
                        addresses.add(new InternetAddress(contact.getEmail2(), contact.getDisplayName()));
                    }
                    addresses.add(new InternetAddress(contact.getEmail2()));
                }
                if (!contact.containsEmail3()) ** GOTO lbl44
                if (!plainFlags) {
                    addresses.add(new InternetAddress(contact.getEmail3(), contact.getDisplayName()));
                }
                addresses.add(new InternetAddress(contact.getEmail3()));
            }
            catch (UnsupportedEncodingException e) {
                throw new OXException((Throwable)e);
            }
            catch (AddressException e) {
                e.printStackTrace();
            }
        }
lbl44:
        // 9 sources

        if (1 > addresses.size()) {
            throw OXException.general((String)"no e-mail addresses found in contact");
        }
        return addresses;
    }
}

