/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pubsub.sql;

import com.openexchange.config.ConfigurationService;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.datatypes.genericonf.storage.SimConfigurationStorageService;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.SimContext;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import com.openexchange.publish.sql.PublicationSQLStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.sql.builder.StatementBuilder;
import com.openexchange.sql.grammar.Command;
import com.openexchange.sql.grammar.Constant;
import com.openexchange.sql.grammar.DELETE;
import com.openexchange.sql.grammar.EQUALS;
import com.openexchange.sql.grammar.Expression;
import com.openexchange.sql.grammar.IN;
import com.openexchange.sql.grammar.LIST;
import com.openexchange.sql.grammar.Predicate;
import com.openexchange.sql.schema.Tables;
import com.openexchange.tools.sql.SQLTestCase;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class AbstractPublicationSQLStorageTest
extends SQLTestCase {
    protected Publication pub1 = null;
    protected Publication pub2 = null;
    protected Context ctx = new SimContext(1);
    protected List<Integer> publicationsToDelete = new ArrayList<Integer>();
    protected String entityId1;
    protected String entityId2 = this.entityId1 = "10";
    protected String module1;
    protected String module2 = this.module1 = "myModule";
    protected int userId = 44;
    protected PublicationSQLStorage storage;

    protected void loadProperties() throws IOException {
        ConfigurationService confService = (ConfigurationService)ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        this.properties = new Properties();
        this.properties.setProperty("driver", confService.getProperty("writeDriverClass"));
        this.properties.setProperty("login", confService.getProperty("writeProperty.1"));
        this.properties.setProperty("password", confService.getProperty("writeProperty.2"));
        this.properties.setProperty("url", confService.getProperty("writeUrl"));
    }

    public void setUp() throws Exception {
        Init.startServer();
        this.loadProperties();
        super.setUp();
        FormElement formElementLogin1 = new FormElement();
        formElementLogin1.setName("login1");
        formElementLogin1.setDisplayName("Login1");
        formElementLogin1.setMandatory(true);
        formElementLogin1.setWidget(FormElement.Widget.INPUT);
        formElementLogin1.setDefaultValue((Object)"default login1");
        FormElement formElementPassword1 = new FormElement();
        formElementPassword1.setName("password1");
        formElementPassword1.setDisplayName("Password1");
        formElementPassword1.setMandatory(true);
        formElementPassword1.setWidget(FormElement.Widget.PASSWORD);
        DynamicFormDescription formDescription1 = new DynamicFormDescription();
        formDescription1.addFormElement(formElementLogin1);
        formDescription1.addFormElement(formElementPassword1);
        PublicationTarget target1 = new PublicationTarget();
        target1.setDisplayName("Target 1");
        target1.setFormDescription(formDescription1);
        target1.setIcon("/path/to/icon1");
        target1.setModule(this.module1);
        target1.setId("com.openexchange.publication.test.basic1");
        HashMap<String, Object> config1 = new HashMap<String, Object>();
        config1.put("key1.1", 123);
        config1.put("key1.2", "Hello World!");
        this.pub1 = new Publication();
        this.pub1.setContext(this.ctx);
        this.pub1.setEntityId(this.entityId1);
        this.pub1.setModule(this.module1);
        this.pub1.setUserId(this.userId);
        this.pub1.setTarget(target1);
        this.pub1.setConfiguration(config1);
        FormElement formElementLogin2 = new FormElement();
        formElementLogin2.setName("login2");
        formElementLogin2.setDisplayName("Login2");
        formElementLogin2.setMandatory(true);
        formElementLogin2.setWidget(FormElement.Widget.INPUT);
        formElementLogin2.setDefaultValue((Object)"default login2");
        FormElement formElementPassword2 = new FormElement();
        formElementPassword2.setName("password2");
        formElementPassword2.setDisplayName("Password2");
        formElementPassword2.setMandatory(true);
        formElementPassword2.setWidget(FormElement.Widget.PASSWORD);
        DynamicFormDescription formDescription2 = new DynamicFormDescription();
        formDescription2.addFormElement(formElementLogin2);
        formDescription2.addFormElement(formElementPassword2);
        this.pub2 = new Publication();
        this.pub2.setContext(this.ctx);
        this.pub2.setEntityId(this.entityId2);
        this.pub2.setModule(this.module2);
        this.pub2.setUserId(this.userId);
        this.pub2.setTarget(target1);
        SimPublicationTargetDiscoveryService discoveryService = new SimPublicationTargetDiscoveryService();
        discoveryService.addTarget(target1);
        discoveryService.addTarget(target1);
        this.storage = new PublicationSQLStorage(this.getDBProvider(), (GenericConfigurationStorageService)new SimConfigurationStorageService(), (PublicationTargetDiscoveryService)discoveryService);
    }

    public void tearDown() throws Exception {
        if (this.publicationsToDelete.size() > 0) {
            ArrayList<Constant> placeholder = new ArrayList<Constant>();
            for (int delId : this.publicationsToDelete) {
                placeholder.add(Constant.PLACEHOLDER);
                Publication publicationToDelete = new Publication();
                publicationToDelete.setId(delId);
                publicationToDelete.setContext(this.ctx);
                this.storage.forgetPublication(publicationToDelete);
            }
            DELETE delete = new DELETE().FROM(Tables.publications).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new IN("id", new LIST(placeholder))));
            Connection writeConnection = this.getDBProvider().getWriteConnection(this.ctx);
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(this.ctx.getContextId());
            values.addAll(this.publicationsToDelete);
            new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
            this.getDBProvider().releaseWriteConnection(this.ctx, writeConnection);
        }
        super.tearDown();
    }

    protected void assertEquals(Publication expected, Publication actual) {
        AbstractPublicationSQLStorageTest.assertEquals((String)expected.getEntityId(), (String)actual.getEntityId());
        AbstractPublicationSQLStorageTest.assertEquals((int)expected.getId(), (int)actual.getId());
        AbstractPublicationSQLStorageTest.assertEquals((String)expected.getModule(), (String)actual.getModule());
        AbstractPublicationSQLStorageTest.assertEquals((int)expected.getUserId(), (int)actual.getUserId());
        this.assertEquals(expected.getTarget(), actual.getTarget());
    }

    protected void assertEquals(PublicationTarget expected, PublicationTarget actual) {
        AbstractPublicationSQLStorageTest.assertEquals((String)expected.getDisplayName(), (String)actual.getDisplayName());
        AbstractPublicationSQLStorageTest.assertEquals((String)expected.getIcon(), (String)actual.getIcon());
        AbstractPublicationSQLStorageTest.assertEquals((String)expected.getId(), (String)actual.getId());
        AbstractPublicationSQLStorageTest.assertEquals((String)expected.getModule(), (String)actual.getModule());
        this.assertEquals(expected.getFormDescription(), actual.getFormDescription());
    }

    protected void assertEquals(DynamicFormDescription expected, DynamicFormDescription actual) {
        AbstractPublicationSQLStorageTest.assertEquals((String)"Form Element size does notg match", (int)expected.getFormElements().size(), (int)actual.getFormElements().size());
        for (FormElement formElementExpected : expected.getFormElements()) {
            boolean found = false;
            for (FormElement formElementActual : actual.getFormElements()) {
                if (!formElementExpected.getName().equals(formElementActual.getName())) continue;
                found = true;
                AbstractPublicationSQLStorageTest.assertEquals((Object)formElementExpected, (Object)formElementActual);
            }
            if (found) continue;
            AbstractPublicationSQLStorageTest.fail((String)"Missing FormElement");
        }
    }

    protected void removePublicationsForTarget(String targetId) throws Exception {
        Connection writeConnection = this.getDBProvider().getWriteConnection(this.ctx);
        DELETE delete = new DELETE().FROM(Tables.publications).WHERE((Predicate)new EQUALS("target_id", (Expression)Constant.PLACEHOLDER));
        ArrayList<String> values = new ArrayList<String>();
        values.add(targetId);
        new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
        this.getDBProvider().releaseWriteConnection(this.ctx, writeConnection);
    }

    protected void removePublicationsForEntity(String entity, String module) throws Exception {
        Connection writeConnection = this.getDBProvider().getWriteConnection(this.ctx);
        DELETE delete = new DELETE().FROM(Tables.publications).WHERE(new EQUALS("entity", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("module", (Expression)Constant.PLACEHOLDER)));
        ArrayList<String> values = new ArrayList<String>();
        values.add(entity);
        values.add(module);
        new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
        this.getDBProvider().releaseWriteConnection(this.ctx, writeConnection);
    }
}

