/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import java.util.HashMap;
import java.util.Map;

public class MockGroupLookup {
    private final Map<Integer, Group> groups = new HashMap<Integer, Group>();

    public Group getGroup(int gid) throws OXException {
        if (!this.groups.containsKey(gid)) {
            throw LdapExceptionCode.GROUP_NOT_FOUND.create(new Object[]{gid});
        }
        return this.groups.get(gid);
    }

    public MockGroupLookup() {
        int i = 0;
        Group group = new Group();
        group.setIdentifier(++i);
        group.setDisplayName("users");
        group.setMember(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        this.addGroup(group);
        group = new Group();
        group.setIdentifier(++i);
        group.setDisplayName("Even Users");
        group.setMember(new int[]{3, 5, 7, 9});
        this.addGroup(group);
        group = new Group();
        group.setIdentifier(++i);
        group.setDisplayName("Some group");
        group.setMember(new int[]{5, 6, 9});
        this.addGroup(group);
        group = new Group();
        group.setIdentifier(++i);
        group.setDisplayName("Uneven Users");
        group.setMember(new int[]{2, 4, 6, 8, 10});
    }

    private void addGroup(Group group) {
        this.groups.put(group.getIdentifier(), group);
    }
}

