/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.validation;

import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.MetadataSwitcher;
import com.openexchange.groupware.infostore.validation.DocumentMetadataValidation;
import com.openexchange.groupware.infostore.validation.InvalidCharactersValidator;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class InfostoreInvalidCharactersCheckTest
extends TestCase {
    public void testSwitcher() {
        DocumentMetadataImpl metadata = new DocumentMetadataImpl();
        metadata.setCategories("categories");
        metadata.setDescription("description");
        metadata.setFileMD5Sum("sum");
        metadata.setFileMIMEType("mimetype");
        metadata.setFileName("name");
        metadata.setTitle("title");
        metadata.setURL("url");
        metadata.setVersionComment("comment");
        DocumentMetadataValidation validation = new TestValidator().validate((DocumentMetadata)metadata);
        InfostoreInvalidCharactersCheckTest.assertFalse((boolean)validation.isValid());
        Metadata[] fields = new Metadata[]{Metadata.CATEGORIES_LITERAL, Metadata.DESCRIPTION_LITERAL, Metadata.FILE_MD5SUM_LITERAL, Metadata.FILE_MIMETYPE_LITERAL, Metadata.FILENAME_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL, Metadata.VERSION_COMMENT_LITERAL};
        GetSwitch get = new GetSwitch((DocumentMetadata)metadata);
        for (Metadata m : fields) {
            InfostoreInvalidCharactersCheckTest.assertTrue((boolean)validation.hasErrors(m));
            InfostoreInvalidCharactersCheckTest.assertEquals((Object)m.doSwitch((MetadataSwitcher)get), (Object)validation.getError(m));
        }
    }

    public static class TestValidator
    extends InvalidCharactersValidator {
        List<String> strings = new ArrayList<String>();

        public String check(String s) {
            this.strings.add(s);
            return s;
        }
    }
}

