/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.contact.helpers.ContactGetter;
import com.openexchange.groupware.contact.helpers.ContactSetter;
import com.openexchange.groupware.contact.helpers.ContactSwitcher;
import com.openexchange.groupware.contact.helpers.ContactSwitcherForBooleans;
import com.openexchange.groupware.contact.helpers.ContactSwitcherForSimpleDateFormat;
import com.openexchange.groupware.contact.helpers.ContactSwitcherForTimestamp;
import com.openexchange.groupware.contact.helpers.SplitBirthdayFieldsSetter;
import com.openexchange.groupware.container.Contact;
import com.openexchange.importexport.importers.OutlookCSVContactImporter;
import java.lang.constant.Constable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;

public class ContactSwitcherTester
extends TestCase {
    public void testSetStringValue() throws OXException {
        Contact conObj = new Contact();
        ContactField field = ContactField.GIVEN_NAME;
        String value = "Prinz";
        conObj = (Contact)field.doSwitch((ContactSwitcher)new ContactSetter(), new Object[]{conObj, "Prinz"});
        ContactSwitcherTester.assertEquals((String)"Setting of String value does work", (String)conObj.getGivenName(), (String)"Prinz");
    }

    public void testSetMailValue() throws OXException {
        Contact conObj = new Contact();
        ContactField field = ContactField.EMAIL1;
        String value = "prinz@example.invalid";
        conObj = (Contact)field.doSwitch((ContactSwitcher)new ContactSetter(), new Object[]{conObj, "prinz@example.invalid"});
        ContactSwitcherTester.assertEquals((String)"Setting of e-mail does work", (String)conObj.getEmail1(), (String)"prinz@example.invalid");
    }

    public void testSetDateValue() throws OXException {
        Contact conObj = new Contact();
        ContactField field = ContactField.BIRTHDAY;
        Date value = new Date(System.currentTimeMillis());
        conObj = (Contact)field.doSwitch((ContactSwitcher)new ContactSetter(), new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)"Setting of Date value does work", (Object)conObj.getBirthday(), (Object)value);
    }

    public void testSetDateValueViaTimestamp() throws OXException {
        Contact conObj = new Contact();
        ContactField field = ContactField.BIRTHDAY;
        long value = System.currentTimeMillis();
        ContactSwitcherForTimestamp switcher = new ContactSwitcherForTimestamp();
        switcher.setDelegate((ContactSwitcher)new ContactSetter());
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)"Setting of date via timestamp (as long) does work", (Object)conObj.getBirthday(), (Object)new Date(value));
        String value2 = new Long(value).toString();
        switcher.setDelegate((ContactSwitcher)new ContactSetter());
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value2});
        ContactSwitcherTester.assertEquals((String)"Setting of date via timestamp (as String) does work", (Object)conObj.getBirthday(), (Object)new Date(value));
    }

    public void testSetDateValueViaSimpleDate() throws OXException, ParseException {
        Contact conObj = new Contact();
        ContactField field = ContactField.BIRTHDAY;
        String value = "1981/03/05";
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        ContactSwitcherForSimpleDateFormat switcher = new ContactSwitcherForSimpleDateFormat();
        switcher.setDelegate((ContactSwitcher)new ContactSetter());
        switcher.addDateFormat((DateFormat)sdf);
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, "1981/03/05"});
        ContactSwitcherTester.assertEquals((String)"Setting of date via Outlook-simple-date value does work", (Object)conObj.getBirthday(), (Object)sdf.parse("1981/03/05"));
    }

    public void testGetDateAndName() throws OXException {
        Contact conObj = new Contact();
        Date date = new Date(System.currentTimeMillis());
        String nickname = "Tierlieb";
        ContactGetter switcher = new ContactGetter();
        conObj.setBirthday(date);
        conObj.setNickname("Tierlieb");
        Date compareDate = (Date)ContactField.BIRTHDAY.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, ""});
        String compareNickname = (String)ContactField.NICKNAME.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, ""});
        ContactSwitcherTester.assertEquals((String)"Checking date", (Object)date, (Object)compareDate);
        ContactSwitcherTester.assertEquals((String)"Checking nickname", (String)"Tierlieb", (String)compareNickname);
    }

    public void testUnkownFieldHandling() throws OXException {
        ContactSwitcherTester.assertFalse((String)"Should return false when getting unknown field", (boolean)new ContactGetter()._unknownfield(null, "field", (Object)"value", new Object[0]));
        ContactSwitcherTester.assertFalse((String)"Should return false when setting unknown field", (boolean)new ContactSetter()._unknownfield(null, "field", (Object)"value", new Object[0]));
    }

    public void testSplitBirthdayFieldHandling() throws OXException {
        SplitBirthdayFieldsSetter switcher = new SplitBirthdayFieldsSetter();
        Contact contact = new Contact();
        Integer day = 31;
        Integer month = 12;
        Integer year = 1970;
        switcher._unknownfield(contact, "birthday_day", (Object)day, new Object[0]);
        switcher._unknownfield(contact, "birthday_month", (Object)month, new Object[0]);
        switcher._unknownfield(contact, "birthday_year", (Object)year, new Object[0]);
        Calendar expected = Calendar.getInstance();
        expected.setTime(contact.getBirthday());
        ContactSwitcherTester.assertEquals((String)"Day should match", (int)day, (int)expected.get(5));
        ContactSwitcherTester.assertEquals((String)"Month should match", (int)11, (int)expected.get(2));
        ContactSwitcherTester.assertEquals((String)"Year should match", (int)year, (int)expected.get(1));
    }

    public void testDateSwitchingForBug7552() throws Exception {
        Init.startServer();
        Contact conObj = new Contact();
        ContactField field = ContactField.BIRTHDAY;
        ContactSwitcherForSimpleDateFormat switcher = new ContactSwitcherForSimpleDateFormat();
        switcher.setDelegate((ContactSwitcher)new ContactSetter());
        switcher.addDateFormat((DateFormat)OutlookCSVContactImporter.getAmericanDateNotation());
        switcher.addDateFormat((DateFormat)OutlookCSVContactImporter.getGermanDateNotation());
        String value = "1981/03/05";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)"Setting of date via Outlook-simple-date value does work", (Object)conObj.getBirthday(), (Object)OutlookCSVContactImporter.getAmericanDateNotation().parse(value));
        value = "05.03.1981";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)"Setting of date via Outlook-simple-date value does work", (Object)conObj.getBirthday(), (Object)OutlookCSVContactImporter.getGermanDateNotation().parse(value));
    }

    public void testBooleanSwitchingForBug7710() throws OXException {
        Contact conObj = new Contact();
        ContactField field = ContactField.PRIVATE_FLAG;
        ContactSwitcherForBooleans switcher = new ContactSwitcherForBooleans();
        switcher.setDelegate((ContactSwitcher)new ContactSetter());
        String value = "true";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value = "1";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value = "yes";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value = "y";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value = "Priv\u00e9";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value = "no";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does no work"), (boolean)false, (boolean)conObj.getPrivateFlag());
        value = "false";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does not work"), (boolean)false, (boolean)conObj.getPrivateFlag());
        value = "wrong";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does not work"), (boolean)false, (boolean)conObj.getPrivateFlag());
        value = "0";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does not work"), (boolean)false, (boolean)conObj.getPrivateFlag());
        value = "normal";
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value + " does not work"), (boolean)false, (boolean)conObj.getPrivateFlag());
        Constable value2 = 1;
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value2});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value2 + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value2 = Boolean.valueOf(true);
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value2});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value2 + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value2 = new Boolean(true);
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value2});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value2 + " does work"), (boolean)true, (boolean)conObj.getPrivateFlag());
        value2 = 0;
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value2});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value2 + " does not work"), (boolean)false, (boolean)conObj.getPrivateFlag());
        value2 = Boolean.valueOf(false);
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value2});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value2 + " does not work"), (boolean)false, (boolean)conObj.getPrivateFlag());
        value2 = new Boolean(false);
        conObj = (Contact)field.doSwitch((ContactSwitcher)switcher, new Object[]{conObj, value2});
        ContactSwitcherTester.assertEquals((String)("Setting private flag via " + value2 + " does not work"), (boolean)false, (boolean)conObj.getPrivateFlag());
    }
}

