/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AbstractAttachmentTest;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.attach.util.GetSwitch;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.MockUser;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.modules.Module;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.tx.ConfigurableDBProvider;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Charsets;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.OXTestToolkit;
import com.openexchange.tools.iterator.SearchIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public class AttachmentBaseTest
extends AbstractAttachmentTest {
    private static final Mode MODE = new INTEGRATION();
    private AttachmentBase attachmentBase;
    private final List<AttachmentMetadata> clean = new ArrayList<AttachmentMetadata>();
    private File testFile;

    public void testAttach() throws Exception {
        this.doAttach(22, 22, 22);
    }

    public void testDetach() throws Exception {
        this.doDetach(22, 22, 22);
    }

    public void testGetAttachments() throws Exception {
        this.doGetAttachments(22, 22, 22);
    }

    public void testDelta() throws Exception {
        this.doDelta(22, 22, 22);
    }

    public void testNotify() throws Exception {
        this.doNotify(22, 22, 22);
    }

    public void testCheckPermissions() throws Exception {
        this.doCheckPermissions(22, 22, 22);
    }

    public void testNotExists() throws Exception {
        this.doNotExists(22, 22, 22);
    }

    public void testUpdate() throws Exception {
        this.doUpdate(22, 22, 22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteAll() throws Exception {
        int folderId = 22;
        int attachedId = 22;
        int moduleId = 22;
        AttachmentMetadata attachment = this.getAttachment(this.testFile, 22, 22, 22, true);
        InputStream in = null;
        try {
            for (int i = 0; i < 10; ++i) {
                AttachmentImpl copy = new AttachmentImpl(attachment);
                in = new FileInputStream(this.testFile);
                this.attachmentBase.attachToObject((AttachmentMetadata)copy, in, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
                this.clean.add((AttachmentMetadata)copy);
            }
            this.clean.add(attachment);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.attachmentBase.deleteAll(MODE.getContext());
        TimedResult res = this.attachmentBase.getAttachments(22, 22, 22, MODE.getContext(), MODE.getUser(), null);
        AttachmentBaseTest.assertFalse((String)"All attachments should have been deleted", (boolean)res.results().hasNext());
        this.clean.clear();
    }

    public void doNotExists(int folderId, int attachedId, int moduleId) throws Exception {
        try {
            this.attachmentBase.getAttachment(folderId, attachedId, moduleId, Integer.MAX_VALUE, MODE.getContext(), MODE.getUser(), null);
            AttachmentBaseTest.fail((String)"Got Wrong Exception");
        }
        catch (OXException x) {
            AttachmentBaseTest.assertTrue((boolean)true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            AttachmentBaseTest.fail((String)("Got Wrong Exception: " + t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(int folderId, int attachedId, int moduleId) throws Exception {
        int b;
        AttachmentMetadata attachment = this.getAttachment(this.testFile, folderId, attachedId, moduleId, true);
        InputStream in = null;
        try {
            in = new FileInputStream(this.testFile);
            this.attachmentBase.attachToObject(attachment, in, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
            this.clean.add(attachment);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        AttachmentBaseTest.assertFalse((0 == attachment.getId() ? 1 : 0) != 0);
        byte[] data = "Hallo Welt".getBytes(Charsets.UTF_8);
        attachment.setFilesize((long)data.length);
        Date oldCreationDate = attachment.getCreationDate();
        try {
            in = new ByteArrayInputStream(data);
            this.attachmentBase.attachToObject(attachment, in, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        AttachmentMetadata reload = this.attachmentBase.getAttachment(folderId, attachedId, moduleId, attachment.getId(), MODE.getContext(), MODE.getUser(), null);
        AttachmentBaseTest.assertFalse((reload.getCreationDate().getTime() == oldCreationDate.getTime() ? 1 : 0) != 0);
        AttachmentBaseTest.assertEquals((long)reload.getFilesize(), (long)data.length);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        in = this.attachmentBase.getAttachedFile(folderId, attachedId, moduleId, attachment.getId(), MODE.getContext(), MODE.getUser(), null);
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        AttachmentBaseTest.assertEquals((String)"Hallo Welt", (String)new String(out.toByteArray(), Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAttach(int folderId, int attachedId, int moduleId) throws Exception {
        AttachmentMetadata attachment = this.getAttachment(this.testFile, folderId, attachedId, moduleId, true);
        AttachmentImpl copy = new AttachmentImpl(attachment);
        InputStream in = null;
        Date now = null;
        try {
            now = new Date();
            in = new FileInputStream(this.testFile);
            this.attachmentBase.attachToObject(attachment, in, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
            this.clean.add(attachment);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        AttachmentBaseTest.assertFalse((0 == attachment.getId() ? 1 : 0) != 0);
        AttachmentMetadata reload = this.attachmentBase.getAttachment(folderId, attachedId, moduleId, attachment.getId(), MODE.getContext(), MODE.getUser(), null);
        copy.setCreationDate(now);
        copy.setCreatedBy(MODE.getUser().getId());
        copy.setId(attachment.getId());
        AttachmentBaseTest.assertEquals((AttachmentMetadata)copy, reload, 10000);
        in = null;
        InputStream in2 = null;
        try {
            in2 = this.attachmentBase.getAttachedFile(folderId, attachedId, moduleId, attachment.getId(), MODE.getContext(), MODE.getUser(), null);
            in = new FileInputStream(this.testFile);
            OXTestToolkit.assertSameContent(in, in2);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (in2 != null) {
                in.close();
            }
        }
    }

    public void doDetach(int folderId, int attachedId, int moduleId) throws Exception {
        this.doAttach(folderId, attachedId, moduleId);
        int id = this.clean.get(0).getId();
        for (AttachmentMetadata m : this.clean) {
            this.attachmentBase.detachFromObject(m.getFolderId(), m.getAttachedId(), m.getModuleId(), new int[]{m.getId()}, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
        }
        try {
            this.attachmentBase.getAttachment(folderId, attachedId, moduleId, id, MODE.getContext(), MODE.getUser(), null);
            AttachmentBaseTest.fail((String)"The attachment wasn't removed");
        }
        catch (Exception x) {
            AttachmentBaseTest.assertTrue((boolean)true);
        }
    }

    public void doGetAttachments(int folderId, int attachedId, int moduleId) throws Exception {
        this.doAttach(folderId, attachedId, moduleId);
        this.doAttach(folderId, attachedId, moduleId);
        this.doAttach(folderId, attachedId, moduleId);
        this.doAttach(folderId, attachedId, moduleId);
        this.doAttach(folderId, attachedId, moduleId);
        SearchIterator iterator = this.attachmentBase.getAttachments(folderId, attachedId, moduleId, MODE.getContext(), MODE.getUser(), null).results();
        HashSet<AttachmentMetadata> metadata = new HashSet<AttachmentMetadata>(this.clean);
        while (iterator.hasNext()) {
            AttachmentMetadata m = (AttachmentMetadata)iterator.next();
            AttachmentBaseTest.assertTrue((boolean)metadata.remove(m));
        }
        AttachmentBaseTest.assertTrue((String)((Object)metadata).toString(), (boolean)metadata.isEmpty());
        iterator.close();
        iterator = this.attachmentBase.getAttachments(folderId, attachedId, moduleId, new AttachmentField[]{AttachmentField.ID_LITERAL}, AttachmentField.ID_LITERAL, 1, MODE.getContext(), MODE.getUser(), null).results();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (AttachmentMetadata m : this.clean) {
            ids.add(m.getId());
        }
        Collections.sort(ids);
        Iterator idIterator = ids.iterator();
        while (iterator.hasNext()) {
            AttachmentBaseTest.assertTrue((boolean)idIterator.hasNext());
            AttachmentBaseTest.assertEquals(idIterator.next(), (Object)((AttachmentMetadata)iterator.next()).getId());
        }
        AttachmentBaseTest.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        int[] idsToFetch = new int[]{this.clean.get(0).getId(), this.clean.get(2).getId(), this.clean.get(4).getId()};
        iterator = this.attachmentBase.getAttachments(folderId, attachedId, moduleId, idsToFetch, new AttachmentField[]{AttachmentField.ID_LITERAL, AttachmentField.FILENAME_LITERAL}, MODE.getContext(), MODE.getUser(), null).results();
        int i = 0;
        while (iterator.hasNext()) {
            AttachmentBaseTest.assertEquals((int)idsToFetch[i], (int)((AttachmentImpl)iterator.next()).getId());
            ++i;
        }
        AttachmentBaseTest.assertEquals((int)idsToFetch.length, (int)i);
    }

    public void doDelta(int folderId, int attachedId, int moduleId) throws Exception {
        AttachmentMetadata m;
        this.doAttach(folderId, attachedId, moduleId);
        long ts = this.clean.get(0).getCreationDate().getTime();
        Thread.sleep(1000L);
        this.doAttach(folderId, attachedId, moduleId);
        this.doAttach(folderId, attachedId, moduleId);
        this.doAttach(folderId, attachedId, moduleId);
        this.doAttach(folderId, attachedId, moduleId);
        Delta delta = this.attachmentBase.getDelta(folderId, attachedId, moduleId, ts, true, MODE.getContext(), MODE.getUser(), null);
        HashSet<AttachmentMetadata> metadata = new HashSet<AttachmentMetadata>(this.clean.subList(1, this.clean.size()));
        SearchIterator iterator = delta.getNew();
        while (iterator.hasNext()) {
            AttachmentMetadata m2 = (AttachmentMetadata)iterator.next();
            AttachmentBaseTest.assertTrue((boolean)metadata.remove(m2));
        }
        AttachmentBaseTest.assertTrue((boolean)metadata.isEmpty());
        iterator.close();
        delta.getDeleted().close();
        delta.getModified().close();
        delta = this.attachmentBase.getDelta(folderId, attachedId, moduleId, ts, true, new AttachmentField[]{AttachmentField.ID_LITERAL}, AttachmentField.ID_LITERAL, 1, MODE.getContext(), MODE.getUser(), null);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (AttachmentMetadata m3 : this.clean.subList(1, this.clean.size())) {
            ids.add(m3.getId());
        }
        Collections.sort(ids);
        Iterator idIterator = ids.iterator();
        iterator = delta.getNew();
        while (iterator.hasNext()) {
            AttachmentBaseTest.assertTrue((boolean)idIterator.hasNext());
            AttachmentBaseTest.assertEquals(idIterator.next(), (Object)((AttachmentMetadata)iterator.next()).getId());
        }
        AttachmentBaseTest.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        delta.getDeleted().close();
        delta.getModified().close();
        ArrayList<AttachmentMetadata> all = new ArrayList<AttachmentMetadata>(this.clean);
        for (AttachmentMetadata m4 : this.clean) {
            this.attachmentBase.detachFromObject(m4.getFolderId(), m4.getAttachedId(), m4.getModuleId(), new int[]{m4.getId()}, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
        }
        this.clean.clear();
        delta = this.attachmentBase.getDelta(folderId, attachedId, moduleId, ts, false, MODE.getContext(), MODE.getUser(), null);
        metadata = new HashSet<AttachmentMetadata>(all);
        iterator = delta.getDeleted();
        while (iterator.hasNext()) {
            m = (AttachmentMetadata)iterator.next();
            AttachmentBaseTest.assertTrue((boolean)metadata.remove(m));
        }
        AttachmentBaseTest.assertTrue((String)((Object)metadata).toString(), (boolean)metadata.isEmpty());
        iterator.close();
        delta.getNew().close();
        delta.getModified().close();
        delta = this.attachmentBase.getDelta(folderId, attachedId, moduleId, ts, false, new AttachmentField[]{AttachmentField.ID_LITERAL}, AttachmentField.ID_LITERAL, 1, MODE.getContext(), MODE.getUser(), null);
        metadata = new HashSet<AttachmentMetadata>(all);
        iterator = delta.getDeleted();
        while (iterator.hasNext()) {
            m = (AttachmentMetadata)iterator.next();
            AttachmentBaseTest.assertTrue((boolean)metadata.remove(m));
        }
        AttachmentBaseTest.assertTrue((boolean)metadata.isEmpty());
        iterator.close();
        delta.getNew().close();
        delta.getModified().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotify(int folderId, int attachedId, int moduleId) throws Exception {
        TestAttachmentListener listener = new TestAttachmentListener();
        this.attachmentBase.registerAttachmentListener((AttachmentListener)listener, moduleId);
        AttachmentMetadata attachment = this.getAttachment(this.testFile, folderId, attachedId, moduleId, false);
        InputStream in = null;
        try {
            in = new FileInputStream(this.testFile);
            this.attachmentBase.attachToObject(attachment, in, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
            this.clean.add(attachment);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        AttachmentEvent e = listener.getEvent();
        AttachmentBaseTest.assertEquals((Object)attachment, (Object)e.getAttachment());
        AttachmentBaseTest.assertEquals((int)folderId, (int)e.getFolderId());
        AttachmentBaseTest.assertEquals((int)attachedId, (int)e.getAttachedId());
        AttachmentBaseTest.assertEquals((int)moduleId, (int)e.getModuleId());
        in = null;
        InputStream in2 = null;
        try {
            in2 = e.getAttachedFile();
            in = new FileInputStream(this.testFile);
            OXTestToolkit.assertSameContent(in, in2);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (in2 != null) {
                in.close();
            }
        }
        int id = this.clean.get(0).getId();
        this.attachmentBase.detachFromObject(folderId, attachedId, moduleId, new int[]{id}, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
        e = listener.getEvent();
        AttachmentBaseTest.assertEquals((int)folderId, (int)e.getFolderId());
        AttachmentBaseTest.assertEquals((int)attachedId, (int)e.getAttachedId());
        AttachmentBaseTest.assertEquals((int)moduleId, (int)e.getModuleId());
        AttachmentBaseTest.assertEquals((int)1, (int)e.getDetached().length);
        AttachmentBaseTest.assertEquals((int)id, (int)e.getDetached()[0]);
        this.attachmentBase.removeAttachmentListener((AttachmentListener)listener, moduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckPermissions(int folderId, int attachedId, int moduleId) throws Exception {
        TestAttachmentAuthz authz = new TestAttachmentAuthz();
        this.attachmentBase.addAuthorization((AttachmentAuthorization)authz, moduleId);
        try {
            try {
                AttachmentMetadata attachment = this.getAttachment(this.testFile, folderId, attachedId, moduleId, false);
                this.attachmentBase.attachToObject(attachment, null, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
                this.clean.add(attachment);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayAttach();
            }
            try {
                this.attachmentBase.getAttachment(folderId, attachedId, moduleId, -1, MODE.getContext(), MODE.getUser(), null);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayRead();
            }
            try {
                this.attachmentBase.getAttachedFile(folderId, attachedId, moduleId, -1, MODE.getContext(), MODE.getUser(), null);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayRead();
            }
            try {
                this.attachmentBase.getAttachments(folderId, attachedId, moduleId, MODE.getContext(), MODE.getUser(), null);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayRead();
            }
            try {
                this.attachmentBase.getDelta(folderId, attachedId, moduleId, 0L, false, MODE.getContext(), MODE.getUser(), null);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayRead();
            }
            try {
                this.attachmentBase.getAttachments(folderId, attachedId, moduleId, new AttachmentField[]{AttachmentField.ID_LITERAL}, AttachmentField.ID_LITERAL, 1, MODE.getContext(), MODE.getUser(), null);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayRead();
            }
            try {
                this.attachmentBase.getDelta(folderId, attachedId, moduleId, 0L, false, new AttachmentField[]{AttachmentField.ID_LITERAL}, AttachmentField.ID_LITERAL, 1, MODE.getContext(), MODE.getUser(), null);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayRead();
            }
            try {
                this.attachmentBase.detachFromObject(folderId, attachedId, moduleId, new int[0], MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
                AttachmentBaseTest.fail((String)"Disallow failed");
            }
            catch (OXException x) {
                authz.assertMayDetach();
            }
        }
        finally {
            this.attachmentBase.removeAuthorization((AttachmentAuthorization)authz, moduleId);
        }
    }

    private AttachmentMetadata getAttachment(File file, int folderId, int attachedId, int moduleId, boolean rtfFlag) {
        AttachmentImpl m = new AttachmentImpl();
        m.setFileMIMEType("text/plain");
        m.setFilesize(file.length());
        m.setFilename(file.getName());
        m.setAttachedId(attachedId);
        m.setModuleId(moduleId);
        m.setRtfFlag(rtfFlag);
        m.setFolderId(folderId);
        m.setId(0);
        return m;
    }

    public static final void assertEquals(AttachmentMetadata m1, AttachmentMetadata m2, int clockSkew) {
        if (m1 == null && m2 == null) {
            AttachmentBaseTest.assertTrue((boolean)true);
        }
        if (m1 != null && m2 == null) {
            AttachmentBaseTest.fail((String)(m1 + " != " + m2));
        }
        if (m1 == null && m2 != null) {
            AttachmentBaseTest.fail((String)(m1 + " != " + m2));
        }
        GetSwitch get1 = new GetSwitch(m1);
        GetSwitch get2 = new GetSwitch(m2);
        for (AttachmentField field : AttachmentField.VALUES) {
            if (field == AttachmentField.FILE_ID_LITERAL) continue;
            Object v1 = field.doSwitch((AttachmentField.AttachmentSwitch)get1);
            Object v2 = field.doSwitch((AttachmentField.AttachmentSwitch)get2);
            if (v1 instanceof Date || v2 instanceof Date) {
                AttachmentBaseTest.assertEquals((Date)v1, (Date)v2, clockSkew);
                continue;
            }
            AttachmentBaseTest.assertEquals((Object)v1, (Object)v2);
        }
    }

    public static final void assertEquals(Date d1, Date d2, int clockSkew) {
        long diff = d1.getTime() - d2.getTime();
        if (diff < 0L) {
            diff = -diff;
        }
        AttachmentBaseTest.assertTrue((String)(d1 + " != " + d2 + " diff is " + diff), (diff <= (long)clockSkew ? 1 : 0) != 0);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testFile = new File(System.getProperty("test.propfile"));
        this.attachmentBase = new AttachmentBaseImpl(MODE.getProvider());
        this.attachmentBase.setTransactional(true);
        this.attachmentBase.startTransaction();
        this.clean.clear();
    }

    @Override
    public void tearDown() throws Exception {
        for (AttachmentMetadata m : this.clean) {
            this.attachmentBase.detachFromObject(m.getFolderId(), m.getAttachedId(), m.getModuleId(), new int[]{m.getId()}, MODE.getSession(), MODE.getContext(), MODE.getUser(), null);
        }
        this.clean.clear();
        this.attachmentBase.commit();
        this.attachmentBase.finish();
        super.tearDown();
    }

    @Override
    public Mode getMode() {
        return MODE;
    }

    private static final class TestAttachmentAuthz
    implements AttachmentAuthorization {
        private int checked = -1;

        private TestAttachmentAuthz() {
        }

        public void checkMayAttach(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
            this.checked = 1;
            throw OXException.noPermissionForModule((String)Module.INFOSTORE.getName());
        }

        public void checkMayDetach(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
            this.checked = 2;
            throw OXException.noPermissionForModule((String)Module.INFOSTORE.getName());
        }

        public void checkMayReadAttachments(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
            this.checked = 3;
            throw OXException.noPermissionForModule((String)Module.INFOSTORE.getName());
        }

        public void assertMayAttach() {
            Assert.assertEquals((int)1, (int)this.checked);
        }

        public void assertMayDetach() {
            Assert.assertEquals((int)2, (int)this.checked);
        }

        public void assertMayRead() {
            Assert.assertEquals((int)3, (int)this.checked);
        }
    }

    private static final class TestAttachmentListener
    implements AttachmentListener {
        private AttachmentEvent e;

        private TestAttachmentListener() {
        }

        public long attached(AttachmentEvent e) throws Exception {
            this.e = e;
            return System.currentTimeMillis();
        }

        public long detached(AttachmentEvent e) throws Exception {
            this.e = e;
            return System.currentTimeMillis();
        }

        public AttachmentEvent getEvent() {
            return this.e;
        }
    }

    public static class STATIC
    extends AbstractAttachmentTest.ISOLATION
    implements Mode {
        @Override
        public DBProvider getProvider() {
            ConfigurableDBProvider provider = new ConfigurableDBProvider();
            try {
                provider.setDriver("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                System.err.println("Can't find MySQL Driver. Add mysql.jar to the classpath");
            }
            provider.setUrl("jdbc:mysql://localhost/openexchange");
            provider.setLogin("openexchange");
            provider.setPassword("secret");
            return provider;
        }

        @Override
        public Session getSession() {
            return SessionObjectWrapper.createSessionObject((int)this.getUser().getId(), (Context)this.getContext(), (String)String.valueOf(System.currentTimeMillis()));
        }

        @Override
        public Context getContext() {
            return new ContextImpl(1);
        }

        @Override
        public User getUser() {
            MockUser u = new MockUser(23);
            return u;
        }

        @Override
        public void setUp() throws Exception {
        }
    }

    public static class INTEGRATION
    extends AbstractAttachmentTest.INTEGRATION
    implements Mode {
        @Override
        public DBProvider getProvider() {
            return new DBPoolProvider();
        }

        @Override
        public Session getSession() {
            return SessionObjectWrapper.createSessionObject((int)this.getUser().getId(), (Context)this.getContext(), (String)String.valueOf(System.currentTimeMillis()));
        }

        @Override
        public Context getContext() {
            try {
                TestConfig config = new TestConfig();
                TestContextToolkit tools = new TestContextToolkit();
                String ctxName = config.getContextName();
                return null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
            }
            catch (OXException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public User getUser() {
            try {
                UserStorage users = UserStorage.getInstance();
                Context ctx = this.getContext();
                TestConfig config = new TestConfig();
                int id = users.getUserId(INTEGRATION.getUsername(config.getUser()), ctx);
                return users.getUser(id, ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static String getUsername(String un) {
            int pos = un.indexOf(64);
            return pos == -1 ? un : un.substring(0, pos);
        }
    }

    public static class ISOLATION
    extends AbstractAttachmentTest.ISOLATION
    implements Mode {
        @Override
        public DBProvider getProvider() {
            return null;
        }

        @Override
        public Context getContext() {
            return null;
        }

        @Override
        public User getUser() {
            return null;
        }

        @Override
        public Session getSession() {
            return null;
        }
    }

    public static interface Mode
    extends AbstractAttachmentTest.Mode {
        public DBProvider getProvider();

        public Context getContext();

        public Session getSession();

        public User getUser();
    }
}

