/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.calendar.CalendarSql;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.groupware.CalendarTest;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.tools.oxfolder.OXFolderTools;
import java.sql.Connection;
import junit.framework.TestCase;

public class AppointmentAttachmentTest
extends TestCase {
    private int userid = 11;
    private Context context;
    private SessionObject session;

    protected void setUp() throws Exception {
        super.setUp();
        EventConfigImpl event = new EventConfigImpl();
        event.setEventQueueEnabled(false);
        this.userid = CalendarTest.getUserId();
        this.context = CalendarTest.getContext();
        this.session = CalendarTest.getSession();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAttachAndDetachToAppointment() throws Exception {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setContext(this.context);
        cdao.setTitle("testAttachAndDetachToAppointment");
        Connection readcon = DBPool.pickup((Context)this.context);
        int fid = OXFolderTools.getCalendarDefaultFolder((int)this.userid, (Context)cdao.getContext(), (Connection)readcon);
        DBPool.push((Context)this.context, (Connection)readcon);
        cdao.setParentFolderID(fid);
        CalendarTest.fillDatesInDao(cdao);
        SessionObject sessionobject = SessionObjectWrapper.createSessionObject((int)this.userid, (Context)this.context, (String)"AttachmentTestId");
        CalendarSql csql = new CalendarSql((Session)sessionobject);
        cdao.setIgnoreConflicts(true);
        CalendarDataObject[] conflicts = csql.insertAppointmentObject(cdao);
        int oid = cdao.getObjectID();
        AppointmentAttachmentTest.assertTrue((String)"Got no object_id", (oid != 0 ? 1 : 0) != 0);
        AppointmentAttachmentTest.assertTrue((String)"Got no conflicts ", (conflicts == null ? 1 : 0) != 0);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, 1);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, 1);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, 1);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, 1);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, -1);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, -1);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, -1);
        csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, -1);
        long last_modified = 0L;
        try {
            long check_modified = System.currentTimeMillis();
            last_modified = csql.attachmentAction(fid, oid, this.userid, (Session)this.session, this.context, -1);
            AppointmentAttachmentTest.assertTrue((String)"Check for last_modified ", (last_modified > check_modified ? 1 : 0) != 0);
        }
        catch (Exception e) {
            return;
        }
        throw new Exception("Test failed because detach should not be possible!");
    }
}

