/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.ThrowableHolder;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;

public class DeleteTest
extends CardDAVTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testDeleteContactOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "banane";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = DeleteTest.assertContains(uid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        super.delete(contact);
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        eTags = syncCollectionResponse.getETagsStatusOK();
    }

    public void testDeleteContactInSubfolderOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + DeleteTest.randomUID();
        FolderObject folder = super.createFolder(folderName);
        super.rememberForCleanUp(folder);
        String uid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "otto";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, folder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = DeleteTest.assertContains(uid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getVCard().getFormattedName().getFormattedName());
        super.delete(contact);
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
    }

    public void testDeleteContactOnClient() throws Throwable {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "manfred";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = DeleteTest.assertContains(uid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        DeleteTest.assertEquals((String)"response code wrong", (int)200, (int)this.delete(uid));
        DeleteTest.assertNull((String)"contact not deleted on server", (Object)super.getContact(uid));
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        eTags = syncCollectionResponse.getETagsStatusOK();
    }

    public void testDeleteContactInGroupOnClient() throws Throwable {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String contactUid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "klaus";
        String email = "test.klaus@example.org";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setEmail1(email);
        contact.setUid(contactUid);
        super.rememberForCleanUp(super.create(contact));
        Contact otherContact = new Contact();
        otherContact.setSurName("Anders");
        otherContact.setGivenName("Otto");
        super.rememberForCleanUp(super.create(otherContact));
        Contact furtherContact = new Contact();
        furtherContact.setSurName("Anders");
        furtherContact.setGivenName("Horst");
        super.rememberForCleanUp(super.create(furtherContact));
        String listUid = DeleteTest.randomUID();
        String listName = "test distribution list";
        Contact distributionList = new Contact();
        distributionList.setDisplayName(listName);
        distributionList.setUid(listUid);
        distributionList.setMarkAsDistributionlist(true);
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{DeleteTest.asDistListMember(otherContact), DeleteTest.asDistListMember(contact), DeleteTest.asDistListMember(furtherContact)};
        distributionList.setDistributionList(members);
        super.rememberForCleanUp(super.create(distributionList));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = DeleteTest.assertContains(contactUid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        final VCardResource groupVCard = DeleteTest.assertContains(listUid, addressData);
        DeleteTest.assertEquals((String)"FN wrong", (String)listName, (String)groupVCard.getFN());
        DeleteTest.assertContainsMemberUID(contactUid, groupVCard);
        groupVCard.getVCard().removeExtendedType(groupVCard.getMemberXFeature(contactUid));
        final ThrowableHolder throwableHolder = new ThrowableHolder();
        Thread updateThread = new Thread(){

            @Override
            public void run() {
                try {
                    Assert.assertEquals((String)"response code wrong", (int)201, (int)DeleteTest.this.putVCardUpdate(groupVCard.getUID(), groupVCard.toString(), groupVCard.getETag()));
                }
                catch (Throwable t) {
                    throwableHolder.setThrowable(t);
                }
            }
        };
        updateThread.start();
        DeleteTest.assertEquals((String)"response code wrong", (int)200, (int)this.delete(contactUid));
        updateThread.join();
        throwableHolder.reThrowIfSet();
        DeleteTest.assertNull((String)"contact not deleted on server", (Object)super.getContact(contactUid));
        distributionList = super.getContact(listUid);
        DeleteTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList);
        DeleteTest.assertEquals((String)"uid wrong", (String)listUid, (String)distributionList.getUid());
        DeleteTest.assertEquals((String)"displayname wrong", (String)listName, (String)distributionList.getDisplayName());
        DeleteTest.assertNotNull((String)"no members in distribution list", (Object)distributionList.getDistributionList());
        DeleteTest.assertTrue((String)"invalid member count in distribution list", (2 == distributionList.getNumberOfDistributionLists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"invalid member count in distribution list", (2 == distributionList.getDistributionList().length ? 1 : 0) != 0);
        for (DistributionListEntryObject member : distributionList.getDistributionList()) {
            DeleteTest.assertFalse((String)"deleted member still in list", (boolean)email.equals(member.getEmailaddress()));
        }
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        eTags = syncCollectionResponse.getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource groupCard = DeleteTest.assertContains(listUid, addressData);
        DeleteTest.assertNotContainsMemberUID(contactUid, groupCard);
    }

    public void testRemoveContactFromGroupOnClient() throws Throwable {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String contactUid = DeleteTest.randomUID();
        String firstName = "test";
        String lastName = "heinz";
        String email = "test.heinz@example.org";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setEmail1(email);
        contact.setUid(contactUid);
        super.rememberForCleanUp(super.create(contact));
        Contact otherContact = new Contact();
        otherContact.setSurName("Harry");
        otherContact.setGivenName("Lustig");
        super.rememberForCleanUp(super.create(otherContact));
        Contact furtherContact = new Contact();
        furtherContact.setSurName("Heiner");
        furtherContact.setGivenName("Heiter");
        super.rememberForCleanUp(super.create(furtherContact));
        String listUid = DeleteTest.randomUID();
        String listName = "test list";
        Contact distributionList = new Contact();
        distributionList.setDisplayName(listName);
        distributionList.setUid(listUid);
        distributionList.setMarkAsDistributionlist(true);
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{DeleteTest.asDistListMember(otherContact), DeleteTest.asDistListMember(contact), DeleteTest.asDistListMember(furtherContact)};
        distributionList.setDistributionList(members);
        super.rememberForCleanUp(super.create(distributionList));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = DeleteTest.assertContains(contactUid, addressData);
        DeleteTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        DeleteTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        DeleteTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        VCardResource groupVCard = DeleteTest.assertContains(listUid, addressData);
        DeleteTest.assertEquals((String)"FN wrong", (String)listName, (String)groupVCard.getFN());
        DeleteTest.assertContainsMemberUID(contactUid, groupVCard);
        groupVCard.getVCard().removeExtendedType(groupVCard.getMemberXFeature(contactUid));
        DeleteTest.assertEquals((String)"response code wrong", (int)201, (int)this.putVCardUpdate(groupVCard.getUID(), groupVCard.toString(), groupVCard.getETag()));
        DeleteTest.assertNotNull((String)"contact deleted on server", (Object)super.getContact(contactUid));
        distributionList = super.getContact(listUid);
        DeleteTest.assertNotNull((String)"distribution list not found on server", (Object)distributionList);
        DeleteTest.assertEquals((String)"uid wrong", (String)listUid, (String)distributionList.getUid());
        DeleteTest.assertEquals((String)"displayname wrong", (String)listName, (String)distributionList.getDisplayName());
        DeleteTest.assertNotNull((String)"no members in distribution list", (Object)distributionList.getDistributionList());
        DeleteTest.assertTrue((String)"invalid member count in distribution list", (2 == distributionList.getNumberOfDistributionLists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"invalid member count in distribution list", (2 == distributionList.getDistributionList().length ? 1 : 0) != 0);
        for (DistributionListEntryObject member : distributionList.getDistributionList()) {
            DeleteTest.assertFalse((String)"removed member still in list", (boolean)email.equals(member.getEmailaddress()));
        }
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        DeleteTest.assertTrue((String)"deletions were reported on sync collection", (0 == syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        eTags = syncCollectionResponse.getETagsStatusOK();
        DeleteTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource groupCard = DeleteTest.assertContains(listUid, addressData);
        DeleteTest.assertNotContainsMemberUID(contactUid, groupCard);
    }
}

