/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import com.openexchange.data.conversion.ical.AbstractICalParserTest;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Task;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;

public class ICalParserBasicTests
extends AbstractICalParserTest {
    public void testAppStartToEndWithUTC() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithLocalDTStartAndDTEnd(start, end);
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)start, (Object)appointment.getStartDate());
        ICalParserBasicTests.assertEquals((Object)end, (Object)appointment.getEndDate());
        ICalParserBasicTests.assertEquals((String)"UTC", (String)appointment.getTimezone());
    }

    public void testAppStartToEnd() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        String icalText = this.fixtures.veventWithUTCDTStartAndDTEnd(start, end);
        TimeZone defaultTZone = TimeZone.getDefault();
        CalendarDataObject appointment = this.parseAppointment(icalText, defaultTZone);
        ICalParserBasicTests.assertEquals((Object)start, (Object)appointment.getStartDate());
        ICalParserBasicTests.assertEquals((Object)end, (Object)appointment.getEndDate());
        ICalParserBasicTests.assertEquals((String)defaultTZone.getID(), (String)appointment.getTimezone());
    }

    public void testAppStartToEndWithKnownTZID() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        TimeZone timeZone = TimeZone.getTimeZone("America/Los_Angeles");
        ICalParserBasicTests.assertFalse((String)"Bad test TimeZone", (boolean)timeZone.equals(TimeZone.getDefault()));
        String icalText = this.fixtures.veventWithDTStartAndEndInTimeZone(start, end, timeZone);
        CalendarDataObject appointment = this.parseAppointment(icalText, timeZone);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.recalculate(start, utc, timeZone), (Object)appointment.getStartDate());
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.recalculate(end, utc, timeZone), (Object)appointment.getEndDate());
        ICalParserBasicTests.assertEquals((String)timeZone.getID(), (String)appointment.getTimezone());
    }

    public void testAppStartToEndWithVTimeZone() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone defaultTzone = TimeZone.getDefault();
        String icalText = this.fixtures.veventWithDTStartAndDTEndInCustomTimezone(start, end);
        CalendarDataObject appointment = this.parseAppointment(icalText, defaultTzone);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("24/02/1981 01:00"), (Object)appointment.getStartDate());
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("24/02/1981 03:00"), (Object)appointment.getEndDate());
        ICalParserBasicTests.assertEquals((String)defaultTzone.getID(), (String)appointment.getTimezone());
    }

    public void testDTSTARTAsDateWithoutValue() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 00:00");
        String icalText = this.fixtures.veventWithDTStartAsDateWithoutValue(start);
        CalendarDataObject appointment = this.parseAppointment(icalText);
        ICalParserBasicTests.assertNotNull((Object)appointment.getStartDate());
    }

    public void testAppDuration() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        String duration = "P2H";
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithLocalDTStartAndDuration(start, "P2H");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)start, (Object)appointment.getStartDate());
        ICalParserBasicTests.assertEquals((Object)end, (Object)appointment.getEndDate());
        ICalParserBasicTests.assertEquals((String)"UTC", (String)appointment.getTimezoneFallbackUTC());
    }

    public void testAppPrivateFlag() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "CLASS", "PRIVATE");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertTrue((boolean)appointment.getPrivateFlag());
        icalText = this.fixtures.veventWithSimpleProperties(start, end, "CLASS", "PUBLIC");
        appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertFalse((boolean)appointment.getPrivateFlag());
    }

    public void testAppCreated() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "CREATED", "20081023T100000Z");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/10/2008 10:00"), (Object)appointment.getCreationDate());
    }

    public void testAppLastModified() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "LAST-MODIFIED", "20081023T100000Z");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/10/2008 10:00"), (Object)appointment.getLastModified());
    }

    public void testAppDTSTAMP() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "DTSTAMP", "20081023T100000Z");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/10/2008 10:00"), (Object)appointment.getCreationDate());
    }

    public void testAppNote() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "DESCRIPTION", "A fine description");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"A fine description", (String)appointment.getNote());
    }

    public void testAppLocation() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "LOCATION", "Mars");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"Mars", (String)appointment.getLocation());
    }

    public void testAppTitle() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "SUMMARY", "A fine title");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"A fine title", (String)appointment.getTitle());
    }

    public void testAppReserved() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "TRANSP", "OPAQUE");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((int)1, (int)appointment.getShownAs());
    }

    public void testAppFree() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "TRANSP", "TRANSPARENT");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((int)4, (int)appointment.getShownAs());
    }

    public void testAppAttendees() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String[] mails = new String[3];
        int i = 0;
        for (User user : this.U(1, 2, 5)) {
            mails[i++] = user.getMail();
        }
        String icalText = this.fixtures.veventWithAttendees(start, end, mails);
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        HashSet<Integer> ids = new HashSet<Integer>(Arrays.asList(1, 2, 5));
        ICalParserBasicTests.assertNotNull((Object)appointment.getParticipants());
        for (Participant p : appointment.getParticipants()) {
            ICalParserBasicTests.assertTrue((boolean)UserParticipant.class.isAssignableFrom(p.getClass()));
            UserParticipant participant = (UserParticipant)p;
            ICalParserBasicTests.assertTrue((boolean)ids.remove(participant.getIdentifier()));
        }
        ICalParserBasicTests.assertTrue((boolean)ids.isEmpty());
        mails = new String[]{"mickey@disney.invalid", "donald@disney.invalid", "goofy@disney.invalid"};
        icalText = this.fixtures.veventWithAttendees(start, end, mails);
        appointment = this.parseAppointment(icalText, utc);
        HashSet<String> mailSet = new HashSet<String>(Arrays.asList(mails));
        ICalParserBasicTests.assertNotNull((Object)appointment.getParticipants());
        for (Participant p : appointment.getParticipants()) {
            ICalParserBasicTests.assertTrue((boolean)ExternalUserParticipant.class.isAssignableFrom(p.getClass()));
            ExternalUserParticipant participant = (ExternalUserParticipant)p;
            ICalParserBasicTests.assertTrue((boolean)mailSet.remove(participant.getEmailAddress()));
        }
        ICalParserBasicTests.assertTrue((boolean)mailSet.isEmpty());
    }

    public void testAppResources() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String[] resources = new String[]{"Toaster", "Deflector", "Subspace Anomaly"};
        String icalText = this.fixtures.veventWithResources(start, end, resources);
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        HashSet<Integer> resourceSet = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        ICalParserBasicTests.assertNotNull((Object)appointment.getParticipants());
        for (Participant p : appointment.getParticipants()) {
            ICalParserBasicTests.assertTrue((boolean)ResourceParticipant.class.isAssignableFrom(p.getClass()));
            ResourceParticipant participant = (ResourceParticipant)p;
            ICalParserBasicTests.assertTrue((boolean)resourceSet.remove(participant.getIdentifier()));
        }
        ICalParserBasicTests.assertTrue((boolean)resourceSet.isEmpty());
    }

    public void testAppResourcesInParticipants() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String[] resources = new String[]{"Toaster", "Deflector", "Subspace Anomaly"};
        String icalText = this.fixtures.veventWithResourcesInAttendees(start, end, resources);
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        HashSet<Integer> resourceSet = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        ICalParserBasicTests.assertNotNull((Object)appointment.getParticipants());
        for (Participant p : appointment.getParticipants()) {
            ICalParserBasicTests.assertTrue((boolean)ResourceParticipant.class.isAssignableFrom(p.getClass()));
            ResourceParticipant participant = (ResourceParticipant)p;
            ICalParserBasicTests.assertTrue((String)("Didn't expect: " + participant.getIdentifier()), (boolean)resourceSet.remove(participant.getIdentifier()));
        }
        ICalParserBasicTests.assertTrue((String)((Object)resourceSet).toString(), (boolean)resourceSet.isEmpty());
    }

    public void testAppCategories() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String[] categories = new String[]{"Toaster", "Deflector", "Subspace Anomaly"};
        String categoriesString = "Toaster,Deflector,Subspace Anomaly";
        String icalText = this.fixtures.veventWithCategories(start, end, categories);
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"Toaster,Deflector,Subspace Anomaly", (String)appointment.getCategories());
    }

    public void testAppRecurrence() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        Appointment appointment = this.appointmentWithRecurrence("FREQ=DAILY;INTERVAL=2;COUNT=3", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getOccurrence());
        ICalParserBasicTests.assertEquals((int)1, (int)appointment.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getInterval());
        appointment = this.appointmentWithRecurrence("FREQ=WEEKLY;INTERVAL=2;COUNT=3;BYDAY=MO,WE,FR", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getOccurrence());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getInterval());
        int days = appointment.getDays();
        ICalParserBasicTests.assertTrue((2 == (2 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((8 == (8 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((32 == (0x20 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((4 == (4 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((16 == (0x10 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((64 == (0x40 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((1 == (1 & days) ? 1 : 0) != 0);
        appointment = this.appointmentWithRecurrence("FREQ=WEEKLY;INTERVAL=2;COUNT=3", start, end);
        days = appointment.getDays();
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getOccurrence());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getInterval());
        ICalParserBasicTests.assertTrue((4 == (4 & days) ? 1 : 0) != 0);
        appointment = this.appointmentWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3;BYMONTHDAY=23", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getOccurrence());
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getInterval());
        ICalParserBasicTests.assertEquals((int)23, (int)appointment.getDayInMonth());
        appointment = this.appointmentWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3;BYDAY=MO,TU;BYSETPOS=3", start, end);
        days = appointment.getDays();
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getDayInMonth());
        ICalParserBasicTests.assertTrue((2 == (2 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((4 == (4 & days) ? 1 : 0) != 0);
        appointment = this.appointmentWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3;BYDAY=TU;BYSETPOS=-1", start, end);
        days = appointment.getDays();
        ICalParserBasicTests.assertEquals((int)5, (int)appointment.getDayInMonth());
        ICalParserBasicTests.assertTrue((4 == (4 & days) ? 1 : 0) != 0);
        appointment = this.appointmentWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3", start, end);
        ICalParserBasicTests.assertEquals((int)24, (int)appointment.getDayInMonth());
        appointment = this.appointmentWithRecurrence("FREQ=YEARLY;INTERVAL=2;COUNT=3;BYMONTHDAY=23;BYMONTH=3", start, end);
        ICalParserBasicTests.assertEquals((int)4, (int)appointment.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getMonth());
        ICalParserBasicTests.assertEquals((int)23, (int)appointment.getDayInMonth());
        appointment = this.appointmentWithRecurrence("FREQ=YEARLY;INTERVAL=2;COUNT=3;BYDAY=MO,WE;BYMONTH=4;BYSETPOS=2", start, end);
        days = appointment.getDays();
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getMonth());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getDayInMonth());
        ICalParserBasicTests.assertTrue((2 == (2 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((8 == (8 & days) ? 1 : 0) != 0);
        appointment = this.appointmentWithRecurrence("FREQ=YEARLY;BYDAY=2SU;BYMONTH=4", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getMonth());
        ICalParserBasicTests.assertEquals((int)2, (int)appointment.getDayInMonth());
        ICalParserBasicTests.assertEquals((int)1, (int)appointment.getDays());
        ICalParserBasicTests.assertEquals((int)1, (int)appointment.getInterval());
        appointment = this.appointmentWithRecurrence("FREQ=YEARLY;BYDAY=-1SU;BYMONTH=4", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)appointment.getMonth());
        ICalParserBasicTests.assertEquals((int)5, (int)appointment.getDayInMonth());
        ICalParserBasicTests.assertEquals((int)1, (int)appointment.getDays());
        ICalParserBasicTests.assertEquals((int)1, (int)appointment.getInterval());
        appointment = this.appointmentWithRecurrence("FREQ=YEARLY;INTERVAL=2;COUNT=3", start, end);
        ICalParserBasicTests.assertEquals((int)4, (int)appointment.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)1, (int)appointment.getMonth());
        ICalParserBasicTests.assertEquals((int)24, (int)appointment.getDayInMonth());
        appointment = this.appointmentWithRecurrence("FREQ=YEARLY;INTERVAL=2;UNTIL=19890423", start, end);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/04/1989 00:00"), (Object)appointment.getUntil());
    }

    public void testAppDeleteExceptions() throws ConversionError {
        Date start = CommonAppointments.D("24/01/1981 10:00");
        Date end = CommonAppointments.D("24/01/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String rrule = "FREQ=DAILY;INTERVAL=2;COUNT=5";
        Date[] exceptions = new Date[]{CommonAppointments.D("26/01/1981 12:00"), CommonAppointments.D("30/01/1981 12:00")};
        String icalText = this.fixtures.veventWithDeleteExceptionsAsDateTime(start, end, "FREQ=DAILY;INTERVAL=2;COUNT=5", exceptions);
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        HashSet<Date> expectedExceptions = new HashSet<Date>(Arrays.asList(CommonAppointments.D("26/01/1981 00:00"), CommonAppointments.D("30/01/1981 00:00")));
        ICalParserBasicTests.assertNotNull((Object)appointment.getDeleteException());
        for (Date exception : appointment.getDeleteException()) {
            ICalParserBasicTests.assertTrue((String)("Didn't expect: " + exception + " Expected one of: " + expectedExceptions), (boolean)expectedExceptions.remove(exception));
        }
        ICalParserBasicTests.assertTrue((boolean)expectedExceptions.isEmpty());
        icalText = this.fixtures.veventWithDeleteExceptionsAsDate(start, end, "FREQ=DAILY;INTERVAL=2;COUNT=5", exceptions);
        appointment = this.parseAppointment(icalText, utc);
        expectedExceptions = new HashSet<Date>(Arrays.asList(CommonAppointments.D("26/01/1981 00:00"), CommonAppointments.D("30/01/1981 00:00")));
        ICalParserBasicTests.assertNotNull((Object)appointment.getDeleteException());
        for (Date exception : appointment.getDeleteException()) {
            ICalParserBasicTests.assertTrue((String)("Didn't expect: " + exception + " Expected one of: " + expectedExceptions), (boolean)expectedExceptions.remove(exception));
        }
        ICalParserBasicTests.assertTrue((boolean)expectedExceptions.isEmpty());
        ICalParserBasicTests.assertEquals((String)"UTC", (String)appointment.getTimezoneFallbackUTC());
    }

    public void testAppAlarms() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        boolean MINUTES = true;
        String icalText = this.fixtures.veventWithDisplayAlarm(start, end, "TRIGGER:-PT15M", "Description");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((int)15, (int)appointment.getAlarm());
        ICalParserBasicTests.assertTrue((boolean)appointment.getAlarmFlag());
        icalText = this.fixtures.veventWithDisplayAlarm(start, end, "TRIGGER;RELATED=START:-PT20M", "Description");
        appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((int)20, (int)appointment.getAlarm());
        ICalParserBasicTests.assertTrue((boolean)appointment.getAlarmFlag());
        icalText = this.fixtures.veventWithDisplayAlarm(start, end, "TRIGGER;VALUE=DATE-TIME:19810224T091000", "Description");
        appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((int)50, (int)appointment.getAlarm());
        ICalParserBasicTests.assertTrue((boolean)appointment.getAlarmFlag());
    }

    public void testAppFullTime() throws ConversionError {
        String icalText = this.fixtures.veventWithWholeDayEvent(CommonAppointments.D("24/02/1990 12:00"));
        CalendarDataObject appointment = this.parseAppointment(icalText);
        ICalParserBasicTests.assertTrue((boolean)appointment.getFullTime());
        Calendar start = Calendar.getInstance();
        start.setTimeZone(TimeZone.getTimeZone("UTC"));
        start.setTime(appointment.getStartDate());
        ICalParserBasicTests.assertEquals((int)1990, (int)start.get(1));
        ICalParserBasicTests.assertEquals((int)1, (int)start.get(2));
        ICalParserBasicTests.assertEquals((int)24, (int)start.get(5));
        ICalParserBasicTests.assertEquals((int)0, (int)start.get(11));
        ICalParserBasicTests.assertEquals((int)0, (int)start.get(12));
        ICalParserBasicTests.assertEquals((int)0, (int)start.get(13));
        Calendar end = Calendar.getInstance();
        end.setTimeZone(TimeZone.getTimeZone("UTC"));
        end.setTime(appointment.getEndDate());
        ICalParserBasicTests.assertEquals((int)1990, (int)end.get(1));
        ICalParserBasicTests.assertEquals((int)1, (int)end.get(2));
        ICalParserBasicTests.assertEquals((int)25, (int)end.get(5));
        ICalParserBasicTests.assertEquals((int)0, (int)end.get(11));
        ICalParserBasicTests.assertEquals((int)0, (int)end.get(12));
        ICalParserBasicTests.assertEquals((int)0, (int)end.get(13));
    }

    public void testAppUid() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "UID", "nrw3rn2983nxi");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"nrw3rn2983nxi", (String)appointment.getUid());
    }

    public void testAppRecurrenceID() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        Date rdp = CommonAppointments.D("29/06/2011 00:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "RECURRENCE-ID", "20110629T160000");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((long)rdp.getTime(), (long)appointment.getRecurrenceDatePosition().getTime());
    }

    public void testAppOrganizer() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "ORGANIZER", "mailto:bla@example.invalid");
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"bla@example.invalid", (String)appointment.getOrganizer());
    }

    public void testTskTitle() throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("SUMMARY", "A nice title");
        Task task = this.parseTask(icalText, TimeZone.getTimeZone("UTC"));
        ICalParserBasicTests.assertEquals((String)"A nice title", (String)task.getTitle());
    }

    public void testTskCreated() throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("CREATED", "20081023T100000Z");
        Task task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/10/2008 10:00"), (Object)task.getCreationDate());
    }

    public void testTskLastModified() throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("LAST-MODIFIED", "20081023T100000Z");
        Task task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/10/2008 10:00"), (Object)task.getLastModified());
    }

    public void testTskDTSTAMP() throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("DTSTAMP", "20081023T100000Z");
        Task task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/10/2008 10:00"), (Object)task.getCreationDate());
    }

    public void testTskNote() throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("DESCRIPTION", "A nice description");
        Task task = this.parseTask(icalText, TimeZone.getTimeZone("UTC"));
        ICalParserBasicTests.assertEquals((String)"A nice description", (String)task.getNote());
    }

    public void testTskStartToEnd() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithLocalDTStartAndDue(start, end);
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)start, (Object)task.getStartDate());
        ICalParserBasicTests.assertEquals((Object)end, (Object)task.getEndDate());
        icalText = this.fixtures.vtodoWithUTCDTStartAndDue(start, end);
        task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((Object)start, (Object)task.getStartDate());
        ICalParserBasicTests.assertEquals((Object)end, (Object)task.getEndDate());
        TimeZone timeZone = TimeZone.getTimeZone("America/Los_Angeles");
        ICalParserBasicTests.assertFalse((String)"Bad test TimeZone", (boolean)timeZone.equals(TimeZone.getDefault()));
        icalText = this.fixtures.vtodoWithDTStartAndDueInTimeZone(start, end, timeZone);
        task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.recalculate(start, utc, timeZone), (Object)task.getStartDate());
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.recalculate(end, utc, timeZone), (Object)task.getEndDate());
        icalText = this.fixtures.vtodoWithDTStartAndDueInCustomTimezone(start, end);
        task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("24/02/1981 01:00"), (Object)task.getStartDate());
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("24/02/1981 03:00"), (Object)task.getEndDate());
    }

    public void testTskDuration() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        String duration = "P2H";
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithLocalDTStartAndDuration(start, "P2H");
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)start, (Object)task.getStartDate());
        ICalParserBasicTests.assertEquals((Object)end, (Object)task.getEndDate());
    }

    public void testTskDue() throws ConversionError {
        Date due = CommonAppointments.D("24/03/1981 10:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithDueDate(due);
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)due, (Object)task.getEndDate());
    }

    public void testTskDueWithoutTimeZone() throws ConversionError {
        Date due = CommonAppointments.D("31/07/2007 10:00");
        TimeZone utc = TimeZone.getTimeZone("Europe/Berlin");
        String icalText = this.fixtures.vtodoWithDueDateWithoutTZ(due);
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("31/07/2007 00:00"), (Object)task.getEndDate());
    }

    public void testTskPrivateFlag() throws ConversionError {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithSimpleProperties("CLASS", "PRIVATE");
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertTrue((boolean)task.getPrivateFlag());
        icalText = this.fixtures.vtodoWithSimpleProperties("CLASS", "PUBLIC");
        task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertFalse((boolean)task.getPrivateFlag());
    }

    public void testTskDateCompleted() throws ConversionError {
        Date dateCompleted = CommonAppointments.D("24/03/1981 10:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithDateCompleted(dateCompleted);
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)dateCompleted, (Object)task.getDateCompleted());
    }

    public void testTskPercentComplete() throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("PERCENT-COMPLETE", "23");
        Task task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((int)23, (int)task.getPercentComplete());
    }

    public void testTskPriority() throws ConversionError {
        this.priorityTest(1, 3);
        this.priorityTest(2, 3);
        this.priorityTest(3, 2);
        this.priorityTest(4, 2);
        this.priorityTest(5, 2);
        this.priorityTest(6, 2);
        this.priorityTest(7, 1);
        this.priorityTest(8, 1);
        this.priorityTest(9, 1);
    }

    private void priorityTest(int priority, int expected) throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("PRIORITY", new Integer(priority).toString());
        Task task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((String)("Invalid interpretation for priority " + priority), (int)expected, (int)task.getPriority());
    }

    public void testTskPriorityZero() throws ConversionError {
        this.priorityTest(0, 2);
    }

    public void testTskStatus() throws ConversionError {
        this.statusTest("NEEDS-ACTION", 1);
        this.statusTest("IN-PROCESS", 2);
        this.statusTest("COMPLETED", 3);
        this.statusTest("CANCELLED", 5);
    }

    private void statusTest(String status, int expected) throws ConversionError {
        String icalText = this.fixtures.vtodoWithSimpleProperties("STATUS", status);
        Task task = this.parseTask(icalText);
        ICalParserBasicTests.assertEquals((String)("Invalid interpretation for status " + status), (int)expected, (int)task.getStatus());
    }

    public void testTskAttendees() throws ConversionError {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String[] mails = new String[3];
        int i = 0;
        for (User user : this.U(1, 2, 5)) {
            mails[i++] = user.getMail();
        }
        String icalText = this.fixtures.vtodoWithAttendees(mails);
        Task appointment = this.parseTask(icalText, utc);
        HashSet<Integer> ids = new HashSet<Integer>(Arrays.asList(1, 2, 5));
        ICalParserBasicTests.assertNotNull((Object)appointment.getParticipants());
        for (Participant p : appointment.getParticipants()) {
            ICalParserBasicTests.assertTrue((boolean)UserParticipant.class.isAssignableFrom(p.getClass()));
            UserParticipant participant = (UserParticipant)p;
            ICalParserBasicTests.assertTrue((boolean)ids.remove(participant.getIdentifier()));
        }
        ICalParserBasicTests.assertTrue((boolean)ids.isEmpty());
        mails = new String[]{"mickey@disney.invalid", "donald@disney.invalid", "goofy@disney.invalid"};
        icalText = this.fixtures.vtodoWithAttendees(mails);
        appointment = this.parseTask(icalText, utc);
        HashSet<String> mailSet = new HashSet<String>(Arrays.asList(mails));
        ICalParserBasicTests.assertNotNull((Object)appointment.getParticipants());
        for (Participant p : appointment.getParticipants()) {
            ICalParserBasicTests.assertTrue((boolean)ExternalUserParticipant.class.isAssignableFrom(p.getClass()));
            ExternalUserParticipant participant = (ExternalUserParticipant)p;
            ICalParserBasicTests.assertTrue((boolean)mailSet.remove(participant.getEmailAddress()));
        }
        ICalParserBasicTests.assertTrue((boolean)mailSet.isEmpty());
    }

    public void testTskCategories() throws ConversionError {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String[] categories = new String[]{"Toaster", "Deflector", "Subspace Anomaly"};
        String categoriesString = "Toaster,Deflector,Subspace Anomaly";
        String icalText = this.fixtures.vtodoWithCategories(categories);
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"Toaster,Deflector,Subspace Anomaly", (String)task.getCategories());
    }

    public void testTskRecurrence() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        Task task = this.taskWithRecurrence("FREQ=DAILY;INTERVAL=2;COUNT=3", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)task.getRecurrenceCount());
        ICalParserBasicTests.assertEquals((int)1, (int)task.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getInterval());
        task = this.taskWithRecurrence("FREQ=WEEKLY;INTERVAL=2;COUNT=3;BYDAY=MO,WE,FR", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)task.getRecurrenceCount());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getInterval());
        int days = task.getDays();
        ICalParserBasicTests.assertTrue((2 == (2 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((8 == (8 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((32 == (0x20 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((4 == (4 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((16 == (0x10 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((64 == (0x40 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertFalse((1 == (1 & days) ? 1 : 0) != 0);
        task = this.taskWithRecurrence("FREQ=WEEKLY;INTERVAL=2;COUNT=3", start, end);
        days = task.getDays();
        ICalParserBasicTests.assertEquals((int)3, (int)task.getRecurrenceCount());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getInterval());
        ICalParserBasicTests.assertTrue((4 == (4 & days) ? 1 : 0) != 0);
        task = this.taskWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3;BYMONTHDAY=23", start, end);
        ICalParserBasicTests.assertEquals((int)3, (int)task.getRecurrenceCount());
        ICalParserBasicTests.assertEquals((int)3, (int)task.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getInterval());
        ICalParserBasicTests.assertEquals((int)23, (int)task.getDayInMonth());
        task = this.taskWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3;BYDAY=MO,TU;BYSETPOS=3", start, end);
        days = task.getDays();
        ICalParserBasicTests.assertEquals((int)3, (int)task.getDayInMonth());
        ICalParserBasicTests.assertTrue((2 == (2 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((4 == (4 & days) ? 1 : 0) != 0);
        task = this.taskWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3;BYDAY=TU;BYSETPOS=-1", start, end);
        days = task.getDays();
        ICalParserBasicTests.assertEquals((int)5, (int)task.getDayInMonth());
        ICalParserBasicTests.assertTrue((4 == (4 & days) ? 1 : 0) != 0);
        task = this.taskWithRecurrence("FREQ=MONTHLY;INTERVAL=2;COUNT=3", start, end);
        ICalParserBasicTests.assertEquals((int)24, (int)task.getDayInMonth());
        task = this.taskWithRecurrence("FREQ=YEARLY;INTERVAL=2;COUNT=3;BYMONTHDAY=23;BYMONTH=3", start, end);
        ICalParserBasicTests.assertEquals((int)4, (int)task.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getMonth());
        ICalParserBasicTests.assertEquals((int)23, (int)task.getDayInMonth());
        task = this.taskWithRecurrence("FREQ=YEARLY;INTERVAL=2;COUNT=3;BYDAY=MO,WE;BYMONTH=4;BYSETPOS=2", start, end);
        days = task.getDays();
        ICalParserBasicTests.assertEquals((int)3, (int)task.getMonth());
        ICalParserBasicTests.assertEquals((int)2, (int)task.getDayInMonth());
        ICalParserBasicTests.assertTrue((2 == (2 & days) ? 1 : 0) != 0);
        ICalParserBasicTests.assertTrue((8 == (8 & days) ? 1 : 0) != 0);
        task = this.taskWithRecurrence("FREQ=YEARLY;INTERVAL=2;COUNT=3", start, end);
        ICalParserBasicTests.assertEquals((int)4, (int)task.getRecurrenceType());
        ICalParserBasicTests.assertEquals((int)1, (int)task.getMonth());
        ICalParserBasicTests.assertEquals((int)24, (int)task.getDayInMonth());
        task = this.taskWithRecurrence("FREQ=YEARLY;INTERVAL=2;UNTIL=19890423", start, end);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("23/04/1989 00:00"), (Object)task.getUntil());
    }

    public void notestTskDeleteExceptions() throws ConversionError {
        Date start = CommonAppointments.D("24/01/1981 10:00");
        Date end = CommonAppointments.D("24/01/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String rrule = "FREQ=DAILY;INTERVAL=2;COUNT=5";
        Date[] exceptions = new Date[]{CommonAppointments.D("26/01/1981 12:00"), CommonAppointments.D("30/01/1981 12:00")};
        String icalText = this.fixtures.vtodoWithDeleteExceptionsAsDateTime(start, end, "FREQ=DAILY;INTERVAL=2;COUNT=5", exceptions);
        Task task = this.parseTask(icalText, utc);
        HashSet<Date> expectedExceptions = new HashSet<Date>(Arrays.asList(exceptions));
        ICalParserBasicTests.assertNotNull((Object)task.getDeleteException());
        for (Date exception : task.getDeleteException()) {
            ICalParserBasicTests.assertTrue((String)("Didn't expect: " + exception + " Expected one of: " + expectedExceptions), (boolean)expectedExceptions.remove(exception));
        }
        ICalParserBasicTests.assertTrue((boolean)expectedExceptions.isEmpty());
        icalText = this.fixtures.vtodoWithDeleteExceptionsAsDate(start, end, "FREQ=DAILY;INTERVAL=2;COUNT=5", exceptions);
        task = this.parseTask(icalText, utc);
        expectedExceptions = new HashSet<Date>(Arrays.asList(CommonAppointments.D("26/01/1981 00:00"), CommonAppointments.D("30/01/1981 00:00")));
        ICalParserBasicTests.assertNotNull((Object)task.getDeleteException());
        for (Date exception : task.getDeleteException()) {
            ICalParserBasicTests.assertTrue((String)("Didn't expect: " + exception + " Expected one of: " + expectedExceptions), (boolean)expectedExceptions.remove(exception));
        }
        ICalParserBasicTests.assertTrue((boolean)expectedExceptions.isEmpty());
    }

    public void testTskAlarms() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithDisplayAlarm(start, end, "TRIGGER:-PT15M", "Description");
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("24/02/1981 09:45"), (Object)task.getAlarm());
        ICalParserBasicTests.assertTrue((boolean)task.getAlarmFlag());
        icalText = this.fixtures.vtodoWithDisplayAlarm(start, end, "TRIGGER;RELATED=START:-PT20M", "Description");
        task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("24/02/1981 09:40"), (Object)task.getAlarm());
        ICalParserBasicTests.assertTrue((boolean)task.getAlarmFlag());
        icalText = this.fixtures.vtodoWithDisplayAlarm(start, end, "TRIGGER;VALUE=DATE-TIME:19810224T091000", "Description");
        task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((Object)CommonAppointments.D("24/02/1981 09:10"), (Object)task.getAlarm());
        ICalParserBasicTests.assertTrue((boolean)task.getAlarmFlag());
    }

    public void testTskUid() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithSimpleProperties(start, end, "UID", "nrw3rn2983nxi");
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"nrw3rn2983nxi", (String)task.getUid());
    }

    public void no_testTskOrganizer() throws ConversionError {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithSimpleProperties(start, end, "ORGANIZER", "mailto:bla@example.invalid");
        Task task = this.parseTask(icalText, utc);
        ICalParserBasicTests.assertEquals((String)"bla@example.invalid", (String)task.getOrganizer());
    }

    public void testAppShouldIncludeErrorOnMissingStartDate() throws ConversionError {
        String icalText = this.fixtures.veventWithEnd(CommonAppointments.D("24/02/1981 10:00"));
        this.assertErrorWhenParsingAppointment(icalText, "Missing DTSTART");
    }

    public void testShouldThrowErrorOnNonICalFile() throws ConversionError {
        this.assertErrorWhenParsingAppointment("I am not an iCal file.", "This does not look like an iCal file. Please check the file.");
    }

    public void testAppShouldIncludeWarningForAdditionalRecurrences() throws ConversionError {
        String icalText = this.fixtures.veventWithTwoRecurrences(CommonAppointments.D("24/02/1981 10:00"), CommonAppointments.D("24/02/1981 12:00"));
        this.assertWarningWhenParsingAppointment(icalText, "Only converting first recurrence rule, additional recurrence rules will be ignored.");
    }

    public void testAppShouldWarnOnUnsupportedRecurrenceIntervals() throws ConversionError {
        this.warningOnAppRecurrence("FREQ=SECONDLY;INTERVAL=1;COUNT=3", "Can only convert DAILY, WEEKLY, MONTHLY and YEARLY recurrences");
        this.warningOnAppRecurrence("FREQ=MINUTELY;INTERVAL=1;COUNT=3", "Can only convert DAILY, WEEKLY, MONTHLY and YEARLY recurrences");
        this.warningOnAppRecurrence("FREQ=HOURLY;INTERVAL=1;COUNT=3", "Can only convert DAILY, WEEKLY, MONTHLY and YEARLY recurrences");
    }

    public void testAppShouldInlcudeWarningOnUnkownClass() throws ConversionError {
        String icalText = this.fixtures.veventWithSimpleProperties(CommonAppointments.D("24/02/1981 10:00"), CommonAppointments.D("24/02/1981 12:00"), "CLASS", "SUPERCALIFRAGILISTICEXPLIALIDOCIOUS");
        this.assertWarningWhenParsingAppointment(icalText, "Unknown Class: SUPERCALIFRAGILISTICEXPLIALIDOCIOUS");
    }

    public void testAppShouldIncludeWarningOnUndisplayableAlarms() throws ConversionError {
        String icalText = this.fixtures.veventWithAudioAlarm(CommonAppointments.D("24/02/1981 10:00"), CommonAppointments.D("24/02/1981 12:00"), "TRIGGER:-PT15M", "alarm.wav");
        this.assertWarningWhenParsingAppointment(icalText, "Can only convert DISPLAY alarms with triggers");
    }

    public void testAppShouldIncludeErrorForUnknownDayInRRule() throws ConversionError {
        String icalText = this.fixtures.veventWithSimpleProperties(CommonAppointments.D("24/02/1981 10:00"), CommonAppointments.D("24/02/1981 12:00"), "RRULE", "FREQ=MONTHLY;INTERVAL=2;COUNT=3;BYDAY=WU,NI;BYSETPOS=3");
        this.assertErrorWhenParsingAppointment(icalText, "Parsing error parsing ical: Error at line 6:Invalid day: WU");
    }

    public void testAppShouldWarnOnUnhandleableFields() throws ConversionError {
    }
}

