/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.internal.ConfigurationImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import junit.framework.TestCase;

public class ConfigurationImplTest
extends TestCase {
    private File configFolder;

    public void setUp() {
        this.configFolder = new File("/tmp/configTest");
        this.configFolder.mkdirs();
    }

    public void tearDown() {
        this.deleteAll(this.configFolder);
    }

    private void deleteAll(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            for (File subfile : file.listFiles()) {
                this.deleteAll(subfile);
            }
            file.delete();
        }
    }

    public void testGetAllBelowDirectory() throws IOException {
        Properties props = new Properties();
        props.put("prop1", "value1");
        props.put("prop2", "value2");
        this.dump(props, "subfolder", "expectedProps.properties");
        Properties props2 = new Properties();
        props2.put("prop3", "value3");
        props2.put("prop4", "value4");
        this.dump(props2, "subfolder", "otherExpectedProps.properties");
        Properties props3 = new Properties();
        props3.put("prop5", "value5");
        props3.put("prop6", "value6");
        this.dump(props3, "subfolder", "subsubfolder", "yetMoreExpectedProps.properties");
        Properties props4 = new Properties();
        props4.put("prop7", "value7");
        props4.put("prop8", "value8");
        this.dump(props4, "otherFolder", "unexpected.properties");
        ConfigurationService config = this.getConfiguration();
        Properties aggregated = config.getPropertiesInFolder("subfolder");
        ConfigurationImplTest.assertEquals((Object)"value1", (Object)aggregated.get("prop1"));
        ConfigurationImplTest.assertEquals((Object)"value2", (Object)aggregated.get("prop2"));
        ConfigurationImplTest.assertEquals((Object)"value3", (Object)aggregated.get("prop3"));
        ConfigurationImplTest.assertEquals((Object)"value4", (Object)aggregated.get("prop4"));
        ConfigurationImplTest.assertEquals((Object)"value5", (Object)aggregated.get("prop5"));
        ConfigurationImplTest.assertEquals((Object)"value6", (Object)aggregated.get("prop6"));
        ConfigurationImplTest.assertNull((Object)aggregated.get("prop7"));
        ConfigurationImplTest.assertNull((Object)aggregated.get("prop8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(Properties props, String ... path) throws IOException {
        File folder = this.configFolder;
        for (int i = 0; i < path.length - 1; ++i) {
            folder = new File(folder, path[i]);
            folder.mkdirs();
        }
        File propertiesFile = new File(folder, path[path.length - 1]);
        if (propertiesFile.exists()) {
            propertiesFile.delete();
        }
        OutputStream out = null;
        try {
            propertiesFile.createNewFile();
            out = new FileOutputStream(propertiesFile);
            props.store(out, "");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected ConfigurationService getConfiguration() {
        return new ConfigurationImpl(new String[]{this.configFolder.getAbsolutePath()});
    }
}

