/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.task.actions.AbstractTaskRequest;
import com.openexchange.ajax.task.actions.DeleteParser;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteRequest
extends AbstractTaskRequest<CommonDeleteResponse> {
    private final int folderId;
    private final int taskId;
    private final int[] taskIds;
    private final Date lastModified;
    private final boolean failOnError;

    public DeleteRequest(int folderId, int taskId, Date lastModified) {
        this(folderId, taskId, lastModified, true);
    }

    public DeleteRequest(Task task) {
        this(task.getParentFolderID(), task.getObjectID(), task.getLastModified(), true);
    }

    public DeleteRequest(InsertResponse insert) {
        this(insert.getFolderId(), insert.getId(), insert.getTimestamp(), true);
    }

    public DeleteRequest(int folderId, int taskId, Date lastModified, boolean failOnError) {
        this.folderId = folderId;
        this.taskId = taskId;
        this.taskIds = null;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(int folderId, int[] taskIds, Date lastModified, boolean failOnError) {
        this.folderId = folderId;
        this.taskId = 0;
        this.taskIds = taskIds;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(Task task, boolean failOnError) {
        this(task.getParentFolderID(), task.getObjectID(), task.getLastModified(), failOnError);
    }

    public DeleteRequest(InsertResponse insert, boolean failOnError) {
        this(insert.getFolderId(), insert.getId(), insert.getTimestamp(), failOnError);
    }

    @Override
    public Object getBody() throws JSONException {
        if (this.taskIds == null) {
            JSONObject json = new JSONObject();
            json.put("id", this.taskId);
            json.put("folder", this.folderId);
            return json;
        }
        JSONArray jsonArray = new JSONArray();
        for (int id : this.taskIds) {
            JSONObject json = new JSONObject();
            json.put("id", id);
            json.put("folder", this.folderId);
            jsonArray.put((Object)json);
        }
        return jsonArray;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("timestamp", String.valueOf(this.lastModified.getTime()))};
    }

    public DeleteParser getParser() {
        return new DeleteParser(this.failOnError);
    }
}

