/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.Login;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.util.EntityUtils;

public abstract class AbstractRedirectParser<T extends AbstractAJAXResponse>
extends AbstractAJAXParser<T> {
    private String location;

    AbstractRedirectParser() {
        super(true);
    }

    @Override
    public String checkResponse(HttpResponse resp) throws ParseException, IOException {
        AbstractRedirectParser.assertEquals((String)"Response code is not okay.", (int)302, (int)resp.getStatusLine().getStatusCode());
        Header[] headers = resp.getHeaders("Location");
        AbstractRedirectParser.assertEquals((String)"There should be exactly one Location header.", (int)1, (int)headers.length);
        this.location = headers[0].getValue();
        AbstractRedirectParser.assertNotNull((String)"Location for redirect is missing.", (Object)this.location);
        boolean oxCookieFound = false;
        boolean jsessionIdCookieFound = false;
        BasicHeaderElementIterator iter = new BasicHeaderElementIterator(resp.headerIterator("Set-Cookie"));
        while (iter.hasNext()) {
            HeaderElement element = iter.nextElement();
            if (element.getName().startsWith(Login.SECRET_PREFIX)) {
                oxCookieFound = true;
                continue;
            }
            if (!"JSESSIONID".equals(element.getName())) continue;
            jsessionIdCookieFound = true;
        }
        AbstractRedirectParser.assertTrue((String)"Session cookie is missing.", (boolean)oxCookieFound);
        AbstractRedirectParser.assertTrue((String)"JSESSIONID cookie is missing.", (boolean)jsessionIdCookieFound);
        return EntityUtils.toString((HttpEntity)resp.getEntity());
    }

    @Override
    public final T parse(String body) {
        return this.createResponse(this.location);
    }

    @Override
    protected final T createResponse(Response response) {
        return null;
    }

    protected abstract T createResponse(String var1);
}

