/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.resource.actions.AbstractResourceRequest;
import com.openexchange.ajax.resource.actions.ResourceDeleteResponse;
import com.openexchange.resource.Resource;
import com.openexchange.resource.json.ResourceWriter;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResourceDeleteRequest
extends AbstractResourceRequest<ResourceDeleteResponse> {
    private final JSONObject resourceJSON;
    private final long clientLastModified;
    private final boolean failOnError;

    public ResourceDeleteRequest(Resource deleteMe, long clientLastModified, boolean failOnError) throws JSONException {
        this.failOnError = failOnError;
        this.clientLastModified = clientLastModified;
        this.resourceJSON = ResourceWriter.writeResource((Resource)deleteMe);
    }

    public ResourceDeleteRequest(Resource resource) throws JSONException {
        this(resource, resource.getLastModified().getTime(), true);
    }

    @Override
    public Object getBody() throws JSONException {
        return this.resourceJSON;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "delete"));
        params.add(new AJAXRequest.Parameter("timestamp", this.clientLastModified));
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    public ResourceDeleteParser getParser() {
        return new ResourceDeleteParser(this.failOnError);
    }

    private static final class ResourceDeleteParser
    extends AbstractAJAXParser<ResourceDeleteResponse> {
        ResourceDeleteParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected ResourceDeleteResponse createResponse(Response response) throws JSONException {
            return new ResourceDeleteResponse(response);
        }
    }
}

