/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class MoveMailTest
extends AbstractMailTest {
    private UserValues values;

    public MoveMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        this.clearFolder(this.values.getSentFolder());
        this.clearFolder(this.values.getInboxFolder());
        this.clearFolder(this.values.getDraftsFolder());
        super.tearDown();
    }

    public void testShouldMoveFromSentToDrafts() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        String mail = this.values.getSendAddress();
        this.sendMail(this.createEMail(mail, "Move a mail", "ALTERNATE", "Move from sent to drafts").toString());
        String origin = this.values.getInboxFolder();
        String destination = this.values.getDraftsFolder();
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        String oldID = myMail.getId();
        TestMail movedMail = manager.move(myMail, destination);
        String newID = movedMail.getId();
        manager.get(destination, newID);
        MoveMailTest.assertTrue((String)"Should produce no errors when getting moved e-mail", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        MoveMailTest.assertTrue((String)"Should produce no conflicts when getting moved e-mail", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
        manager.get(origin, oldID);
        MoveMailTest.assertTrue((String)"Should produce errors when trying to get moved e-mail from original place", (boolean)manager.getLastResponse().hasError());
    }

    public void testShouldNotMoveToNonExistentFolder() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        String mail = this.values.getSendAddress();
        this.sendMail(this.createEMail(mail, "Move another mail", "ALTERNATE", "Move from sent to drafts").toString());
        String origin = this.values.getSentFolder();
        String destination = this.values.getDraftsFolder() + "doesn't exist";
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        String oldID = myMail.getId();
        manager.move(myMail, destination);
        MoveMailTest.assertTrue((String)"Should produce error message when trying to move to nonexistent folder", (boolean)manager.getLastResponse().hasError());
        MoveMailTest.assertEquals((String)"Should produce proper error message ", (String)"IMAP-1002", (String)manager.getLastResponse().getException().getErrorCode());
        manager.get(origin, oldID);
        MoveMailTest.assertTrue((String)"Should still have e-mail at original location", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        MoveMailTest.assertTrue((String)"Should produce no conflicts when getting e-mail from original location", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
    }

    public void testShouldNotTryToMoveToSameFolder() throws Exception {
        MailTestManager manager = new MailTestManager(this.client, true);
        String sendAddress = this.values.getSendAddress();
        TestMail sendMail = manager.send(new TestMail(sendAddress, sendAddress, "Move me from sent to sent", MailContentType.PLAIN.toString(), "text"));
        TestMail sentMail = manager.get(new String[]{this.getSentFolder(), sendMail.getId()});
        MoveMailTest.assertNotNull((String)"Sent mail may not be null and has to be found in sent-items folder", (Object)sentMail);
        TestMail movedMail = manager.move(sentMail, this.getSentFolder());
        MoveMailTest.assertNotNull((String)"Moved mail may not be null", (Object)movedMail);
        MoveMailTest.assertEquals((String)"Mail should not be moved and remain in the original folder.", (String)this.getSentFolder(), (String)movedMail.getFolder());
        MoveMailTest.assertEquals((String)"Mail shouldn't have been duplicated", (int)1, (int)manager.findSimilarMailsInSameFolder(sentMail, this.client).size());
    }
}

