/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.fixtures;

import com.openexchange.ajax.kata.Step;
import com.openexchange.ajax.kata.fixtures.AppointmentFixtureTransformer;
import com.openexchange.ajax.kata.fixtures.ContactFixtureTransformer;
import com.openexchange.ajax.kata.fixtures.FixtureTransformer;
import com.openexchange.ajax.kata.fixtures.FolderFixtureTransformer;
import com.openexchange.ajax.kata.fixtures.TaskFixtureTransformer;
import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FixtureStepFactory {
    private final FixtureLoader loader;

    public FixtureStepFactory(FixtureLoader loader) {
        this.loader = loader;
    }

    public <T> List<Step> loadSteps(Class<T> aClass, String ... fixtureNames) throws OXException {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (int i = 0; i < fixtureNames.length; ++i) {
            String fixtureName = fixtureNames[i];
            Fixtures<T> fixtures = this.loader.getFixtures(fixtureName, aClass);
            this.addFixtures(aClass, fixtures, steps, fixtureName);
        }
        return steps;
    }

    private <T> void addFixtures(Class<T> aClass, Fixtures<T> fixtures, List<Step> steps, String filename) throws OXException {
        List<FixtureTransformer> transformer = this.getAllTransformers();
        ArrayList<Entry<T>> entries = new ArrayList<Entry<T>>();
        for (String string : fixtures.getEntryNames()) {
            Fixture<T> entry = fixtures.getEntry(string);
            entries.add(new Entry<T>(string, entry));
        }
        Collections.sort(entries);
        for (Entry entry : entries) {
            for (FixtureTransformer trans : transformer) {
                if (!trans.handles(aClass, entry.name, entry.fixture)) continue;
                steps.add(trans.transform(aClass, entry.name, entry.fixture, filename + ": Step " + entry.fixture.getAttribute("step")));
            }
        }
        for (FixtureTransformer fixtureTransformer : transformer) {
            fixtureTransformer.resolveAll();
        }
    }

    private List<FixtureTransformer> getAllTransformers() {
        return new ArrayList<FixtureTransformer>(){
            {
                this.add(new AppointmentFixtureTransformer());
                this.add(new TaskFixtureTransformer());
                this.add(new ContactFixtureTransformer());
                this.add(new FolderFixtureTransformer());
            }
        };
    }

    private static final class Entry<T>
    implements Comparable<Entry<T>> {
        public String name;
        public Fixture<T> fixture;

        public Entry(String name, Fixture<T> fixture) {
            this.name = name;
            this.fixture = fixture;
        }

        @Override
        public int compareTo(Entry<T> o) {
            Long myStep = this.fixture.getAttribute("step") != null ? (Long)this.fixture.getAttribute("step") : Long.valueOf(0L);
            Long otherStep = o.fixture.getAttribute("step") != null ? (Long)o.fixture.getAttribute("step") : Long.valueOf(0L);
            return new Long(myStep - otherStep).intValue();
        }

        public String toString() {
            return this.name;
        }
    }
}

