/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.importexport.AbstractImportExportServletTest;
import com.openexchange.groupware.importexport.csv.CSVParser;
import com.openexchange.importexport.formats.Format;
import com.openexchange.test.OXTestToolkit;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.json.JSONObject;

public class CSVImportExportServletTest
extends AbstractImportExportServletTest {
    public CSVImportExportServletTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCSVRoundtrip() throws Exception {
        String insertedCSV = this.IMPORTED_CSV;
        Format format = Format.CSV;
        int folderId = this.createFolder("csv-contact-roundtrip-" + System.currentTimeMillis(), 3);
        try {
            InputStream is = new ByteArrayInputStream(insertedCSV.getBytes());
            WebConversation webconv = this.getWebConversation();
            PostMethodWebRequest req = new PostMethodWebRequest(this.getCSVColumnUrl(this.IMPORT_SERVLET, folderId, format), true);
            req.selectFile("file", "contacts.csv", is, format.getMimeType());
            WebResponse webRes = webconv.getResource((WebRequest)req);
            CSVImportExportServletTest.extractFromCallback(webRes.getText());
            webconv = this.getWebConversation();
            req = new GetMethodWebRequest(this.getCSVColumnUrl(this.EXPORT_SERVLET, folderId, format));
            webRes = webconv.sendRequest((WebRequest)req);
            is = webRes.getInputStream();
            String resultingCSV = OXTestToolkit.readStreamAsString(is);
            CSVParser parser1 = new CSVParser(insertedCSV);
            CSVParser parser2 = new CSVParser(resultingCSV);
            List res1 = parser1.parse();
            List res2 = parser2.parse();
            CSVImportExportServletTest.assertEquals("input == output ? " + res1 + " // " + res2, res1, res2);
        }
        finally {
            this.removeFolder(folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCSVBrokenFile() throws Exception {
        String insertedCSV = "bla1\nbla2,bla3";
        Format format = Format.CSV;
        int folderId = this.createFolder("csv-contact-roundtrip-" + System.currentTimeMillis(), 3);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream("bla1\nbla2,bla3".getBytes());
            WebConversation webconv = this.getWebConversation();
            PostMethodWebRequest req = new PostMethodWebRequest(this.getCSVColumnUrl(this.IMPORT_SERVLET, folderId, format), true);
            req.selectFile("file", "contacts.csv", (InputStream)is, format.getMimeType());
            WebResponse webRes = webconv.getResource((WebRequest)req);
            JSONObject response = CSVImportExportServletTest.extractFromCallback(webRes.getText());
            CSVImportExportServletTest.assertEquals((String)"Must contain error.", (String)"CSV-1000", (String)response.optString("code"));
        }
        finally {
            this.removeFolder(folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnknownCSVFormat() throws Exception {
        String insertedCSV = "bla\nbla\nbla";
        Format format = Format.CSV;
        int folderId = this.createFolder("csv-contact-roundtrip-" + System.currentTimeMillis(), 3);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream("bla\nbla\nbla".getBytes());
            WebConversation webconv = this.getWebConversation();
            PostMethodWebRequest req = new PostMethodWebRequest(this.getCSVColumnUrl(this.IMPORT_SERVLET, folderId, format), true);
            req.selectFile("file", "contacts.csv", (InputStream)is, format.getMimeType());
            WebResponse webRes = webconv.getResource((WebRequest)req);
            JSONObject response = CSVImportExportServletTest.extractFromCallback(webRes.getText());
            CSVImportExportServletTest.assertEquals((String)"Must contain error ", (String)"I_E-0804", (String)response.optString("code"));
        }
        finally {
            this.removeFolder(folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyFileUploaded() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
        WebConversation webconv = this.getWebConversation();
        Format format = Format.CSV;
        int folderId = this.createFolder("csv-empty-file-" + System.currentTimeMillis(), 3);
        try {
            PostMethodWebRequest req = new PostMethodWebRequest(this.getCSVColumnUrl(this.IMPORT_SERVLET, folderId, format), true);
            req.selectFile("file", "empty.vcs", (InputStream)is, format.getMimeType());
            WebResponse webRes = webconv.getResource((WebRequest)req);
            JSONObject response = CSVImportExportServletTest.extractFromCallback(webRes.getText());
            CSVImportExportServletTest.assertEquals((String)"Must contain error ", (String)"I_E-0804", (String)response.optString("code"));
        }
        finally {
            this.removeFolder(folderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportTwice() throws Exception {
        String insertedCSV = this.IMPORTED_CSV;
        Format format = Format.CSV;
        int folderId = this.createFolder("csv-contact-double-import-" + System.currentTimeMillis(), 3);
        try {
            InputStream is = new ByteArrayInputStream(insertedCSV.getBytes());
            WebConversation webconv = this.getWebConversation();
            PostMethodWebRequest req = new PostMethodWebRequest(this.getCSVColumnUrl(this.IMPORT_SERVLET, folderId, format), true);
            req.selectFile("file", "contacts.csv", is, format.getMimeType());
            WebResponse webRes = webconv.getResource((WebRequest)req);
            is = new ByteArrayInputStream(insertedCSV.getBytes());
            req = new PostMethodWebRequest(this.getCSVColumnUrl(this.IMPORT_SERVLET, folderId, format), true);
            req.selectFile("file", "contacts.csv", is, format.getMimeType());
            webRes = webconv.getResource((WebRequest)req);
            CSVImportExportServletTest.extractFromCallback(webRes.getText());
            webconv = this.getWebConversation();
            req = new GetMethodWebRequest(this.getCSVColumnUrl(this.EXPORT_SERVLET, folderId, format));
            webRes = webconv.sendRequest((WebRequest)req);
            is = webRes.getInputStream();
            String resultingCSV = OXTestToolkit.readStreamAsString(is);
            CSVParser parser1 = new CSVParser(insertedCSV);
            CSVParser parser2 = new CSVParser(resultingCSV);
            List res1 = parser1.parse();
            List res2 = parser2.parse();
            CSVImportExportServletTest.assertEquals("input == output ? " + res1 + " // " + res2, res1, res2);
        }
        finally {
            this.removeFolder(folderId);
        }
    }
}

