/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.CSVImportRequest;
import com.openexchange.ajax.importexport.actions.CSVImportResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.importexport.ContactTestData;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import org.json.JSONArray;

public class Bug18482Test_ByteOrderMarkOnUtf8
extends AbstractManagedContactTest {
    String csv = ContactTestData.IMPORT_MULTIPLE;

    public Bug18482Test_ByteOrderMarkOnUtf8(String name) {
        super(name);
    }

    public void testNone() throws Exception {
        this.testWithBOM(new int[0]);
    }

    public void testUTF8() throws Exception {
        this.testWithBOM(239, 187, 191);
    }

    public void testUTF16LE() throws Exception {
        this.testWithBOM(255, 254);
    }

    public void testUTF16BE() throws Exception {
        this.testWithBOM(254, 255);
    }

    public void testUTF32LE() throws Exception {
        this.testWithBOM(255, 254, 0, 0);
    }

    public void testUTF32BE() throws Exception {
        this.testWithBOM(0, 0, 254, 255);
    }

    private void testWithBOM(int ... bom) throws Exception {
        int i;
        byte[] bytes = this.csv.getBytes(Charsets.UTF_8);
        byte[] streambase = new byte[bom.length + bytes.length];
        for (i = 0; i < bom.length; ++i) {
            streambase[i] = (byte)bom[i];
        }
        for (i = bom.length; i < streambase.length; ++i) {
            streambase[i] = bytes[i - bom.length];
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(streambase);
        CSVImportRequest importRequest = new CSVImportRequest(this.folderID, stream);
        CSVImportResponse response = this.manager.getClient().execute(importRequest);
        Bug18482Test_ByteOrderMarkOnUtf8.assertFalse((boolean)response.hasError());
        Bug18482Test_ByteOrderMarkOnUtf8.assertFalse((boolean)response.hasConflicts());
        JSONArray data = (JSONArray)response.getData();
        Bug18482Test_ByteOrderMarkOnUtf8.assertEquals((int)2, (int)data.length());
        Contact c1 = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Contact c2 = this.manager.getAction(this.folderID, data.getJSONObject(1).getInt("id"));
        Bug18482Test_ByteOrderMarkOnUtf8.assertTrue((boolean)c1.getGivenName().equals(ContactTestData.NAME1));
        Bug18482Test_ByteOrderMarkOnUtf8.assertTrue((boolean)c2.getGivenName().equals(ContactTestData.NAME2));
    }
}

