/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.MultipleParser;
import com.openexchange.ajax.framework.MultipleResponse;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultipleRequest<T extends AbstractAJAXResponse>
implements AJAXRequest<MultipleResponse<T>> {
    private final AJAXRequest<T>[] requests;

    public MultipleRequest(AJAXRequest<T>[] requests) {
        this.requests = (AJAXRequest[])requests.clone();
    }

    public static <T extends AbstractAJAXResponse> MultipleRequest<T> create(AJAXRequest<T> ... requests) {
        return new MultipleRequest<T>(requests);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[0];
    }

    @Override
    public String getServletPath() {
        return "/ajax/multiple";
    }

    @Override
    public Object getBody() throws JSONException, IOException {
        JSONArray array = new JSONArray();
        for (AJAXRequest<T> request : this.requests) {
            JSONObject object = new JSONObject();
            String path = request.getServletPath();
            String module = path.substring(path.lastIndexOf(47) + 1);
            if ("folders".equals(module)) {
                module = "folder";
            }
            object.put("module", (Object)module);
            for (AJAXRequest.Parameter parameter : request.getParameters()) {
                object.put(parameter.getName(), (Object)parameter.getValue());
            }
            object.put("data", request.getBody());
            array.put((Object)object);
        }
        return array.toString();
    }

    @Override
    public MultipleParser<T> getParser() {
        return new MultipleParser<T>(this.requests);
    }
}

