/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.contact.action.AbstractContactRequest;
import com.openexchange.ajax.contact.action.InsertParser;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.container.Contact;
import java.io.ByteArrayInputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class InsertRequest
extends AbstractContactRequest<InsertResponse> {
    Contact contactObj;
    JSONObject jsonObj;
    final boolean withImage;
    String fieldContent;
    final int folderID;
    final boolean failOnError;

    public InsertRequest(Contact contactObj) {
        this(contactObj, true);
    }

    public InsertRequest(Contact contactObj, boolean failOnError) {
        this.contactObj = contactObj;
        this.folderID = contactObj.getParentFolderID();
        this.jsonObj = null;
        this.failOnError = failOnError;
        boolean bl = this.withImage = contactObj.containsImage1() && null != contactObj.getImage1();
        if (this.withImage) {
            try {
                this.fieldContent = this.convert(contactObj).toString();
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public InsertRequest(String json) throws JSONException {
        this.contactObj = null;
        this.withImage = false;
        this.jsonObj = new JSONObject(json);
        this.folderID = this.jsonObj.getInt("folder_id");
        this.failOnError = true;
    }

    @Override
    public Object getBody() throws JSONException {
        if (this.jsonObj != null) {
            return this.jsonObj;
        }
        return this.convert(this.contactObj);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return this.withImage ? AJAXRequest.Method.UPLOAD : AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        if (this.withImage) {
            return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "new"), new AJAXRequest.Parameter("folder", String.valueOf(this.folderID)), new AJAXRequest.FieldParameter("json", this.fieldContent), new AJAXRequest.FileParameter("file", "open-xchange_image.jpg", new ByteArrayInputStream(this.contactObj.getImage1()), "image/jpg")};
        }
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "new"), new AJAXRequest.Parameter("folder", String.valueOf(this.folderID))};
    }

    public InsertParser getParser() {
        return new InsertParser(this.failOnError, this.withImage);
    }
}

