/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.ListRequest;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.container.Contact;
import java.util.ArrayList;
import org.json.JSONArray;

public class ListTest
extends AbstractContactTest {
    public ListTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testList() throws Exception {
        Contact contactObj = this.createContactObject("testList");
        int id1 = this.insertContact(contactObj);
        int id2 = this.insertContact(contactObj);
        int id3 = this.insertContact(contactObj);
        Thread.sleep(1000L);
        int[][] objectIdAndFolderId = new int[][]{{id3, this.contactFolderId}, {id2, this.contactFolderId}, {id1, this.contactFolderId}};
        int[] cols = new int[]{1, 502, 500, 20};
        Contact[] contactArray = this.listContact(objectIdAndFolderId, cols);
        ListTest.assertEquals((String)"check response array", (int)3, (int)contactArray.length);
        for (int i = 0; i < contactArray.length; ++i) {
            int[] ids = objectIdAndFolderId[i];
            ListTest.assertTrue((String)"Returned contacts object id differs from the requested one.", (ids[0] == contactArray[i].getObjectID() ? 1 : 0) != 0);
            ListTest.assertTrue((String)"Returned contacts folder id differs from the requested one.", (ids[1] == contactArray[i].getParentFolderID() ? 1 : 0) != 0);
        }
    }

    public void testSortDuration() throws Exception {
        int size = 10000;
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        int[][] objectIdsAndFolderIds = new int[10000][2];
        for (int i = 0; i < 10000; ++i) {
            int objectId = 9999 - i;
            Contact contact = this.createContactObject("testList");
            contact.setObjectID(objectId);
            contacts.add(contact);
            objectIdsAndFolderIds[i] = new int[]{i, this.contactFolderId};
        }
        long start = System.currentTimeMillis();
        ArrayList<Contact> sortedContacts = new ArrayList<Contact>(contacts.size());
        block1: for (int i = 0; i < objectIdsAndFolderIds.length; ++i) {
            int[] objectIdsAndFolderId = objectIdsAndFolderIds[i];
            int objectId = objectIdsAndFolderId[0];
            int folderId = objectIdsAndFolderId[1];
            for (Contact contact : contacts) {
                if (contact.getObjectID() != objectId || contact.getParentFolderID() != folderId) continue;
                sortedContacts.add(contact);
                continue block1;
            }
        }
        long end = System.currentTimeMillis();
        long diff = end - start;
        System.out.println("Duration: " + diff);
    }

    public void testListWithAllFields() throws Exception {
        Contact contactObject = this.createCompleteContactObject();
        int objectId = this.insertContact(contactObject);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.contactFolderId}};
        Contact[] contactArray = this.listContact(objectIdAndFolderId, CONTACT_FIELDS);
        ListTest.assertEquals((String)"check response array", (int)1, (int)contactArray.length);
        Contact loadContact = contactArray[0];
        contactObject.setObjectID(objectId);
        this.compareObject(contactObject, loadContact);
    }

    public void testListWithNotExistingEntries() throws Exception {
        Contact contactObject = this.createCompleteContactObject();
        int objectId = this.insertContact(contactObject);
        int objectId2 = this.insertContact(contactObject);
        int[] cols = new int[]{1, 502, 500};
        int[][] objectIdAndFolderId1 = new int[][]{{objectId, this.contactFolderId}, {objectId + 100, this.contactFolderId}};
        Contact[] contactArray = this.listContact(objectIdAndFolderId1, cols);
        ListTest.assertEquals((String)"check response array", (int)1, (int)contactArray.length);
        int[][] objectIdAndFolderId2 = new int[][]{{objectId + 100, this.contactFolderId}, {objectId, this.contactFolderId}};
        contactArray = this.listContact(objectIdAndFolderId2, cols);
        ListTest.assertEquals((String)"check response array", (int)1, (int)contactArray.length);
        int[][] objectIdAndFolderId3 = new int[][]{{objectId + 100, this.contactFolderId}, {objectId, this.contactFolderId}, {objectId2, this.contactFolderId}};
        contactArray = this.listContact(objectIdAndFolderId3, cols);
        ListTest.assertEquals((String)"check response array", (int)2, (int)contactArray.length);
        this.deleteContact(objectId, this.contactFolderId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        int[] cols = new int[]{1, 20, 6};
        Contact contactObj = this.createContactObject("testLastModifiedUTC");
        int objectId = this.insertContact(contactObj);
        try {
            ListRequest listRequest = new ListRequest(ListIDs.l(new int[][]{{this.contactFolderId, objectId}}), cols, true);
            CommonListResponse response = Executor.execute(this.client, listRequest);
            JSONArray arr = (JSONArray)response.getResponse().getData();
            ListTest.assertNotNull((Object)arr);
            int size = arr.length();
            ListTest.assertTrue((size > 0 ? 1 : 0) != 0);
            for (int i = 0; i < size; ++i) {
                JSONArray objectData = arr.optJSONArray(i);
                ListTest.assertNotNull((Object)objectData);
                ListTest.assertNotNull((Object)objectData.opt(2));
            }
        }
        finally {
            this.deleteContact(objectId, this.contactFolderId, true);
        }
    }
}

