/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.AbstractRecurrenceTest;
import com.openexchange.ajax.appointment.recurrence.Occurrence;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.groupware.container.Appointment;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DailyRecurrenceTest
extends AbstractRecurrenceTest {
    private static final Log LOG = LogFactory.getLog(DailyRecurrenceTest.class);

    public DailyRecurrenceTest(String name) {
        super(name);
        this.simpleDateFormatUTC.setTimeZone(timeZoneUTC);
    }

    public void testDummy() {
    }

    public void testDailyRecurrenceFromWinter2SummerTime() throws Exception {
        Date until = this.simpleDateFormatUTC.parse("2007-04-01 00:00:00");
        Date start = this.simpleDateFormatUTC.parse("2007-02-01 00:00:00");
        Date end = this.simpleDateFormatUTC.parse("2007-05-01 00:00:00");
        Date startDate = this.simpleDateFormat.parse("2007-03-01 08:00:00");
        Date endDate = this.simpleDateFormat.parse("2007-03-01 10:00:00");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDailyRecurrenceFromWinter2SummerTime");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DailyRecurrenceTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DailyRecurrenceTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startDate.getTime(), endDate.getTime());
        boolean found = false;
        ArrayList<Occurrence> occurrenceList = new ArrayList<Occurrence>();
        Appointment[] appointmentArray = DailyRecurrenceTest.listAppointment(this.getWebConversation(), appointmentFolderId, _fields, start, end, this.timeZone, true, this.getHostName(), this.getSessionId());
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            occurrenceList.add(new Occurrence(appointmentArray[a].getStartDate(), appointmentArray[a].getEndDate(), appointmentArray[a].getRecurrencePosition()));
            found = true;
        }
        DailyRecurrenceTest.assertTrue((String)"appointment not found in response", (boolean)found);
        Occurrence[] occurrenceArray = occurrenceList.toArray(new Occurrence[occurrenceList.size()]);
        for (int a = 1; a <= 31; ++a) {
            Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, a);
            int day = a;
            if (day < 10) {
                DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormat.parse("2007-03-0" + day + " 08:00:00"), this.simpleDateFormat.parse("2007-03-0" + day + " 10:00:00"), occurrence, this.timeZone);
                continue;
            }
            DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormat.parse("2007-03-" + day + " 08:00:00"), this.simpleDateFormat.parse("2007-03-" + day + " 10:00:00"), occurrence, this.timeZone);
        }
        Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, 32);
        DailyRecurrenceTest.assertOccurrence(32, this.simpleDateFormat.parse("2007-04-01 08:00:00"), this.simpleDateFormat.parse("2007-04-01 10:00:00"), occurrence, this.timeZone);
        DailyRecurrenceTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testFullTimeDailyRecurrenceFromWinter2SummerTime() throws Exception {
        Date until = this.simpleDateFormatUTC.parse("2007-04-01 00:00:00");
        Date start = this.simpleDateFormatUTC.parse("2007-02-01 00:00:00");
        Date end = this.simpleDateFormatUTC.parse("2007-05-01 00:00:00");
        Date startDate = this.simpleDateFormatUTC.parse("2007-03-01 00:00:00");
        Date endDate = this.simpleDateFormatUTC.parse("2007-03-02 00:00:00");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTimeDailyRecurrenceFromWinter2SummerTime");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setFullTime(true);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DailyRecurrenceTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DailyRecurrenceTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startDate.getTime(), endDate.getTime());
        boolean found = false;
        ArrayList<Occurrence> occurrenceList = new ArrayList<Occurrence>();
        Appointment[] appointmentArray = DailyRecurrenceTest.listAppointment(this.getWebConversation(), appointmentFolderId, _fields, start, end, this.timeZone, true, this.getHostName(), this.getSessionId());
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            occurrenceList.add(new Occurrence(appointmentArray[a].getStartDate(), appointmentArray[a].getEndDate(), appointmentArray[a].getRecurrencePosition()));
            found = true;
        }
        DailyRecurrenceTest.assertTrue((String)"appointment not found in response", (boolean)found);
        Occurrence[] occurrenceArray = occurrenceList.toArray(new Occurrence[occurrenceList.size()]);
        for (int a = 1; a <= 31; ++a) {
            Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, a);
            int day = a;
            if (day < 10) {
                DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormatUTC.parse("2007-03-0" + day + " 00:00:00"), this.simpleDateFormatUTC.parse("2007-03-0" + (day + 1) + " 00:00:00"), occurrence);
                continue;
            }
            DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormatUTC.parse("2007-03-" + day + " 00:00:00"), this.simpleDateFormatUTC.parse("2007-03-" + (day + 1) + " 00:00:00"), occurrence);
        }
        Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, 32);
        DailyRecurrenceTest.assertOccurrence(32, this.simpleDateFormatUTC.parse("2007-04-01 00:00:00"), this.simpleDateFormatUTC.parse("2007-04-02 00:00:00"), occurrence, this.timeZone);
        DailyRecurrenceTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testDailyRecurrenceFromSummer2WinterTime() throws Exception {
        Date until = this.simpleDateFormatUTC.parse("2007-11-01 00:00:00");
        Date start = this.simpleDateFormatUTC.parse("2007-09-01 00:00:00");
        Date end = this.simpleDateFormatUTC.parse("2007-12-01 00:00:00");
        Date startDate = this.simpleDateFormat.parse("2007-10-01 08:00:00");
        Date endDate = this.simpleDateFormat.parse("2007-10-01 10:00:00");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDailyRecurrenceFromSummer2WinterTime");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DailyRecurrenceTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DailyRecurrenceTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startDate.getTime(), endDate.getTime());
        boolean found = false;
        ArrayList<Occurrence> occurrenceList = new ArrayList<Occurrence>();
        Appointment[] appointmentArray = DailyRecurrenceTest.listAppointment(this.getWebConversation(), appointmentFolderId, _fields, start, end, this.timeZone, true, this.getHostName(), this.getSessionId());
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            occurrenceList.add(new Occurrence(appointmentArray[a].getStartDate(), appointmentArray[a].getEndDate(), appointmentArray[a].getRecurrencePosition()));
            found = true;
        }
        DailyRecurrenceTest.assertTrue((String)"appointment not found in response", (boolean)found);
        Occurrence[] occurrenceArray = occurrenceList.toArray(new Occurrence[occurrenceList.size()]);
        for (int a = 1; a <= 31; ++a) {
            Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, a);
            int day = a;
            if (day < 10) {
                DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormat.parse("2007-10-0" + day + " 08:00:00"), this.simpleDateFormat.parse("2007-10-0" + day + " 10:00:00"), occurrence);
                continue;
            }
            DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormat.parse("2007-10-" + day + " 08:00:00"), this.simpleDateFormat.parse("2007-10-" + day + " 10:00:00"), occurrence);
        }
        Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, 32);
        DailyRecurrenceTest.assertOccurrence(32, this.simpleDateFormat.parse("2007-11-01 08:00:00"), this.simpleDateFormat.parse("2007-11-01 10:00:00"), occurrence);
        DailyRecurrenceTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testFullTimeDailyRecurrenceFromSummer2WinterTime() throws Exception {
        Date until = this.simpleDateFormatUTC.parse("2007-11-01 00:00:00");
        Date start = this.simpleDateFormatUTC.parse("2007-09-01 00:00:00");
        Date end = this.simpleDateFormatUTC.parse("2007-12-01 00:00:00");
        Date startDate = this.simpleDateFormatUTC.parse("2007-10-01 00:00:00");
        Date endDate = this.simpleDateFormatUTC.parse("2007-10-02 00:00:00");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTimeDailyRecurrenceFromSummer2WinterTime");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setUntil(until);
        appointmentObj.setFullTime(true);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = DailyRecurrenceTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = DailyRecurrenceTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startDate.getTime(), endDate.getTime());
        boolean found = false;
        ArrayList<Occurrence> occurrenceList = new ArrayList<Occurrence>();
        Appointment[] appointmentArray = DailyRecurrenceTest.listAppointment(this.getWebConversation(), appointmentFolderId, _fields, start, end, this.timeZone, true, this.getHostName(), this.getSessionId());
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            occurrenceList.add(new Occurrence(appointmentArray[a].getStartDate(), appointmentArray[a].getEndDate(), appointmentArray[a].getRecurrencePosition()));
            found = true;
        }
        DailyRecurrenceTest.assertTrue((String)"appointment not found in response", (boolean)found);
        Occurrence[] occurrenceArray = occurrenceList.toArray(new Occurrence[occurrenceList.size()]);
        for (int a = 1; a <= 31; ++a) {
            Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, a);
            int day = a;
            if (day < 10) {
                DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormatUTC.parse("2007-10-0" + day + " 00:00:00"), this.simpleDateFormatUTC.parse("2007-10-0" + (day + 1) + " 00:00:00"), occurrence);
                continue;
            }
            DailyRecurrenceTest.assertOccurrence(day, this.simpleDateFormatUTC.parse("2007-10-" + day + " 00:00:00"), this.simpleDateFormatUTC.parse("2007-10-" + (day + 1) + " 00:00:00"), occurrence);
        }
        Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, 32);
        DailyRecurrenceTest.assertOccurrence(32, this.simpleDateFormatUTC.parse("2007-11-01 00:00:00"), this.simpleDateFormatUTC.parse("2007-11-02 00:00:00"), occurrence);
        DailyRecurrenceTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }
}

