/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;

public class Bug12509Test
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private FolderObject folder;
    private Appointment appointment;
    private Appointment exception;

    public Bug12509Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.folder = new FolderObject();
        this.folder.setFolderName("Bug 12509 Test Folder" + System.currentTimeMillis());
        this.folder.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.folder.setType(1);
        this.folder.setModule(2);
        ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>(1);
        OCLPermission oclp = new OCLPermission();
        oclp.setEntity(this.clientA.getValues().getUserId());
        oclp.setAllPermission(128, 128, 128, 128);
        oclp.setFolderAdmin(true);
        permissions.add(oclp);
        OCLPermission oclp2 = new OCLPermission();
        oclp2.setEntity(this.clientB.getValues().getUserId());
        oclp2.setAllPermission(128, 128, 128, 128);
        oclp2.setFolderAdmin(false);
        permissions.add(oclp2);
        this.folder.setPermissions(permissions);
        com.openexchange.ajax.folder.actions.InsertRequest folderInsertRequest = new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.folder);
        CommonInsertResponse folderInsertResponse = this.clientA.execute(folderInsertRequest);
        folderInsertResponse.fillObject((DataObject)this.folder);
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setTitle("gnunzel");
        this.appointment.setStartDate(TimeTools.D("10.07.2009 13:00"));
        this.appointment.setEndDate(TimeTools.D("10.07.2009 14:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(5);
        this.appointment.setParticipants(ParticipantTools.createParticipants(this.clientA.getValues().getUserId(), this.clientB.getValues().getUserId()));
        this.appointment.setIgnoreConflicts(true);
        InsertRequest appointmentInsertRequest = new InsertRequest(this.appointment, this.clientA.getValues().getTimeZone());
        AppointmentInsertResponse appointmentInsertResponse = this.clientA.execute(appointmentInsertRequest);
        appointmentInsertResponse.fillAppointment(this.appointment);
        this.exception = new Appointment();
        this.exception.setObjectID(this.appointment.getObjectID());
        this.exception.setParentFolderID(this.clientB.getValues().getPrivateAppointmentFolder());
        this.exception.setRecurrencePosition(2);
        this.exception.setStartDate(TimeTools.D("11.07.2009 13:30"));
        this.exception.setEndDate(TimeTools.D("11.07.2009 14:30"));
        this.exception.setLastModified(this.appointment.getLastModified());
        this.exception.setParticipants(ParticipantTools.createParticipants(this.clientA.getValues().getUserId(), this.clientB.getValues().getUserId()));
        this.exception.setAlarm(15);
    }

    public void testBug12509() throws Exception {
        UpdateRequest appointmentUpdateRequest = new UpdateRequest(this.exception, this.clientB.getValues().getTimeZone());
        UpdateResponse appointmentUpdateResponse = this.clientB.execute(appointmentUpdateRequest);
        this.exception.setLastModified(appointmentUpdateResponse.getTimestamp());
        this.exception.setObjectID(appointmentUpdateResponse.getId());
        this.appointment.setLastModified(appointmentUpdateResponse.getTimestamp());
        GetRequest appointmentGetRequest = new GetRequest(this.folder.getObjectID(), this.exception.getObjectID(), true);
        this.clientA.execute(appointmentGetRequest);
    }

    @Override
    public void tearDown() throws Exception {
        com.openexchange.ajax.appointment.action.DeleteRequest appointmentDeleteRequest = new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment);
        this.clientA.execute(appointmentDeleteRequest);
        DeleteRequest folderDeleteRequest = new DeleteRequest((API)EnumAPI.OX_OLD, this.folder);
        this.clientA.execute(folderDeleteRequest);
        super.tearDown();
    }
}

