/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.meterware.httpunit.WebConversation;
import com.openexchange.ajax.AttachmentClient;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.links.actions.AllRequest;
import com.openexchange.ajax.links.actions.AllResponse;
import com.openexchange.ajax.links.actions.InsertRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug12377Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private TimeZone timeZone;
    private Appointment exception;
    private File file;
    private Appointment linkedAppointment;

    public Bug12377Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.file = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        this.timeZone = this.getClient().getValues().getTimeZone();
        this.createAppointmentSeries();
        this.addAttachment();
        this.createAppointmentToLinkTo();
        this.addLink();
    }

    @Override
    public void tearDown() throws Exception {
        this.removeAppointment(this.appointment);
        this.removeAppointment(this.linkedAppointment);
        super.tearDown();
    }

    public void testShouldCopyAttachmentsWhenCreatingAnException() throws Exception {
        this.createException();
        this.verifyAttachments();
        this.verifyAttachmentCount();
        this.verifyLinks();
        this.verifyLinkCount();
    }

    private void createAppointmentSeries() throws JSONException, OXException, IOException, SAXException {
        this.appointment = new Appointment();
        this.appointment.setTitle("testBug12377");
        this.appointment.setStartDate(TimeTools.D("12/02/1999 10:00"));
        this.appointment.setEndDate(TimeTools.D("12/02/1999 12:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParentFolderID(this.getPrivateAppointmentFolder());
        com.openexchange.ajax.appointment.action.InsertRequest request = new com.openexchange.ajax.appointment.action.InsertRequest(this.appointment, this.timeZone);
        CommonInsertResponse response = this.getClient().execute(request);
        response.fillObject((DataObject)this.appointment);
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
    }

    private void createException() throws JSONException, OXException, IOException, SAXException {
        this.exception = new Appointment();
        this.exception.setStartDate(TimeTools.D("15/02/1999 13:00"));
        this.exception.setEndDate(TimeTools.D("15/02/1999 15:00"));
        this.exception.setRecurrencePosition(4);
        this.exception.setParentFolderID(this.appointment.getParentFolderID());
        this.exception.setObjectID(this.appointment.getObjectID());
        this.exception.setLastModified(this.appointment.getLastModified());
        UpdateRequest request = new UpdateRequest(this.exception, this.timeZone);
        UpdateResponse response = this.getClient().execute(request);
        this.exception.setObjectID(response.getId());
        this.exception.setLastModified(new Date(Long.MAX_VALUE));
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
    }

    private void createAppointmentToLinkTo() throws JSONException, OXException, IOException, SAXException {
        this.linkedAppointment = new Appointment();
        this.linkedAppointment.setTitle("testBug12377 link to me");
        this.linkedAppointment.setStartDate(TimeTools.D("12/02/1999 16:00"));
        this.linkedAppointment.setEndDate(TimeTools.D("12/02/1999 17:00"));
        this.linkedAppointment.setIgnoreConflicts(true);
        this.linkedAppointment.setParentFolderID(this.getPrivateAppointmentFolder());
        com.openexchange.ajax.appointment.action.InsertRequest request = new com.openexchange.ajax.appointment.action.InsertRequest(this.linkedAppointment, this.timeZone);
        CommonInsertResponse response = this.getClient().execute(request);
        response.fillObject((DataObject)this.linkedAppointment);
        this.linkedAppointment.setLastModified(new Date(Long.MAX_VALUE));
    }

    private void addAttachment() throws JSONException, IOException {
        AJAXClient client = this.getClient();
        AJAXSession session = client.getSession();
        WebConversation conversation = session.getConversation();
        String sessionId = session.getId();
        File file = this.getFile();
        AttachmentClient.attach(conversation, sessionId, this.appointment.getParentFolderID(), this.appointment.getObjectID(), 1, file);
    }

    private void addLink() throws JSONException, OXException, IOException, SAXException {
        LinkObject link = new LinkObject();
        link.setLink(this.appointment.getObjectID(), 1, this.appointment.getParentFolderID(), this.linkedAppointment.getObjectID(), 1, this.linkedAppointment.getParentFolderID(), -1);
        InsertRequest request = new InsertRequest(link, true);
        this.getClient().execute(request);
    }

    private void removeAppointment(Appointment appointment) throws JSONException, OXException, IOException, SAXException {
        appointment.setLastModified(new Date(Long.MAX_VALUE));
        DeleteRequest delete = new DeleteRequest(appointment);
        this.getClient().execute(delete);
    }

    private void verifyAttachments() throws JSONException, IOException, SAXException {
        AJAXClient client = this.getClient();
        AJAXSession session = client.getSession();
        WebConversation conversation = session.getConversation();
        String sessionId = session.getId();
        Response response = AttachmentClient.all(conversation, sessionId, this.exception.getParentFolderID(), this.exception.getObjectID(), 1, new int[]{803}, 803, "ASC");
        Bug12377Test.assertFalse((boolean)response.hasError());
        JSONArray arr = (JSONArray)response.getData();
        boolean found = false;
        int size = arr.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = arr.getJSONArray(i);
            String filename = row.getString(0);
            if (!filename.equals(this.getFile().getName())) continue;
            found = true;
        }
        Bug12377Test.assertTrue((boolean)found);
    }

    private Appointment reloadException() throws JSONException, OXException, IOException, SAXException, OXException {
        AJAXClient client = this.getClient();
        GetRequest get = new GetRequest(this.exception.getParentFolderID(), this.exception.getObjectID());
        GetResponse response = client.execute(get);
        return response.getAppointment(TimeZone.getTimeZone("UTC"));
    }

    private void verifyAttachmentCount() throws JSONException, OXException, IOException, SAXException, OXException {
        Appointment reloadedException = this.reloadException();
        Bug12377Test.assertEquals((int)1, (int)reloadedException.getNumberOfAttachments());
    }

    private void verifyLinks() throws JSONException, OXException, IOException, SAXException {
        AllRequest request = new AllRequest(this.exception.getObjectID(), 1, this.exception.getParentFolderID(), true);
        AllResponse response = this.getClient().execute(request);
        LinkObject[] loadedLinks = response.getLinks();
        Bug12377Test.assertEquals((int)1, (int)loadedLinks.length);
    }

    private void verifyLinkCount() throws JSONException, OXException, OXException, IOException, SAXException {
    }

    public int getPrivateAppointmentFolder() throws JSONException, OXException, IOException, SAXException {
        return this.getClient().getValues().getPrivateAppointmentFolder();
    }

    public File getFile() {
        return this.file;
    }
}

