/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Charsets;
import com.openexchange.tools.URLParameter;
import com.openexchange.webdav.xml.FolderTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class CopyTest
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(CopyTest.class);

    public CopyTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCopy() throws Exception {
        Appointment appointmentObj = new Appointment();
        String date = String.valueOf(System.currentTimeMillis());
        appointmentObj.setTitle("testCopy" + date);
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId1 = CopyTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        String login = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"login", (String)"");
        String context = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"contextName", (String)"defaultContext");
        String password = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"password", (String)"");
        FolderObject folderObj = FolderTest.createFolderObject(this.userId, "testCopy" + System.currentTimeMillis(), 2, false);
        int targetFolder = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), login, password, context);
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", this.getSessionId());
        parameter.setParameter("action", "copy");
        parameter.setParameter("id", objectId1);
        parameter.setParameter("folder", appointmentFolderId);
        parameter.setParameter("ignore_conflicts", true);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("folder_id", targetFolder);
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonObj.toString().getBytes(Charsets.UTF_8));
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + this.getHostName() + "/ajax/calendar" + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = this.getWebConversation().getResponse((WebRequest)req);
        CopyTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            CopyTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        int objectId2 = 0;
        JSONObject data = (JSONObject)response.getData();
        if (data.has("id")) {
            objectId2 = data.getInt("id");
        }
        if (data.has("conflicts")) {
            CopyTest.fail((String)"conflicts found!");
        }
        CopyTest.deleteAppointment(this.getWebConversation(), objectId1, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
        if (objectId2 > 0) {
            CopyTest.deleteAppointment(this.getWebConversation(), objectId2, targetFolder, "http://" + this.getHostName(), this.getSessionId(), false);
        }
    }
}

