/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Filter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Charsets;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeHeaderNameChecker;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.TextProcessing;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.session.Session;
import com.openexchange.smtp.SMTPCapabilityCache;
import com.openexchange.smtp.SMTPExceptionCode;
import com.openexchange.smtp.SMTPProvider;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.config.MailAccountSMTPProperties;
import com.openexchange.smtp.config.SMTPConfig;
import com.openexchange.smtp.config.SMTPSessionProperties;
import com.openexchange.smtp.filler.SMTPMessageFiller;
import com.openexchange.smtp.services.SMTPServiceRegistry;
import com.openexchange.tools.ssl.TrustAllSSLSocketFactory;
import com.sun.mail.smtp.SMTPMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Transport;
import javax.mail.internet.IDNA;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;

public final class SMTPTransport
extends MailTransport {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SMTPTransport.class));
    private static final String KERBEROS_SESSION_SUBJECT = "kerberosSubject";
    private static volatile String staticHostName;
    private static volatile UnknownHostException warnSpam;
    private final Queue<Runnable> pendingInvocations;
    private volatile javax.mail.Session smtpSession;
    private final int accountId;
    private final Session session;
    private transient Subject kerberosSubject;
    private final Context ctx;
    private final UserSettingMail usm;
    private volatile SMTPConfig cachedSmtpConfig;
    private static final String ACK_TEXT = "Reporting-UA: OPEN-XCHANGE - WebMail\r\nFinal-Recipient: rfc822; #FROM#\r\nOriginal-Message-ID: #MSG ID#\r\nDisposition: manual-action/MDN-sent-manually; displayed\r\n";
    private static final String CT_TEXT_PLAIN = "text/plain; charset=#CS#";
    private static final String CT_READ_ACK = "message/disposition-notification; name=MDNPart1.txt; charset=UTF-8";
    private static final String CD_READ_ACK = "attachment; filename=MDNPart1.txt";
    private static final String MULTI_SUBTYPE_REPORT = "report; report-type=disposition-notification";

    protected SMTPTransport() {
        this.accountId = 0;
        this.smtpSession = null;
        this.session = null;
        this.ctx = null;
        this.usm = null;
        this.pendingInvocations = new Java7ConcurrentLinkedQueue();
    }

    public SMTPTransport(Session session) throws OXException {
        this(session, 0);
    }

    public SMTPTransport(Session session, int accountId) throws OXException {
        this.pendingInvocations = new ConcurrentLinkedQueue<Runnable>();
        this.session = session;
        this.accountId = accountId;
        if (session == null) {
            this.ctx = null;
            this.usm = null;
        } else {
            this.ctx = ContextStorage.getStorageContext((int)session.getContextId());
            this.usm = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), this.ctx);
        }
    }

    private void clearUp() {
        this.doInvocations();
    }

    public void close() {
        this.clearUp();
    }

    private void doInvocations() {
        while (!this.pendingInvocations.isEmpty()) {
            Runnable task = this.pendingInvocations.poll();
            if (null == task) continue;
            task.run();
        }
    }

    private void invokeLater(Runnable task) {
        this.pendingInvocations.offer(task);
    }

    private boolean isKerberosAuth() {
        return 0 == this.accountId && null != this.kerberosSubject;
    }

    private static void handlePrivilegedActionException(PrivilegedActionException e) throws MessagingException, OXException {
        if (null == e) {
            return;
        }
        Exception cause = e.getException();
        if (null == cause) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e.getCause(), new Object[]{e.getMessage()});
        }
        if (cause instanceof MessagingException) {
            throw (MessagingException)cause;
        }
        if (cause instanceof OXException) {
            throw (OXException)((Object)cause);
        }
        throw MailExceptionCode.UNEXPECTED_ERROR.create((Throwable)cause, new Object[]{cause.getMessage()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.mail.Session getSMTPSession() throws OXException {
        if (null == this.smtpSession) {
            SMTPTransport sMTPTransport = this;
            synchronized (sMTPTransport) {
                if (null == this.smtpSession) {
                    Properties smtpProps = SMTPSessionProperties.getDefaultSessionProperties();
                    SMTPConfig smtpConfig = this.getTransportConfig0();
                    ISMTPProperties smtpProperties = smtpConfig.getSMTPProperties();
                    this.kerberosSubject = (Subject)this.session.getParameter(KERBEROS_SESSION_SUBJECT);
                    boolean kerberosAuth = this.isKerberosAuth();
                    if (kerberosAuth) {
                        smtpProps.put("mail.smtp.auth", "true");
                        smtpProps.put("mail.smtp.sasl.enable", "true");
                        smtpProps.put("mail.smtp.sasl.authorizationid", smtpConfig.getLogin());
                        smtpProps.put("mail.smtp.sasl.mechanisms", kerberosAuth ? "GSSAPI" : "PLAIN");
                    } else {
                        smtpProps.put("mail.smtp.auth", smtpProperties.isSmtpAuth() ? "true" : "false");
                    }
                    String smtpLocalhost = smtpProperties.getSmtpLocalhost();
                    if (smtpLocalhost != null) {
                        smtpProps.put("mail.smtp.localhost", smtpLocalhost);
                    }
                    if (smtpProperties.getSmtpTimeout() > 0) {
                        smtpProps.put("mail.smtp.timeout", Integer.toString(smtpProperties.getSmtpTimeout()));
                    }
                    if (smtpProperties.getSmtpConnectionTimeout() > 0) {
                        smtpProps.put("mail.smtp.connectiontimeout", Integer.toString(smtpProperties.getSmtpConnectionTimeout()));
                    }
                    String sPort = String.valueOf(smtpConfig.getPort());
                    String socketFactoryClass = TrustAllSSLSocketFactory.class.getName();
                    if (smtpConfig.isSecure()) {
                        smtpProps.put("mail.smtp.socketFactory.class", socketFactoryClass);
                        smtpProps.put("mail.smtp.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.socketFactory.fallback", "false");
                    } else {
                        HostnameService hostnameService;
                        String hostName = smtpLocalhost;
                        if (null == hostName && null == (hostName = null == (hostnameService = (HostnameService)SMTPServiceRegistry.getServiceRegistry().getService(HostnameService.class)) ? SMTPTransport.getHostName() : hostnameService.getHostname(this.session.getUserId(), this.session.getContextId()))) {
                            hostName = SMTPTransport.getHostName();
                        }
                        try {
                            InetSocketAddress address = new InetSocketAddress(IDNA.toASCII((String)smtpConfig.getServer()), smtpConfig.getPort());
                            Map<String, String> capabilities = SMTPCapabilityCache.getCapabilities(address, smtpConfig.isSecure(), smtpProperties, hostName);
                            if (capabilities.containsKey("STARTTLS")) {
                                smtpProps.put("mail.smtp.starttls.enable", "true");
                            }
                        }
                        catch (IOException e) {
                            smtpProps.put("mail.smtp.starttls.enable", "true");
                        }
                        smtpProps.put("mail.smtp.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.ssl.socketFactory.class", socketFactoryClass);
                        smtpProps.put("mail.smtp.ssl.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.socketFactory.fallback", "false");
                        smtpProps.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
                    }
                    this.smtpSession = javax.mail.Session.getInstance((Properties)smtpProps, null);
                }
            }
        }
        return this.smtpSession;
    }

    public SMTPConfig getTransportConfig() throws OXException {
        return this.getTransportConfig0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMTPConfig getTransportConfig0() throws OXException {
        if (this.cachedSmtpConfig == null) {
            SMTPTransport sMTPTransport = this;
            synchronized (sMTPTransport) {
                if (this.cachedSmtpConfig == null) {
                    this.cachedSmtpConfig = (SMTPConfig)TransportConfig.getTransportConfig(SMTPConfig.class, (TransportConfig)new SMTPConfig(), (Session)this.session, (int)this.accountId);
                    this.cachedSmtpConfig.setTransportProperties(this.createNewMailProperties());
                }
            }
        }
        return this.cachedSmtpConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReceiptAck(MailMessage srcMail, String fromAddr) throws OXException {
        SMTPConfig smtpConfig = null;
        try {
            MailDateFormat mdf;
            String from;
            InternetAddress dispNotification = srcMail.getDispositionNotification();
            if (dispNotification == null) {
                throw SMTPExceptionCode.MISSING_NOTIFICATION_HEADER.create("Disposition-Notification-To", Long.valueOf(srcMail.getMailId()));
            }
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession());
            String userMail = UserStorage.getStorageUser((int)this.session.getUserId(), (Context)this.ctx).getMail();
            if (fromAddr == null) {
                if (this.usm.getSendAddr() == null && userMail == null) {
                    throw SMTPExceptionCode.NO_SEND_ADDRESS_FOUND.create();
                }
                from = this.usm.getSendAddr() == null ? userMail : this.usm.getSendAddr();
            } else {
                from = fromAddr;
            }
            smtpMessage.addFrom((Address[])MimeMessageUtility.parseAddressList((String)from, (boolean)false));
            Address[] recipients = new Address[]{dispNotification};
            SMTPTransport.checkRecipients(recipients);
            smtpMessage.addRecipients(Message.RecipientType.TO, recipients);
            smtpMessage.setHeader("X-Priority", "3 (normal)");
            smtpMessage.setHeader("Importance", "Medium");
            Locale locale = UserStorage.getStorageUser((int)this.session.getUserId(), (Context)this.ctx).getLocale();
            StringHelper strHelper = StringHelper.valueOf((Locale)locale);
            smtpMessage.setSubject(strHelper.getString("Read acknowledgement"));
            MailDateFormat mailDateFormat = mdf = MimeMessageUtility.getMailDateFormat((Session)this.session);
            synchronized (mailDateFormat) {
                smtpMessage.setHeader("Date", mdf.format(new Date()));
            }
            smtpConfig = this.getTransportConfig0();
            new SMTPMessageFiller(smtpConfig.getSMTPProperties(), this.session, this.ctx, this.usm).setAccountId(this.accountId).setCommonHeaders((MimeMessage)smtpMessage);
            String defaultMimeCS = MailProperties.getInstance().getDefaultMimeCharset();
            ContentType ct = new ContentType(CT_TEXT_PLAIN.replaceFirst("#CS#", defaultMimeCS));
            MimeMultipart mixedMultipart = new MimeMultipart(MULTI_SUBTYPE_REPORT);
            Date sentDate = srcMail.getSentDate();
            MimeBodyPart text = new MimeBodyPart();
            text.setText(TextProcessing.performLineFolding((String)strHelper.getString("This is a delivery receipt for the mail that you sent on #DATE# to #RECIPIENT# with subject \"#SUBJECT#\".\n\nNote: This delivery receipt only acknowledges that the message was displayed on the recipients computer. There is no guarantee that the recipient has read or understood the message contents.").replaceFirst("#DATE#", sentDate == null ? "" : Matcher.quoteReplacement(DateFormat.getDateInstance(1, locale).format(sentDate))).replaceFirst("#RECIPIENT#", Matcher.quoteReplacement(from)).replaceFirst("#SUBJECT#", Matcher.quoteReplacement(srcMail.getSubject())), (int)this.usm.getAutoLinebreak()), defaultMimeCS);
            text.setHeader("MIME-Version", "1.0");
            text.setHeader("Content-Type", MimeMessageUtility.foldContentType((String)ct.toString()));
            mixedMultipart.addBodyPart((BodyPart)text);
            ct.setContentType(CT_READ_ACK);
            MimeBodyPart ack = new MimeBodyPart();
            String msgId = srcMail.getFirstHeader("Message-ID");
            ack.setText(strHelper.getString(ACK_TEXT).replaceFirst("#FROM#", Matcher.quoteReplacement(from)).replaceFirst("#MSG ID#", Matcher.quoteReplacement(msgId)), defaultMimeCS);
            ack.setHeader("MIME-Version", "1.0");
            ack.setHeader("Content-Type", MimeMessageUtility.foldContentType((String)ct.toString()));
            ack.setHeader("Content-Disposition", CD_READ_ACK);
            mixedMultipart.addBodyPart((BodyPart)ack);
            smtpMessage.setContent((Multipart)mixedMultipart);
            long start = System.currentTimeMillis();
            Transport transport = this.getSMTPSession().getTransport(SMTPProvider.PROTOCOL_SMTP.getName());
            try {
                String server = IDNA.toASCII((String)smtpConfig.getServer());
                int port = smtpConfig.getPort();
                if (smtpConfig.getSMTPProperties().isSmtpAuth()) {
                    if (this.isKerberosAuth()) {
                        try {
                            Subject.doAs(this.kerberosSubject, new SaslSmtpLoginAction(transport, server, port, smtpConfig.getLogin(), this.encodePassword(smtpConfig.getPassword())));
                        }
                        catch (PrivilegedActionException e) {
                            SMTPTransport.handlePrivilegedActionException(e);
                        }
                    } else {
                        transport.connect(server, port, smtpConfig.getLogin(), this.encodePassword(smtpConfig.getPassword()));
                    }
                } else {
                    transport.connect(server, port, null, null);
                }
            }
            catch (AuthenticationFailedException e) {
                throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{smtpConfig.getServer(), e.getMessage()});
            }
            try {
                this.saveChangesSafe(smtpMessage);
                transport.sendMessage((Message)smtpMessage, smtpMessage.getAllRecipients());
                MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
            }
            finally {
                transport.close();
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, smtpConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailMessage sendRawMessage(byte[] asciiBytes, Address[] allRecipients) throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig0();
        try {
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession(), MimeHeaderNameChecker.sanitizeHeaderNames((byte[])asciiBytes));
            smtpMessage.removeHeader("x-original-headers");
            Address[] recipients = allRecipients == null ? smtpMessage.getAllRecipients() : allRecipients;
            SMTPTransport.checkRecipients(recipients);
            try {
                long start = System.currentTimeMillis();
                Transport transport = this.getSMTPSession().getTransport(SMTPProvider.PROTOCOL_SMTP.getName());
                try {
                    String server = IDNA.toASCII((String)smtpConfig.getServer());
                    int port = smtpConfig.getPort();
                    if (smtpConfig.getSMTPProperties().isSmtpAuth()) {
                        if (this.isKerberosAuth()) {
                            try {
                                Subject.doAs(this.kerberosSubject, new SaslSmtpLoginAction(transport, server, port, smtpConfig.getLogin(), this.encodePassword(smtpConfig.getPassword())));
                            }
                            catch (PrivilegedActionException e) {
                                SMTPTransport.handlePrivilegedActionException(e);
                            }
                        } else {
                            transport.connect(server, port, smtpConfig.getLogin(), this.encodePassword(smtpConfig.getPassword()));
                        }
                    } else {
                        transport.connect(server, port, null, null);
                    }
                }
                catch (AuthenticationFailedException e) {
                    throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{smtpConfig.getServer(), e.getMessage()});
                }
                try {
                    this.saveChangesSafe(smtpMessage);
                    transport.sendMessage((Message)smtpMessage, recipients);
                    MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                }
                finally {
                    transport.close();
                }
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig);
            }
            return MimeMessageConverter.convertMessage((MimeMessage)smtpMessage);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailMessage sendMailMessage(ComposedMailMessage composedMail, ComposeType sendType, Address[] allRecipients) throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig0();
        try {
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession());
            long startPrep = System.currentTimeMillis();
            SMTPMessageFiller smtpFiller = new SMTPMessageFiller(smtpConfig.getSMTPProperties(), this.session, this.ctx, this.usm);
            smtpFiller.setAccountId(this.accountId);
            composedMail.setFiller((MimeMessageFiller)smtpFiller);
            try {
                smtpFiller.fillMail(composedMail, smtpMessage, sendType);
                Object[] recipients = allRecipients == null ? (composedMail.hasRecipients() ? composedMail.getRecipients() : smtpMessage.getAllRecipients()) : allRecipients;
                SMTPTransport.checkRecipients(recipients);
                smtpFiller.setSendHeaders(composedMail, (MimeMessage)smtpMessage);
                smtpMessage.removeHeader("x-original-headers");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuilder(128).append("SMTP mail prepared for transport in ").append(System.currentTimeMillis() - startPrep).append("msec").toString());
                }
                long start = System.currentTimeMillis();
                Transport transport = this.getSMTPSession().getTransport(SMTPProvider.PROTOCOL_SMTP.getName());
                try {
                    String server = IDNA.toASCII((String)smtpConfig.getServer());
                    int port = smtpConfig.getPort();
                    if (smtpConfig.getSMTPProperties().isSmtpAuth()) {
                        if (this.isKerberosAuth()) {
                            try {
                                Subject.doAs(this.kerberosSubject, new SaslSmtpLoginAction(transport, server, port, smtpConfig.getLogin(), this.encodePassword(smtpConfig.getPassword())));
                            }
                            catch (PrivilegedActionException e) {
                                SMTPTransport.handlePrivilegedActionException(e);
                            }
                        } else {
                            transport.connect(server, port, smtpConfig.getLogin(), this.encodePassword(smtpConfig.getPassword()));
                        }
                    } else {
                        transport.connect(server, port, null, null);
                    }
                }
                catch (AuthenticationFailedException e) {
                    throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{smtpConfig.getServer(), e.getMessage()});
                }
                try {
                    this.saveChangesSafe(smtpMessage);
                    transport.sendMessage((Message)smtpMessage, recipients);
                    MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                }
                finally {
                    transport.close();
                }
            }
            finally {
                this.invokeLater(new MailCleanerTask(composedMail));
            }
            return MimeMessageConverter.convertMessage((MimeMessage)smtpMessage);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig);
        }
        catch (IOException e) {
            throw SMTPExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private String encodePassword(String password) throws OXException {
        String tmpPass = password;
        if (password != null) {
            try {
                tmpPass = new String(password.getBytes(Charsets.forName((String)this.getTransportConfig0().getSMTPProperties().getSmtpAuthEnc())), Charsets.ISO_8859_1);
            }
            catch (UnsupportedCharsetException e) {
                LOG.error((Object)("Unsupported encoding in a message detected and monitored: \"" + e.getMessage() + '\"'), (Throwable)e);
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            }
        }
        return tmpPass;
    }

    protected void shutdown() {
        SMTPSessionProperties.resetDefaultSessionProperties();
        SMTPCapabilityCache.tearDown();
    }

    protected void startup() {
        SMTPCapabilityCache.init();
    }

    private static void checkRecipients(Address[] recipients) throws OXException {
        Filter filter;
        if (recipients == null || recipients.length == 0) {
            throw SMTPExceptionCode.MISSING_RECIPIENTS.create();
        }
        ConfigurationService service = (ConfigurationService)SMTPServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
        if (null != service && null != (filter = service.getFilterFromProperty("com.openexchange.mail.transport.redirectWhitelist"))) {
            for (Address address : recipients) {
                InternetAddress internetAddress = (InternetAddress)address;
                if (filter.accepts(internetAddress.getAddress())) continue;
                throw SMTPExceptionCode.RECIPIENT_NOT_ALLOWED.create(internetAddress.toUnicodeString());
            }
        }
    }

    public void ping() throws OXException {
        Transport transport;
        try {
            transport = this.getSMTPSession().getTransport(SMTPProvider.PROTOCOL_SMTP.getName());
        }
        catch (NoSuchProviderException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        boolean close = false;
        SMTPConfig config = this.getTransportConfig0();
        try {
            try {
                String server = IDNA.toASCII((String)config.getServer());
                int port = config.getPort();
                if (config.getSMTPProperties().isSmtpAuth()) {
                    if (this.isKerberosAuth()) {
                        try {
                            Subject.doAs(this.kerberosSubject, new SaslSmtpLoginAction(transport, server, port, config.getLogin(), this.encodePassword(config.getPassword())));
                        }
                        catch (PrivilegedActionException e) {
                            SMTPTransport.handlePrivilegedActionException(e);
                        }
                    } else {
                        transport.connect(server, port, config.getLogin(), this.encodePassword(config.getPassword()));
                    }
                } else {
                    transport.connect(server, port, null, null);
                }
                close = true;
            }
            catch (AuthenticationFailedException e) {
                throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{config.getServer(), e.getMessage()});
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)config);
        }
        finally {
            if (close) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    LOG.error((Object)"Closing SMTP transport failed.", (Throwable)e);
                }
            }
        }
    }

    protected ITransportProperties createNewMailProperties() throws OXException {
        MailAccountStorageService storageService = (MailAccountStorageService)SMTPServiceRegistry.getServiceRegistry().getService(MailAccountStorageService.class, true);
        return new MailAccountSMTPProperties(storageService.getMailAccount(this.accountId, this.session.getUserId(), this.session.getContextId()));
    }

    private void saveChangesSafe(SMTPMessage smtpMessage) throws OXException {
        try {
            MimeMessageConverter.saveChanges((MimeMessage)smtpMessage);
            String messageId = smtpMessage.getHeader("Message-ID", null);
            if (null != messageId) {
                int pos;
                HostnameService hostnameService = (HostnameService)SMTPServiceRegistry.getServiceRegistry().getService(HostnameService.class);
                String hostName = null == hostnameService ? SMTPTransport.getHostName() : hostnameService.getHostname(this.session.getUserId(), this.session.getContextId());
                if (null == hostName) {
                    hostName = SMTPTransport.getHostName();
                }
                if ((pos = messageId.indexOf(64)) > 0) {
                    StringBuilder mid = new StringBuilder(messageId.substring(0, pos + 1)).append(hostName);
                    if (messageId.charAt(0) == '<') {
                        mid.append('>');
                    }
                    smtpMessage.setHeader("Message-ID", mid.toString());
                } else {
                    smtpMessage.setHeader("Message-ID", messageId + hostName);
                }
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e);
        }
    }

    private static String getHostName() {
        Props logProperties = LogProperties.optLogProperties();
        if (null == logProperties) {
            return SMTPTransport.getStaticHostName();
        }
        String serverName = (String)logProperties.get("com.openexchange.ajp13.serverName");
        if (null == serverName) {
            return SMTPTransport.getStaticHostName();
        }
        return serverName;
    }

    private static String getStaticHostName() {
        UnknownHostException warning = warnSpam;
        if (warning != null) {
            LOG.error((Object)"Can't resolve my own hostname, using 'localhost' instead, which is certainly not what you want!", (Throwable)warning);
        }
        return staticHostName;
    }

    static {
        try {
            staticHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            staticHostName = "localhost";
            warnSpam = e;
        }
    }

    private static final class MailCleanerTask
    implements Runnable {
        private final ComposedMailMessage composedMail;

        public MailCleanerTask(ComposedMailMessage composedMail) {
            this.composedMail = composedMail;
        }

        @Override
        public void run() {
            this.composedMail.cleanUp();
        }
    }

    private static final class SaslSmtpLoginAction
    implements PrivilegedExceptionAction<Object> {
        private final Transport transport;
        private final String server;
        private final int port;
        private final String login;
        private final String pw;

        protected SaslSmtpLoginAction(Transport transport, String server, int port, String login, String pw) {
            this.transport = transport;
            this.server = server;
            this.port = port;
            this.login = login;
            this.pw = pw;
        }

        @Override
        public Object run() throws MessagingException {
            this.transport.connect(this.server, this.port, this.login, this.pw);
            return null;
        }
    }
}

