/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.webdav.xml.CalendarWriter;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class AppointmentWriter
extends CalendarWriter {
    protected static final int[] changeFields = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 400, 201, 202, 203, 209, 220, 221, 402, 401, 102, 104, 210, 211, 206, 207, 218, 408, 223};
    protected static final int[] deleteFields = new int[]{1, 5, 206};
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AppointmentWriter.class));

    public AppointmentWriter() {
        this.userObj = null;
        this.ctx = null;
        this.sessionObj = null;
    }

    public AppointmentWriter(User userObj, Context ctx, Session sessionObj) {
        this.userObj = userObj;
        this.ctx = ctx;
        this.sessionObj = sessionObj;
    }

    public void startWriter(int objectId, int folderId, OutputStream os) throws Exception {
        AppointmentSQLInterface appointmentsql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(this.sessionObj);
        Element eProp = new Element("prop", "D", "DAV:");
        XMLOutputter xo = new XMLOutputter();
        try {
            CalendarDataObject appointmentobject = appointmentsql.getObjectById(objectId, folderId);
            this.writeObject(appointmentobject, eProp, false, xo, os);
        }
        catch (OXException exc) {
            if (exc.isGeneric(OXException.Generic.NOT_FOUND)) {
                this.writeResponseElement(eProp, 0, 404, "[1001] Object not found", xo, os);
            } else {
                this.writeResponseElement(eProp, 0, 500, AppointmentWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"AppointmentWriter.startWriter()", (Throwable)ex);
            this.writeResponseElement(eProp, 0, 500, AppointmentWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriter(boolean bModified, boolean bDeleted, boolean bList, int folder_id, Date lastsync, OutputStream os) throws Exception {
        AppointmentSQLInterface appointmentsql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(this.sessionObj);
        XMLOutputter xo = new XMLOutputter();
        SearchIterator<Appointment> it = null;
        if (bDeleted) {
            try {
                it = appointmentsql.getDeletedAppointmentsInFolder(folder_id, deleteFields, lastsync);
                this.writeIterator(it, true, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        if (bModified || bDeleted) {
            try {
                Appointment appObject;
                it = appointmentsql.getModifiedAppointmentsInFolder(folder_id, changeFields, lastsync);
                LinkedList<Appointment> modifiedQueue = new LinkedList<Appointment>();
                while (it.hasNext()) {
                    int[] ids;
                    appObject = (Appointment)it.next();
                    if (appObject.getPrivateFlag() && this.sessionObj.getUserId() != appObject.getCreatedBy()) {
                        if (!bDeleted) continue;
                        this.writeObject(appObject, true, xo, os);
                        continue;
                    }
                    if (!bModified) continue;
                    if (appObject.isMaster() && appObject.getCreatedBy() != this.sessionObj.getUserId() && (ids = AppointmentWriter.checkChangeExceptions(folder_id, appObject, this.sessionObj)).length > 0) {
                        Appointment[] ces;
                        CalendarCollectionService calColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
                        for (Appointment ce : ces = calColl.getAppointmentsByID(folder_id, ids, deleteFields, this.sessionObj)) {
                            if (null == ce) continue;
                            this.writeObject(ce, true, xo, os);
                        }
                    }
                    modifiedQueue.add(appObject);
                }
                while (!modifiedQueue.isEmpty()) {
                    appObject = (Appointment)modifiedQueue.poll();
                    if (null == appObject) continue;
                    this.writeObject(appObject, false, xo, os);
                }
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        if (bList) {
            try {
                it = appointmentsql.getModifiedAppointmentsInFolder(folder_id, changeFields, new Date(0L));
                this.writeList(it, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
    }

    public void writeIterator(SearchIterator<? extends Appointment> it, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        while (it.hasNext()) {
            this.writeObject((Appointment)it.next(), delete, xo, os);
        }
    }

    public void writeObject(Appointment appointmentobject, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        this.writeObject(appointmentobject, new Element("prop", "D", "DAV:"), delete, xo, os);
    }

    public void writeObject(Appointment appointmentobject, Element e_prop, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        int status = 200;
        String description = "OK";
        int object_id = 0;
        try {
            object_id = appointmentobject.getObjectID();
            this.addContent2PropElement(e_prop, appointmentobject, delete);
        }
        catch (Exception exc) {
            LOG.error((Object)"writeObject", (Throwable)exc);
            status = 500;
            description = "Server Error: " + exc.toString();
            object_id = 0;
        }
        this.writeResponseElement(e_prop, object_id, status, description, xo, os);
    }

    protected void addContent2PropElement(Element e_prop, Appointment ao, boolean delete) throws Exception {
        this.addContent2PropElement(e_prop, ao, delete, false);
    }

    public void addContent2PropElement(Element e_prop, Appointment ao, boolean delete, boolean externalUse) throws OXException, SearchIteratorException, UnsupportedEncodingException {
        if (delete) {
            AppointmentWriter.addElement("object_id", ao.getObjectID(), e_prop);
            AppointmentWriter.addElement("last_modified", ao.getLastModified(), e_prop);
            if (ao.containsRecurrenceID()) {
                AppointmentWriter.addElement("recurrence_id", ao.getRecurrenceID(), e_prop);
            }
            AppointmentWriter.addElement("object_status", "DELETE", e_prop);
        } else {
            Date[] changeException;
            int a;
            StringBuilder stringBuilder;
            Date[] deleteExceptions;
            AppointmentWriter.addElement("object_status", "CREATE", e_prop);
            boolean fullTime = ao.getFullTime();
            if (ao.getRecurrenceType() == 0) {
                AppointmentWriter.addElement("start_date", ao.getStartDate(), e_prop);
                AppointmentWriter.addElement("end_date", ao.getEndDate(), e_prop);
            } else {
                if (!externalUse) {
                    RecurringResultsInterface recuResults = null;
                    try {
                        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
                        recuResults = recColl.calculateFirstRecurring(ao);
                    }
                    catch (OXException x) {
                        LOG.error((Object)("Can not calculate recurrence " + ao.getObjectID() + ':' + this.sessionObj.getContextId()), (Throwable)x);
                    }
                    if (recuResults != null && recuResults.size() == 1) {
                        ao.setStartDate(new Date(recuResults.getRecurringResult(0).getStart()));
                        ao.setEndDate(new Date(recuResults.getRecurringResult(0).getEnd()));
                    } else {
                        LOG.warn((Object)("Cannot load first recurring appointment from appointment object: " + ao.getRecurrenceType() + " / " + ao.getObjectID() + "\n\n\n"));
                    }
                }
                AppointmentWriter.addElement("start_date", ao.getStartDate(), e_prop);
                AppointmentWriter.addElement("end_date", ao.getEndDate(), e_prop);
            }
            if (ao.containsDeleteExceptions() && (deleteExceptions = ao.getDeleteException()) != null) {
                stringBuilder = new StringBuilder();
                for (a = 0; a < deleteExceptions.length; ++a) {
                    if (a > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(deleteExceptions[a].getTime());
                }
                AppointmentWriter.addElement("deleteexceptions", stringBuilder.toString(), e_prop);
            }
            if (ao.containsChangeExceptions() && (changeException = ao.getChangeException()) != null) {
                stringBuilder = new StringBuilder();
                for (a = 0; a < changeException.length; ++a) {
                    if (a > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(changeException[a].getTime());
                }
                AppointmentWriter.addElement("changeexceptions", stringBuilder.toString(), e_prop);
            }
            AppointmentWriter.addElement("location", ao.getLocation(), e_prop);
            AppointmentWriter.addElement("full_time", fullTime, e_prop);
            AppointmentWriter.addElement("shown_as", ao.getShownAs(), e_prop);
            if (ao.containsRecurrenceDatePosition()) {
                AppointmentWriter.addElement("recurrence_date_position", ao.getRecurrenceDatePosition(), e_prop);
            }
            if (ao.containsAlarm()) {
                AppointmentWriter.addElement("alarm_flag", true, e_prop);
                AppointmentWriter.addElement("alarm", ao.getAlarm(), e_prop);
            } else {
                AppointmentWriter.addElement("alarm_flag", false, e_prop);
            }
            if (ao.getIgnoreConflicts()) {
                AppointmentWriter.addElement("ignore_conflicts", true, e_prop);
            }
            if (ao.containsUid()) {
                AppointmentWriter.addElement("uid", ao.getUid(), e_prop);
            }
            AppointmentWriter.addElement("color_label", ao.getLabel(), e_prop);
            this.writeCalendarElements(ao, e_prop);
        }
    }

    @Override
    protected int getModule() {
        return 1;
    }

    private static int[] checkChangeExceptions(int folderId, Appointment master, Session session) throws OXException {
        Date[] changeExceptions = master.getChangeException();
        if (null == changeExceptions || changeExceptions.length == 0) {
            return new int[0];
        }
        Date[] deleteExceptions = master.getDeleteException();
        ArrayList<Date> dlist = null == deleteExceptions ? new ArrayList<Date>(changeExceptions.length) : new ArrayList<Date>(Arrays.asList(deleteExceptions));
        ArrayList<Date> clist = new ArrayList<Date>(Arrays.asList(changeExceptions));
        int[] ids = new int[changeExceptions.length];
        int c = 0;
        boolean applyNewExceptions = false;
        Iterator iterator = clist.iterator();
        while (iterator.hasNext()) {
            Date changeException = (Date)iterator.next();
            CalendarCollectionService calColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
            CalendarDataObject app = calColl.getChangeExceptionByDate(folderId, master.getRecurrenceID(), changeException, changeFields, session);
            if (null == app || AppointmentWriter.isVisibleAsParticipantOrOwner(app, session.getUserId())) continue;
            iterator.remove();
            dlist.add(changeException);
            Collections.sort(dlist);
            ids[c++] = app.getObjectID();
            applyNewExceptions = true;
        }
        if (!applyNewExceptions) {
            return new int[0];
        }
        master.setChangeExceptions(clist.isEmpty() ? null : clist.toArray(new Date[clist.size()]));
        master.setDeleteExceptions(dlist.isEmpty() ? null : dlist.toArray(new Date[dlist.size()]));
        int[] retval = new int[c];
        System.arraycopy(ids, 0, retval, 0, c);
        return retval;
    }

    private static boolean isVisibleAsParticipantOrOwner(Appointment appointment, int userId) {
        if (appointment.getCreatedBy() == userId) {
            return true;
        }
        UserParticipant[] users = appointment.getUsers();
        if (users == null) {
            return false;
        }
        for (UserParticipant user : users) {
            if (user.getIdentifier() != userId) continue;
            return true;
        }
        return false;
    }
}

