/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.helpers;

import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.AbstractResource;
import com.openexchange.webdav.protocol.helpers.PropertyMixin;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public abstract class AbstractWebdavFactory
implements WebdavFactory {
    private PropertyMixin[] mixins;

    @Override
    public void beginRequest() {
    }

    @Override
    public void endRequest(int status) {
    }

    @Override
    public WebdavCollection resolveCollection(String url) throws WebdavProtocolException {
        url = this.normalize(url);
        return this.resolveCollection(this.decode(new WebdavPath((CharSequence)url)));
    }

    @Override
    public WebdavResource resolveResource(String url) throws WebdavProtocolException {
        url = this.normalize(url);
        return this.resolveResource(this.decode(new WebdavPath((CharSequence)url)));
    }

    public WebdavPath decode(WebdavPath webdavPath) {
        WebdavPath path = new WebdavPath(new String[0]);
        for (String component : webdavPath) {
            try {
                path.append(URLDecoder.decode(component, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return path;
    }

    public <T extends AbstractResource> T mixin(T thing) {
        if (this.mixins != null) {
            thing.includeProperties(this.mixins);
        }
        return thing;
    }

    protected String normalize(String url) {
        if (url.length() == 0) {
            return "/";
        }
        if ((url = url.replaceAll("/+", "/")).charAt(url.length() - 1) == '/') {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public void setGlobalMixins(PropertyMixin ... mixins) {
        this.mixins = mixins;
    }
}

