/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.helpers;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavMultistatusException;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.AbstractResource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractCollection
extends AbstractResource
implements WebdavCollection {
    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public void putBody(InputStream data, boolean guessSize) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public InputStream getBody() throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public WebdavCollection toCollection() {
        return this;
    }

    @Override
    public String getResourceType() throws WebdavProtocolException {
        return "<D:collection />";
    }

    @Override
    public String getLanguage() throws WebdavProtocolException {
        return null;
    }

    @Override
    public void setLanguage(String lang) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public Long getLength() throws WebdavProtocolException {
        return null;
    }

    @Override
    public String getContentType() throws WebdavProtocolException {
        return "httpd/unix-directory";
    }

    @Override
    public void setSource(String source) throws WebdavProtocolException {
    }

    @Override
    public void delete() throws WebdavProtocolException {
        ArrayList<WebdavResource> copy = new ArrayList<WebdavResource>(this.getChildren());
        ArrayList<WebdavProtocolException> exceptions = new ArrayList<WebdavProtocolException>();
        for (WebdavResource res : copy) {
            try {
                res.delete();
            }
            catch (WebdavProtocolException e) {
                exceptions.add(e);
            }
        }
        try {
            this.internalDelete();
        }
        catch (WebdavProtocolException e) {
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            throw WebdavMultistatusException.create(this.getUrl(), exceptions);
        }
    }

    protected abstract void internalDelete() throws WebdavProtocolException;

    @Override
    public AbstractCollection instance(WebdavPath url) throws WebdavProtocolException {
        return (AbstractCollection)this.getFactory().resolveCollection(url);
    }

    @Override
    public WebdavResource copy(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        ArrayList<WebdavProtocolException> exceptions = new ArrayList<WebdavProtocolException>();
        try {
            WebdavResource copy = null;
            copy = !noroot ? super.copy(dest, noroot, overwrite) : this.getFactory().resolveCollection(dest);
            for (WebdavResource res : new ArrayList<WebdavResource>(this.getChildren())) {
                try {
                    res.copy(dest.dup().append(res.getUrl().name()));
                }
                catch (WebdavProtocolException e) {
                    exceptions.add(e);
                }
            }
            return copy;
        }
        catch (WebdavProtocolException e) {
            exceptions.add(e);
            if (exceptions.size() > 0) {
                throw WebdavMultistatusException.create(this.getUrl(), exceptions);
            }
            throw new IllegalStateException("Impossible");
        }
    }

    @Override
    public void setLength(Long l) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public String getETag() throws WebdavProtocolException {
        return null;
    }

    @Override
    public void setContentType(String s) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public WebdavResource resolveResource(WebdavPath subPath) throws WebdavProtocolException {
        return this.getFactory().resolveResource(this.getUrl().dup().append(subPath));
    }

    @Override
    public WebdavCollection resolveCollection(WebdavPath subPath) throws WebdavProtocolException {
        return this.getFactory().resolveCollection(this.getUrl() + "/" + subPath);
    }

    @Override
    public Iterator<WebdavResource> iterator() {
        try {
            return new ChildTreeIterator(this.getChildren().iterator());
        }
        catch (OXException e) {
            return null;
        }
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public Iterable<WebdavResource> toIterable(int depth) throws WebdavProtocolException {
        switch (depth) {
            case 0: {
                return new LinkedList<WebdavResource>();
            }
            case 1: {
                return this.getChildren();
            }
            case -1: {
                return this;
            }
        }
        throw new IllegalArgumentException("Depth can only be one of 0, 1 or INFINITY");
    }

    protected static class ChildTreeIterator
    implements Iterator<WebdavResource> {
        private Iterator<WebdavResource> subIterator;
        private final Iterator<WebdavResource> childIterator;

        public ChildTreeIterator(Iterator<WebdavResource> childIterator) {
            this.childIterator = childIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.subIterator != null) {
                if (this.subIterator.hasNext()) {
                    return true;
                }
                this.subIterator = null;
            }
            return this.childIterator.hasNext();
        }

        @Override
        public WebdavResource next() {
            if (this.subIterator != null && this.subIterator.hasNext()) {
                return this.subIterator.next();
            }
            WebdavResource res = this.childIterator.next();
            if (res.isCollection()) {
                this.subIterator = res.toCollection().iterator();
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

