/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.ifheader;

import com.openexchange.webdav.action.ifheader.IfHeaderList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IfHeader {
    private final List<IfHeaderList> lists = new ArrayList<IfHeaderList>();
    private final List<IfHeaderList> untagged = new ArrayList<IfHeaderList>();
    private final Map<String, List<IfHeaderList>> tagged = new HashMap<String, List<IfHeaderList>>();

    public List<IfHeaderList> getLists() {
        return Collections.unmodifiableList(this.lists);
    }

    public List<IfHeaderList> getRelevant(String url) {
        ArrayList<IfHeaderList> retval = new ArrayList<IfHeaderList>(this.untagged);
        if (this.tagged.containsKey(url)) {
            retval.addAll((Collection<IfHeaderList>)this.tagged.get(url));
        }
        return retval;
    }

    public IfHeaderList getList(int i) {
        return this.lists.get(i);
    }

    public void addList(IfHeaderList list) {
        if (list.isTagged()) {
            String tag = list.getTag();
            List<IfHeaderList> taggedList = this.tagged.get(tag);
            if (null == taggedList) {
                taggedList = new ArrayList<IfHeaderList>();
                this.tagged.put(tag, taggedList);
            }
            taggedList.add(list);
        } else {
            this.untagged.add(list);
        }
        this.lists.add(list);
    }
}

