/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import java.io.IOException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class WebdavReportAction
extends AbstractAction {
    private final Protocol protocol;

    public WebdavReportAction(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        try {
            Document reportQuery = req.getBodyAsDocument();
            Element root = reportQuery.getRootElement();
            String ns = root.getNamespace().getURI();
            String name = root.getName();
            WebdavAction reportAction = this.protocol.getReportAction(ns, name);
            if (reportAction == null) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 400);
            }
            reportAction.perform(req, res);
        }
        catch (JDOMException e) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 400);
        }
        catch (IOException e) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 500);
        }
    }
}

