/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.log.LogFactory;
import com.openexchange.tools.UnsynchronizedStringWriter;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.util.Utils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;

public class WebdavProppatchAction
extends AbstractAction {
    private static final Namespace DAV_NS = Namespace.getNamespace((String)"DAV:");
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(WebdavProppatchAction.class));
    private PropertyAction SET = null;
    private static final PropertyAction REMOVE = new RemoveAction();
    private final XMLOutputter outputter = new XMLOutputter();
    private final Protocol protocol;

    public WebdavProppatchAction(Protocol protocol) {
        this.SET = new SetAction(protocol);
        this.protocol = protocol;
    }

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        try {
            Document requestDoc = req.getBodyAsDocument();
            Document responseDoc = new Document();
            Element multistatus = new Element("multistatus", DAV_NS);
            List<Namespace> namespaces = this.protocol.getAdditionalNamespaces();
            for (Namespace namespace : namespaces) {
                multistatus.addNamespaceDeclaration(namespace);
            }
            responseDoc.addContent((Content)multistatus);
            Element response = new Element("response", DAV_NS);
            Element href = new Element("href", DAV_NS);
            href.setText(req.getURLPrefix() + req.getUrl());
            response.addContent((Content)href);
            multistatus.addContent((Content)response);
            WebdavResource resource = req.getResource();
            for (Element element : requestDoc.getRootElement().getChildren()) {
                PropertyAction action = null;
                if (element.getNamespace().equals((Object)DAV_NS)) {
                    if ("set".equals(element.getName())) {
                        action = this.SET;
                    } else if ("remove".equals(element.getName())) {
                        action = REMOVE;
                    }
                }
                if (null == action) continue;
                for (Element prop : element.getChildren("prop", DAV_NS)) {
                    response.addContent((Content)action.perform(prop, resource));
                }
            }
            resource.save();
            res.setStatus(207);
            res.setContentType("text/xml");
            this.outputter.output(responseDoc, res.getOutputStream());
        }
        catch (JDOMException e) {
            LOG.error((Object)"JDOMException: ", (Throwable)e);
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 500);
        }
        catch (IOException e) {
            LOG.debug((Object)"Client gone?", (Throwable)e);
        }
    }

    private static final class RemoveAction
    implements PropertyAction {
        private RemoveAction() {
        }

        @Override
        public Element perform(Element propElement, WebdavResource resource) {
            int status = 200;
            if (propElement.getChildren().isEmpty()) {
                Element propstat = new Element("propstat", DAV_NS);
                Element statusElement = new Element("status", DAV_NS);
                statusElement.setText("HTTP/1.1 " + status + " " + Utils.getStatusString(status));
                propstat.addContent((Content)statusElement);
                return propstat;
            }
            Element propertyElement = (Element)propElement.getChildren().get(0);
            try {
                resource.removeProperty(propertyElement.getNamespaceURI(), propertyElement.getName());
            }
            catch (WebdavProtocolException e) {
                status = e.getStatus();
            }
            Element propstat = new Element("propstat", DAV_NS);
            Element prop = new Element("prop", DAV_NS);
            Element propContent = new Element(propertyElement.getName(), Namespace.getNamespace((String)propertyElement.getNamespaceURI()));
            prop.addContent((Content)propContent);
            propstat.addContent((Content)prop);
            Element statusElement = new Element("status", DAV_NS);
            statusElement.setText("HTTP/1.1 " + status + " " + Utils.getStatusString(status));
            propstat.addContent((Content)statusElement);
            return propstat;
        }
    }

    private static final class SetAction
    implements PropertyAction {
        private final XMLOutputter outputter = new XMLOutputter();
        private final Protocol protocol;

        public SetAction(Protocol protocol) {
            this.protocol = protocol;
        }

        @Override
        public Element perform(Element propElement, WebdavResource resource) {
            int status = 200;
            if (propElement.getChildren().isEmpty()) {
                Element propstat = new Element("propstat", DAV_NS);
                Element statusElement = new Element("status", DAV_NS);
                statusElement.setText("HTTP/1.1 " + status + " " + Utils.getStatusString(status));
                propstat.addContent((Content)statusElement);
                return propstat;
            }
            Element propertyElement = (Element)propElement.getChildren().get(0);
            WebdavProperty property = new WebdavProperty();
            property.setNamespace(propertyElement.getNamespaceURI());
            property.setName(propertyElement.getName());
            if (this.protocol.isProtected(propertyElement.getNamespaceURI(), propertyElement.getName())) {
                status = 403;
            } else {
                if (propertyElement.getChildren().size() > 0) {
                    property.setXML(true);
                    try {
                        UnsynchronizedStringWriter w = new UnsynchronizedStringWriter();
                        this.outputter.output(propertyElement.cloneContent(), (Writer)w);
                        property.setValue(((Object)w).toString());
                    }
                    catch (IOException e) {
                        status = 500;
                    }
                } else {
                    property.setValue(propertyElement.getText());
                }
                try {
                    resource.putProperty(property);
                }
                catch (WebdavProtocolException e) {
                    status = e.getStatus();
                }
            }
            Element propstat = new Element("propstat", DAV_NS);
            Element prop = new Element("prop", DAV_NS);
            Element propContent = new Element(property.getName(), Namespace.getNamespace((String)property.getNamespace()));
            prop.addContent((Content)propContent);
            propstat.addContent((Content)prop);
            Element statusElement = new Element("status", DAV_NS);
            statusElement.setText("HTTP/1.1 " + status + " " + Utils.getStatusString(status));
            propstat.addContent((Content)statusElement);
            return propstat;
        }
    }

    static interface PropertyAction {
        public Element perform(Element var1, WebdavResource var2);
    }
}

