/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2425;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.StringCharacterIterator;
import java.util.regex.Pattern;

public class URIValueDefinition
extends ValueDefinition {
    public static final URIValueDefinition Default = new URIValueDefinition();
    private static final Pattern URIPattern = Pattern.compile("[^,]+");

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        if (s.length() == 0) {
            return null;
        }
        StringScanner scanner = this.deescapeColons(s);
        String value = scanner.regex(URIPattern);
        if (value == null) {
            throw new VersitException(scanner, "URI expected");
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            VersitException ve = new VersitException(scanner, e.getMessage());
            ve.initCause(e);
            throw ve;
        }
    }

    private StringScanner deescapeColons(StringScanner s) {
        String str = s.getRest();
        StringBuilder strBuilder = new StringBuilder();
        if (str.contains("\\:")) {
            StringCharacterIterator it = new StringCharacterIterator(str);
            char c = it.current();
            while (c != '\uffff') {
                if (c == '\\') {
                    c = it.next();
                    if (c == ':') {
                        strBuilder.append(':');
                        c = it.next();
                        continue;
                    }
                    if (c == '\uffff') {
                        strBuilder.append('\\');
                        continue;
                    }
                    strBuilder.append('\\');
                    strBuilder.append(c);
                    c = it.next();
                    continue;
                }
                strBuilder.append(c);
                c = it.next();
            }
            str = strBuilder.toString();
        }
        System.out.println(str);
        StringScanner result = new StringScanner(s.getScanner(), str);
        return result;
    }
}

