/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.tools.versit.FoldingWriter;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.PropertyDefinition;
import com.openexchange.tools.versit.ReaderScanner;
import com.openexchange.tools.versit.Scanner;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.VersitObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ObjectDefinition
implements VersitDefinition {
    private final Map<String, PropertyDefinition> Properties = new HashMap<String, PropertyDefinition>();
    private final Map<String, ObjectDefinition> Children = new HashMap<String, ObjectDefinition>();
    public static final ObjectDefinition Default = new ObjectDefinition();

    public ObjectDefinition() {
    }

    public ObjectDefinition(String[] propertyNames, PropertyDefinition[] properties, String[] childNames, ObjectDefinition[] children) {
        int i;
        for (i = 0; i < properties.length; ++i) {
            this.addProperty(propertyNames[i], properties[i]);
        }
        for (i = 0; i < childNames.length; ++i) {
            this.addChild(childNames[i], children[i]);
        }
    }

    private ObjectDefinition(Map<String, PropertyDefinition> properties, Map<String, ObjectDefinition> children) {
        this.Properties.putAll(properties);
        this.Children.putAll(children);
    }

    public PropertyDefinition getProperty(String name) {
        return this.Properties.get(name.toUpperCase(Locale.ENGLISH));
    }

    public final void addProperty(String name, PropertyDefinition property) {
        this.Properties.put(name.toUpperCase(Locale.ENGLISH), property);
    }

    public final void addChild(String name, ObjectDefinition child) {
        this.Children.put(name.toUpperCase(Locale.ENGLISH), child);
    }

    protected Property parseProperty(Scanner s) throws IOException {
        PropertyDefinition propdef;
        while (s.peek == -2) {
            s.read();
        }
        String name = s.parseName();
        if (name.length() == 0) {
            return null;
        }
        if (s.peek == 46) {
            s.read();
            name = s.parseName();
            if (name.length() == 0) {
                return null;
            }
        }
        if ((propdef = this.getProperty(name)) == null) {
            propdef = PropertyDefinition.Default;
        }
        return propdef.parse(s, name);
    }

    @Override
    public VersitDefinition.Reader getReader(InputStream stream, String charset) throws IOException {
        return new ReaderScanner(new InputStreamReader(stream, charset));
    }

    @Override
    public VersitObject parse(VersitDefinition.Reader reader) throws IOException {
        VersitObject object = this.parseBegin(reader);
        if (object != null) {
            VersitObject child;
            while ((child = this.parseChild(reader, object)) != null) {
                object.addChild(child);
            }
        }
        return object;
    }

    @Override
    public VersitObject parseBegin(VersitDefinition.Reader reader) throws IOException {
        Property begin;
        Scanner s = (Scanner)reader;
        while (true) {
            if (s.peek == -2) {
                s.read();
                continue;
            }
            if (s.peek == -1) {
                return null;
            }
            begin = Default.parseProperty(s);
            if (begin == null) {
                while (s.peek != -1 && s.peek != -2) {
                    s.read();
                }
            }
            if (begin != null && begin.name.equalsIgnoreCase("BEGIN")) break;
        }
        return new VersitObject((String)begin.getValue());
    }

    @Override
    public VersitObject parseChild(VersitDefinition.Reader reader, VersitObject object) throws IOException {
        Scanner s = (Scanner)reader;
        Property property = this.parseProperty(s);
        while (!(property == null || property.name.equalsIgnoreCase("END") && ((String)property.getValue()).equalsIgnoreCase(object.name))) {
            if (property.name.equalsIgnoreCase("BEGIN")) {
                VersitObject grandchild;
                String childName = ((String)property.getValue()).toUpperCase();
                VersitDefinition def = this.getChildDef(childName);
                VersitObject child = new VersitObject(childName);
                while ((grandchild = def.parseChild(s, child)) != null) {
                    child.addChild(grandchild);
                }
                return child;
            }
            if (!property.isInvalid()) {
                object.addProperty(property);
            }
            property = this.parseProperty(s);
        }
        if (property == null) {
            throw new VersitException(s, "Incomplete object");
        }
        return null;
    }

    @Override
    public VersitDefinition.Writer getWriter(OutputStream stream, String charset) throws IOException {
        return new FoldingWriter(new OutputStreamWriter(stream, charset));
    }

    @Override
    public void write(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        this.writeProperties(writer, object);
        this.writeEnd(writer, object);
    }

    @Override
    public void writeProperties(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        Object definition;
        int i;
        FoldingWriter fw = (FoldingWriter)writer;
        fw.write("BEGIN:");
        fw.writeln(object.name);
        int count = object.getPropertyCount();
        for (i = 0; i < count; ++i) {
            Property property = object.getProperty(i);
            definition = this.getProperty(property.name);
            if (definition == null) continue;
            ((PropertyDefinition)definition).write(fw, property);
        }
        count = object.getChildCount();
        for (i = 0; i < count; ++i) {
            VersitObject child = object.getChild(i);
            definition = this.getChildDef(child.name);
            definition.write(fw, child);
        }
    }

    @Override
    public void writeEnd(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        FoldingWriter fw = (FoldingWriter)writer;
        fw.write("END:");
        fw.writeln(object.name);
    }

    @Override
    public VersitDefinition getChildDef(String name) {
        VersitDefinition child = this.Children.get(name.toUpperCase(Locale.ENGLISH));
        if (child == null) {
            return Default;
        }
        return child;
    }

    @Override
    public Iterator<PropertyDefinition> iterator() {
        return this.Properties.values().iterator();
    }

    @Override
    public VersitDefinition copy() {
        return new ObjectDefinition(this.Properties, this.Children);
    }
}

