/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.update;

import com.openexchange.tools.Collections;
import com.openexchange.tools.update.IndexNotFoundException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Index {
    private String name;
    private List<String> columns = new ArrayList<String>();
    private String table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Index> findAllIndexes(Connection con, String tableName) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SHOW INDEX FROM `" + tableName + '`');
            rs = stmt.executeQuery();
            ArrayList<Index> retval = new ArrayList<Index>();
            HashMap<String, Index> indexes = new HashMap<String, Index>();
            while (rs.next()) {
                Index id;
                String name = rs.getString("Key_name");
                if (indexes.containsKey(name)) {
                    id = (Index)indexes.get(name);
                } else {
                    id = new Index();
                    id.setTable(tableName);
                    id.setName(name);
                    indexes.put(name, id);
                    retval.add(id);
                }
                id._setColumnAt(rs.getInt("Seq_in_index") - 1, rs.getString("Column_name"));
            }
            ArrayList<Index> arrayList = retval;
            return arrayList;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    public static Index findByName(Connection con, String tableName, String indexName) throws IndexNotFoundException, SQLException {
        List<Index> allIndexes = Index.findAllIndexes(con, tableName);
        Index id = Collections.findFirst(allIndexes, new NameFilter(indexName));
        if (id == null) {
            throw new IndexNotFoundException("Couldn't find index with name " + indexName);
        }
        return id;
    }

    public static List<Index> findContainingColumns(Connection con, String tableName, String ... columns) throws SQLException {
        List<Index> allIndexes = Index.findAllIndexes(con, tableName);
        ArrayList<Index> retval = new ArrayList<Index>();
        Collections.collect(allIndexes, new ContainsColumnFilter(columns), retval);
        return retval;
    }

    public static List<Index> findWithColumns(Connection con, String tableName, String ... columns) throws SQLException {
        List<Index> allIndexes = Index.findAllIndexes(con, tableName);
        ArrayList<Index> retval = new ArrayList<Index>();
        Collections.collect(allIndexes, new ExactColumnFilter(columns), retval);
        return retval;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(String ... columns) {
        this.setColumns(Arrays.asList(columns));
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.prepareStatement("DROP INDEX `" + this.name + "` ON `" + this.table + '`');
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Connection con) throws SQLException {
        if (this.name == null || this.table == null || this.columns.size() == 0) {
            throw new IllegalStateException("You must set name and table to create an index. Also the index must span at least one column");
        }
        Statement stmt = null;
        try {
            stmt = con.prepareStatement("CREATE INDEX `" + this.name + "` ON `" + this.table + "` (" + this._join_cols() + ')');
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void _setColumnAt(int index, String column) {
        this._ensureSize(index + 1);
        this.columns.set(index, column);
    }

    public void _ensureSize(int size) {
        while (size > this.columns.size()) {
            this.columns.add(null);
        }
    }

    public String _join_cols() {
        StringBuilder b = new StringBuilder();
        for (String col : this.columns) {
            b.append(col).append(',');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(50).append("Index ");
        b.append(this.name);
        b.append(" (").append(this.table).append(") with Columns: ").append(this._join_cols()).append(')');
        return b.toString();
    }

    public static class ExactColumnFilter
    implements Collections.Filter<Index> {
        private final String[] columns;

        public ExactColumnFilter(String ... columns) {
            this.columns = columns;
        }

        @Override
        public boolean accept(Index object) {
            if (this.columns.length != object.getColumns().size()) {
                return false;
            }
            List<String> colObject = object.getColumns();
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.columns[i].equalsIgnoreCase(colObject.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class ContainsColumnFilter
    implements Collections.Filter<Index> {
        private final String[] columns;

        public ContainsColumnFilter(String ... columns) {
            this.columns = columns;
        }

        @Override
        public boolean accept(Index object) {
            HashSet<String> needed = new HashSet<String>(Arrays.asList(this.columns));
            for (String col : object.getColumns()) {
                for (String need : new HashSet<String>(needed)) {
                    if (!need.equalsIgnoreCase(col)) continue;
                    needed.remove(need);
                }
                if (!needed.isEmpty()) continue;
                return true;
            }
            return needed.isEmpty();
        }
    }

    public static class NameFilter
    implements Collections.Filter<Index> {
        private final String name;

        public NameFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(Index object) {
            return object.getName().equalsIgnoreCase(this.name);
        }
    }
}

