/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.pipesnfilters.internal;

import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.tools.pipesnfilters.DataSource;
import com.openexchange.tools.pipesnfilters.Filter;
import com.openexchange.tools.pipesnfilters.PipesAndFiltersException;
import com.openexchange.tools.pipesnfilters.internal.DataSink;
import java.util.ArrayList;

class FilterTask<I, O>
extends AbstractTask<Void> {
    private final DataSource<I> input;
    private final Filter<I, O> filter;
    private final DataSink<O> output;

    public FilterTask(DataSource<I> input, Filter<I, O> filter, DataSink<O> output) {
        this.input = input;
        this.filter = filter;
        this.output = output;
    }

    public void setThreadName(ThreadRenamer threadRenamer) {
        threadRenamer.renamePrefix("Pipes&Filters " + this.filter.getClass().getName());
    }

    public Void call() {
        ArrayList inputBlock = new ArrayList();
        try {
            while (this.input.hasData()) {
                this.input.getData(inputBlock);
                if (inputBlock.isEmpty()) continue;
                O[] outputBlock = this.filter.filter(inputBlock);
                inputBlock.clear();
                for (O outputElement : outputBlock) {
                    this.output.put(outputElement);
                }
            }
            this.output.finished();
        }
        catch (PipesAndFiltersException e) {
            this.output.exception(e);
        }
        catch (Throwable t) {
            this.output.exception(new PipesAndFiltersException(t));
        }
        return null;
    }
}

