/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.treeconsistency;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class ToDoPermission {
    private final int folderId;
    private final Set<Integer> users;
    private final Set<Integer> groups;

    ToDoPermission(int folderId) {
        this.folderId = folderId;
        this.users = new HashSet<Integer>(4);
        this.groups = new HashSet<Integer>(4);
    }

    void addEntity(int entity, boolean isGroup) {
        if (isGroup) {
            this.addGroup(entity);
        } else {
            this.addUser(entity);
        }
    }

    void addUser(int user) {
        this.users.add(user);
    }

    void addGroup(int group) {
        this.groups.add(group);
    }

    int getFolderId() {
        return this.folderId;
    }

    int[] getUsers() {
        int size = this.users.size();
        int[] retval = new int[size];
        if (size == 0) {
            return retval;
        }
        Iterator<Integer> i = this.users.iterator();
        for (int j = 0; j < size; ++j) {
            retval[j] = i.next();
        }
        return retval;
    }

    int[] getGroups() {
        int size = this.groups.size();
        int[] retval = new int[size];
        if (size == 0) {
            return retval;
        }
        Iterator<Integer> i = this.groups.iterator();
        for (int j = 0; j < size; ++j) {
            retval[j] = i.next();
        }
        return retval;
    }
}

