/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMap;
import gnu.trove.ConcurrentTIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.logging.Log;

public final class ConditionTreeMapManagement {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ConditionTreeMapManagement.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static volatile ConditionTreeMapManagement instance;
    protected final ConcurrentTIntObjectHashMap<Future<ConditionTreeMap>> maps = new ConcurrentTIntObjectHashMap(256);
    private final boolean enabled;
    private volatile ScheduledTimerTask timerTask;

    public static void startInstance() {
        ConditionTreeMapManagement.stopInstance();
        instance = new ConditionTreeMapManagement();
        instance.start();
    }

    public static void stopInstance() {
        ConditionTreeMapManagement mm = instance;
        if (null == mm) {
            return;
        }
        mm.stop();
        instance = null;
    }

    public static ConditionTreeMapManagement getInstance() {
        return instance;
    }

    public static void dropFor(int contextId) {
        ConditionTreeMapManagement mm = instance;
        if (null != mm) {
            mm.maps.remove(contextId);
        }
    }

    private ConditionTreeMapManagement() {
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        this.enabled = null == service || service.getBoolProperty("com.openexchange.oxfolder.memory.enabled", true);
    }

    private void start() {
        int time2live = 300000;
        ShrinkerRunnable task = new ShrinkerRunnable(300000);
        int delay = 60000;
        this.timerTask = ServerServiceRegistry.getInstance().getService(TimerService.class).scheduleWithFixedDelay((Runnable)task, 60000L, 60000L);
    }

    private void stop() {
        ScheduledTimerTask timerTask = this.timerTask;
        if (null != timerTask) {
            timerTask.cancel();
            this.timerTask = null;
        }
    }

    public ConditionTreeMap getMapFor(int contextId) throws OXException {
        FutureTask<ConditionTreeMap> ft;
        if (!this.enabled) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create("Memory tree map disabled as per configuration.");
        }
        FutureTask<ConditionTreeMap> f = (FutureTask<ConditionTreeMap>)this.maps.get(contextId);
        if (null == f && null == (f = (Future)this.maps.putIfAbsent(contextId, ft = new FutureTask<ConditionTreeMap>(new InitTreeMapCallable(contextId, LOG))))) {
            f = ft;
            ft.run();
        }
        return this.getFrom((Future<ConditionTreeMap>)f);
    }

    public ConditionTreeMap optMapFor(int contextId) throws OXException {
        if (!this.enabled) {
            return null;
        }
        Future f = (Future)this.maps.get(contextId);
        if (null == f) {
            ThreadPools.getThreadPool().submit(ThreadPools.trackableTask((Runnable)new LoadTreeMapRunnable(contextId, LOG)));
            return null;
        }
        return this.timedFrom(f, 1000L);
    }

    protected ConditionTreeMap getFrom(Future<ConditionTreeMap> f) throws OXException {
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
    }

    protected ConditionTreeMap timedFrom(Future<ConditionTreeMap> f, long timeoutMillis) throws OXException {
        try {
            return f.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    protected void shrink(ShrinkTIntObjectProcedure procedure) {
        if (DEBUG) {
            long st = System.currentTimeMillis();
            this.maps.forEachEntry((TIntObjectProcedure)procedure.prepareNextRun());
            long dur = System.currentTimeMillis() - st;
            LOG.debug((Object)("ConditionTreeMapManagement.shrink() took " + dur + "msec."));
        } else {
            this.maps.forEachEntry((TIntObjectProcedure)procedure.prepareNextRun());
        }
    }

    private static final class InitTreeMapCallable
    implements Callable<ConditionTreeMap> {
        private final int contextId;
        private final Log logger;

        protected InitTreeMapCallable(int contextId, Log logger) {
            this.contextId = contextId;
            this.logger = logger;
        }

        @Override
        public ConditionTreeMap call() {
            try {
                ConditionTreeMap newMap = new ConditionTreeMap(this.contextId);
                newMap.init();
                return newMap;
            }
            catch (OXException e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private final class LoadTreeMapRunnable
    implements Runnable {
        private final int contextId;
        private final Log logger;

        protected LoadTreeMapRunnable(int contextId, Log logger) {
            this.contextId = contextId;
            this.logger = logger;
        }

        @Override
        public void run() {
            FutureTask<ConditionTreeMap> ft = new FutureTask<ConditionTreeMap>(new InitTreeMapCallable(this.contextId, this.logger));
            Future prev = (Future)ConditionTreeMapManagement.this.maps.putIfAbsent(this.contextId, ft);
            if (null == prev) {
                ft.run();
            }
        }
    }

    private final class ShrinkTIntObjectProcedure
    implements TIntObjectProcedure<Future<ConditionTreeMap>> {
        private final Lock rlock;
        private final Lock wlock;
        private final long time2live;
        private volatile long maxStamp;

        protected ShrinkTIntObjectProcedure(long time2live) {
            this.time2live = time2live;
            ReadWriteLock readWriteLock = ConditionTreeMapManagement.this.maps.getReadWriteLock();
            this.rlock = readWriteLock.readLock();
            this.wlock = readWriteLock.writeLock();
        }

        protected ShrinkTIntObjectProcedure prepareNextRun() {
            this.maxStamp = System.currentTimeMillis() - this.time2live;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean execute(int contextId, Future<ConditionTreeMap> f) {
            block5: {
                try {
                    ConditionTreeMap map = ConditionTreeMapManagement.this.getFrom(f);
                    if (map.stamp >= this.maxStamp) break block5;
                    this.rlock.unlock();
                    this.wlock.lock();
                    try {
                        ConditionTreeMapManagement.this.maps.remove(contextId);
                    }
                    finally {
                        this.rlock.lock();
                        this.wlock.unlock();
                    }
                }
                catch (OXException oXException) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    private final class ShrinkerRunnable
    implements Runnable {
        private final ShrinkTIntObjectProcedure procedure;

        protected ShrinkerRunnable(int time2live) {
            this.procedure = new ShrinkTIntObjectProcedure(time2live);
        }

        @Override
        public void run() {
            ConditionTreeMapManagement.this.shrink(this.procedure);
        }
    }
}

