/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.deletelistener.OXFolderDeleteListenerHelper;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import java.sql.Connection;
import java.sql.SQLException;

public class OXFolderDeleteListener
implements DeleteListener {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(OXFolderDeleteListener.class));
    private static final String TABLE_WORKING_FOLDER = "oxfolder_tree";
    private static final String TABLE_WORKING_PERMS = "oxfolder_permissions";
    private static final String TABLE_BACKUP_FOLDER = "del_oxfolder_tree";
    private static final String TABLE_BACKUP_PERMS = "del_oxfolder_permissions";

    @Override
    public void deletePerformed(DeleteEvent delEvent, Connection readCon, Connection writeCon) throws OXException {
        Context ctx = delEvent.getContext();
        long lastModified = System.currentTimeMillis();
        if (delEvent.getType() == 1) {
            this.handleUserDeletion(delEvent, readCon, writeCon, ctx, lastModified);
        } else if (delEvent.getType() == 2) {
            this.handleGroupDeletion(delEvent, readCon, writeCon, ctx, lastModified);
        }
        OXFolderDeleteListenerHelper.ensureConsistency(ctx, writeCon);
    }

    private void handleGroupDeletion(DeleteEvent delEvent, Connection readCon, Connection writeCon, Context ctx, long lastModified) throws OXException {
        try {
            int groupId = delEvent.getId();
            int mailadmin = ctx.getMailadmin();
            if (mailadmin == -1 && (mailadmin = OXFolderSQL.getContextMailAdmin(readCon, ctx)) == -1) {
                throw OXFolderExceptionCode.NO_ADMIN_USER_FOUND_IN_CONTEXT.create(ctx.getContextId());
            }
            OXFolderSQL.cleanseSystemPermissions(groupId, TABLE_WORKING_PERMS, writeCon, ctx);
            OXFolderSQL.cleanseSystemPermissions(groupId, TABLE_BACKUP_PERMS, writeCon, ctx);
            OXFolderSQL.handleEntityPermissions(groupId, mailadmin, lastModified, TABLE_WORKING_FOLDER, TABLE_WORKING_PERMS, readCon, writeCon, ctx);
            OXFolderSQL.handleEntityPermissions(groupId, mailadmin, lastModified, TABLE_BACKUP_FOLDER, TABLE_BACKUP_PERMS, readCon, writeCon, ctx);
            OXFolderSQL.updateLastModified(3, lastModified, mailadmin, writeCon, ctx);
            OXFolderSQL.updateLastModified(2, lastModified, mailadmin, writeCon, ctx);
            ConditionTreeMapManagement.dropFor(ctx.getContextId());
            if (FolderCacheManager.isInitialized()) {
                try {
                    FolderCacheManager.getInstance().removeFolderObject(3, ctx);
                    FolderCacheManager.getInstance().removeFolderObject(2, ctx);
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    protected void handleUserDeletion(DeleteEvent delEvent, Connection readCon, Connection writeCon, Context ctx, long lastModified) throws OXException {
        try {
            boolean isMailAdmin;
            int userId = delEvent.getId();
            int mailadmin = ctx.getMailadmin();
            if (mailadmin == -1 && (mailadmin = OXFolderSQL.getContextMailAdmin(readCon, ctx)) == -1) {
                throw OXFolderExceptionCode.NO_ADMIN_USER_FOUND_IN_CONTEXT.create(ctx.getContextId());
            }
            OXFolderSQL.cleanseSystemPermissions(userId, TABLE_WORKING_PERMS, writeCon, ctx);
            OXFolderSQL.cleanseSystemPermissions(userId, TABLE_BACKUP_PERMS, writeCon, ctx);
            boolean bl = isMailAdmin = mailadmin == userId;
            if (isMailAdmin) {
                OXFolderSQL.handleMailAdminPermissions(userId, TABLE_WORKING_FOLDER, TABLE_WORKING_PERMS, readCon, writeCon, ctx);
                OXFolderSQL.handleMailAdminPermissions(userId, TABLE_BACKUP_FOLDER, TABLE_BACKUP_PERMS, readCon, writeCon, ctx);
            } else {
                OXFolderSQL.handleEntityPermissions(userId, mailadmin, lastModified, TABLE_WORKING_FOLDER, TABLE_WORKING_PERMS, readCon, writeCon, ctx);
                OXFolderSQL.handleEntityPermissions(userId, mailadmin, lastModified, TABLE_BACKUP_FOLDER, TABLE_BACKUP_PERMS, readCon, writeCon, ctx);
            }
            if (isMailAdmin) {
                OXFolderSQL.handleMailAdminFolders(userId, TABLE_WORKING_FOLDER, TABLE_WORKING_PERMS, readCon, writeCon, ctx);
                OXFolderSQL.handleMailAdminFolders(userId, TABLE_BACKUP_FOLDER, TABLE_BACKUP_PERMS, readCon, writeCon, ctx);
            } else {
                OXFolderSQL.handleEntityFolders(userId, mailadmin, lastModified, TABLE_WORKING_FOLDER, TABLE_WORKING_PERMS, readCon, writeCon, ctx);
                OXFolderSQL.handleEntityFolders(userId, mailadmin, lastModified, TABLE_BACKUP_FOLDER, TABLE_BACKUP_PERMS, readCon, writeCon, ctx);
            }
            if (!isMailAdmin) {
                OXFolderSQL.updateLastModified(3, lastModified, mailadmin, writeCon, ctx);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                if (FolderCacheManager.isInitialized()) {
                    try {
                        FolderCacheManager.getInstance().removeFolderObject(3, ctx);
                    }
                    catch (OXException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }
}

