/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;

public final class OXFolderAdminHelper {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(OXFolderAdminHelper.class));
    private static final boolean ADMIN_EDITABLE = false;
    private static final int[] CHANGEABLE_PUBLIC_FOLDERS = new int[]{2, 9, 15};
    private static final String STR_TABLE = "#TABLE#";
    private static final String SQL_INSERT_SYSTEM_FOLDER = "INSERT INTO oxfolder_tree (fuid, cid, parent, fname, module, type, creating_date, created_from, changing_date, changed_from, permission_flag, subfolder_flag) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_SYSTEM_PERMISSION = "INSERT INTO oxfolder_permissions (cid, fuid, permission_id, fp, orp, owp, odp, admin_flag, group_flag) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_SPECIAL_FOLDER = "INSERT INTO oxfolder_specialfolders (tag, cid, fuid) VALUES (?,?,?)";
    private static final String STR_OXFOLDERTREE = "oxfolder_tree";
    private static final String STR_DELOXFOLDERTREE = "del_oxfolder_tree";
    private static final String STR_OXFOLDERPERMS = "oxfolder_permissions";
    private static final String SQL_DELETE_TABLE = "DELETE FROM #TABLE# WHERE cid = ?";
    private static final String SQL_UPDATE_FOLDER_TIMESTAMP = "UPDATE #FT# AS ot SET ot.changing_date = ? WHERE ot.cid = ? AND ot.fuid = ?";
    private static final String SQL_SELECT_FOLDER_IN_PERMISSIONS = "SELECT ot.fuid FROM #FT# AS ot JOIN #PT# as op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? WHERE op.permission_id = ? GROUP BY ot.fuid";
    private static final String SQL_SELECT_DISPLAY_NAME = "SELECT " + Contacts.mapping[500].getDBFieldName() + " FROM prg_contacts WHERE cid = ? AND " + Contacts.mapping[524].getDBFieldName() + " = ?";
    private static final String DEFAULT_CAL_NAME = "My Calendar";
    private static final String DEFAULT_CON_NAME = "My Contacts";
    private static final String DEFAULT_TASK_NAME = "My Tasks";

    public boolean isPublicFolderEditable(int cid, int userId, Connection readCon) throws OXException {
        boolean bl;
        int admin;
        try {
            admin = OXFolderAdminHelper.getContextAdminID(cid, readCon);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if (admin != userId) {
            return false;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean editable;
            stmt = readCon.prepareStatement("SELECT admin_flag FROM oxfolder_permissions WHERE cid = ? AND permission_id = ? AND fuid IN " + StringCollection.getSqlInString(CHANGEABLE_PUBLIC_FOLDERS));
            stmt.setInt(1, cid);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            boolean foundPermissions = false;
            for (editable = true; editable && rs.next(); editable &= rs.getInt(1) > 0) {
                foundPermissions = true;
            }
            bl = editable && foundPermissions;
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void setPublicFolderEditable(boolean editable, int cid, int userId, Connection writeCon) throws OXException {
        try {
            admin = OXFolderAdminHelper.getContextAdminID(cid, writeCon);
        }
        catch (OXException e) {
            OXFolderAdminHelper.LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        for (int id : OXFolderAdminHelper.CHANGEABLE_PUBLIC_FOLDERS) {
            block18: {
                try {
                    if (!OXFolderAdminHelper.checkFolderExistence(cid, id, writeCon)) {
                        OXFolderAdminHelper.createPublicFolder(id, cid, admin, writeCon, System.currentTimeMillis());
                    }
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, new Object[]{e.getMessage()});
                }
                stmt = null;
                rs = null;
                stmt = writeCon.prepareStatement("SELECT permission_id, admin_flag FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ?");
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, id);
                stmt.setInt(pos++, userId);
                rs = stmt.executeQuery();
                update = rs.next();
                prevEditable = update != false && rs.getInt(2) > 0;
                system = update != false ? rs.getInt(2) : -1;
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                if (admin == userId) ** GOTO lbl35
                if (prevEditable != editable && editable) break block18;
                DBUtils.closeSQLStuff(rs, stmt);
                return;
            }
            try {
                throw OXFolderExceptionCode.ADMIN_OP_ONLY.create();
lbl35:
                // 1 sources

                if (update) {
                    stmt = writeCon.prepareStatement("UPDATE oxfolder_permissions SET fp = ?, orp = ?, owp = ?, admin_flag = ?, odp = ? WHERE cid = ? AND fuid = ? AND permission_id = ? AND system = ?");
                    pos = 1;
                    stmt.setInt(pos++, 8);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, editable != false ? 1 : 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, cid);
                    stmt.setInt(pos++, id);
                    stmt.setInt(pos++, admin);
                    stmt.setInt(pos++, system);
                    stmt.executeUpdate();
                } else {
                    stmt = writeCon.prepareStatement("INSERT INTO oxfolder_permissions (cid, fuid, permission_id, fp, orp, owp, odp, admin_flag, group_flag, system) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    pos = 1;
                    stmt.setInt(pos++, cid);
                    stmt.setInt(pos++, id);
                    stmt.setInt(pos++, admin);
                    stmt.setInt(pos++, 8);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, editable != false ? 1 : 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, 0);
                    stmt.executeUpdate();
                }
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
                ctx = new ContextImpl(cid);
                ctx.setMailadmin(admin);
                OXFolderSQL.updateLastModified(id, System.currentTimeMillis(), admin, writeCon, ctx);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                try {
                    if (FolderCacheManager.isEnabled()) {
                        FolderCacheManager.getInstance().removeFolderObject(id, ctx);
                    }
                    if (FolderQueryCacheManager.isInitialized()) {
                        FolderQueryCacheManager.getInstance().invalidateContextQueries(cid);
                    }
                    if (CalendarCache.isInitialized()) {
                        CalendarCache.getInstance().invalidateGroup(cid);
                    }
                }
                catch (OXException e) {
                    OXFolderAdminHelper.LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SQLException e) {
                try {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, new Object[]{e.getMessage()});
                }
                catch (Throwable var18_21) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw var18_21;
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreDefaultGlobalAddressBookPermissions(int cid, boolean enable) throws OXException {
        TIntLinkedList users;
        ResultSet rs;
        PreparedStatement stmt;
        Connection writeCon = Database.get(cid, true);
        try {
            if (OXFolderAdminHelper.checkGlobalGABPermissionExistence(cid, writeCon)) {
                LOG.warn((Object)"Cannot restore individual global address book permissions since global permission is active.");
                return;
            }
            stmt = null;
            rs = null;
            try {
                stmt = writeCon.prepareStatement("SELECT id FROM user WHERE cid = ?");
                boolean pos = true;
                stmt.setInt(1, cid);
                rs = stmt.executeQuery();
                users = new TIntLinkedList();
                while (rs.next()) {
                    users.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                try {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (users.isEmpty()) return;
        Integer admin = OXFolderAdminHelper.getContextAdminID(cid, writeCon);
        int size = users.size();
        for (int i = 1; i < size; ++i) {
            this.setGlobalAddressBookDisabled(cid, users.get(i), !enable, writeCon, admin, false);
        }
        this.setGlobalAddressBookDisabled(cid, users.get(0), !enable, writeCon, admin, true);
        return;
        finally {
            Database.back(cid, true, writeCon);
        }
    }

    public boolean isGlobalAddressBookDisabled(int cid, int userId, Connection readCon) throws OXException {
        boolean bl;
        ResultSet rs;
        PreparedStatement stmt;
        block8: {
            int globalAddressBookId = 6;
            try {
                int[] perms = OXFolderAdminHelper.getPermissionValue(cid, 6, 0, readCon);
                if (null != perms) {
                    LOG.warn((Object)("Cannot look-up individual user permission: Global permission is active on global address book folder.\nReturning global permission instead. user=" + userId + ", context=" + cid));
                    return perms[0] == 0;
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            stmt = null;
            rs = null;
            stmt = readCon.prepareStatement("SELECT fp, orp FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, 6);
            stmt.setInt(pos++, userId);
            rs = stmt.executeQuery();
            if (!rs.next()) break block8;
            boolean bl2 = rs.getInt(1) == 0;
            DBUtils.closeSQLStuff(rs, stmt);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    public void setGlobalAddressBookDisabled(int cid, int userId, boolean disable, Connection writeCon) throws OXException {
        this.setGlobalAddressBookDisabled(cid, userId, disable, writeCon, null, true);
    }

    private void setGlobalAddressBookDisabled(int cid, int userId, boolean disable, Connection writeCon, Integer adminId, boolean propagate) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        block24: {
            int admin = adminId == null ? OXFolderAdminHelper.getContextAdminID(cid, writeCon) : adminId;
            boolean isAdmin = admin == userId;
            int globalAddressBookId = 6;
            if (isAdmin) {
                try {
                    if (!OXFolderAdminHelper.checkFolderExistence(cid, 6, writeCon)) {
                        this.createGlobalAddressBook(cid, admin, writeCon, System.currentTimeMillis());
                    }
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            try {
                if (OXFolderAdminHelper.checkGlobalGABPermissionExistence(cid, writeCon)) {
                    LOG.warn((Object)("Cannot update individual permission on global address book folder since global permission is active. user=" + userId + ", context=" + cid));
                    return;
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            stmt = null;
            rs = null;
            try {
                stmt = writeCon.prepareStatement("SELECT permission_id,system FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ?");
                int pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, 6);
                stmt.setInt(pos++, userId);
                rs = stmt.executeQuery();
                boolean update = rs.next();
                int system = update ? rs.getInt(2) : -1;
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                if (update) {
                    stmt = writeCon.prepareStatement("UPDATE oxfolder_permissions SET fp = ?, orp = ?, owp = ?, admin_flag = ?, odp = ? WHERE cid = ? AND fuid = ? AND permission_id = ? AND system = ?");
                    pos = 1;
                    if (disable) {
                        stmt.setInt(pos++, 0);
                        stmt.setInt(pos++, 0);
                        stmt.setInt(pos++, 0);
                    } else {
                        stmt.setInt(pos++, 2);
                        stmt.setInt(pos++, 4);
                        stmt.setInt(pos++, OXFolderProperties.isEnableInternalUsersEdit() ? 2 : 0);
                    }
                    stmt.setInt(pos++, isAdmin ? 1 : 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, cid);
                    stmt.setInt(pos++, 6);
                    stmt.setInt(pos++, userId);
                    stmt.setInt(pos++, system);
                    stmt.executeUpdate();
                } else {
                    stmt = writeCon.prepareStatement("INSERT INTO oxfolder_permissions (cid, fuid, permission_id, fp, orp, owp, odp, admin_flag, group_flag, system) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    pos = 1;
                    stmt.setInt(pos++, cid);
                    stmt.setInt(pos++, 6);
                    stmt.setInt(pos++, userId);
                    if (disable) {
                        stmt.setInt(pos++, 0);
                        stmt.setInt(pos++, 0);
                        stmt.setInt(pos++, 0);
                    } else {
                        stmt.setInt(pos++, 2);
                        stmt.setInt(pos++, 4);
                        stmt.setInt(pos++, OXFolderProperties.isEnableInternalUsersEdit() ? 2 : 0);
                    }
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, isAdmin ? 1 : 0);
                    stmt.setInt(pos++, 0);
                    stmt.setInt(pos++, 0);
                    stmt.executeUpdate();
                }
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
                if (!propagate) break block24;
                ContextImpl ctx = new ContextImpl(cid);
                ctx.setMailadmin(admin);
                OXFolderSQL.updateLastModified(6, System.currentTimeMillis(), admin, writeCon, ctx);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                try {
                    CacheService service;
                    if (FolderCacheManager.isEnabled()) {
                        FolderCacheManager.getInstance().removeFolderObject(6, ctx);
                    }
                    if (FolderQueryCacheManager.isInitialized()) {
                        FolderQueryCacheManager.getInstance().invalidateContextQueries(cid);
                    }
                    if (CalendarCache.isInitialized()) {
                        CalendarCache.getInstance().invalidateGroup(cid);
                    }
                    if (null != (service = ServerServiceRegistry.getInstance().getService(CacheService.class))) {
                        String[] trees;
                        Cache cache = service.getCache("GlobalFolderCache");
                        String sContextId = Integer.toString(cid);
                        for (String tid : trees = new String[]{FolderStorage.REAL_TREE_ID, "1", "20"}) {
                            CacheKey cacheKey = service.newCacheKey(1, new Serializable[]{tid, Integer.toString(6)});
                            cache.removeFromGroup((Serializable)cacheKey, sContextId);
                        }
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SQLException e) {
                try {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    public void addContextSystemFolders(int cid, String mailAdminDisplayName, String language, Connection con) throws OXException {
        try {
            int contextMalAdmin = OXFolderAdminHelper.getContextAdminID(cid, con);
            this.addContextSystemFolders(cid, contextMalAdmin, mailAdminDisplayName, language, con);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static int getContextAdminID(int cid, Connection readCon) throws OXException {
        try {
            int retval = OXFolderSQL.getContextAdminID(new ContextImpl(cid), readCon);
            if (retval == -1) {
                throw OXFolderExceptionCode.NO_ADMIN_USER_FOUND_IN_CONTEXT.create(cid);
            }
            return retval;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private void addContextSystemFolders(int cid, int mailAdmin, String mailAdminDisplayName, String language, Connection writeCon) throws SQLException, OXException {
        long creatingTime = System.currentTimeMillis();
        OCLPermission systemPermission = new OCLPermission();
        systemPermission.setEntity(0);
        systemPermission.setGroupPermission(true);
        systemPermission.setAllPermission(8, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(1, "private", systemPermission, 0, 5, true, creatingTime, mailAdmin, true, cid, writeCon);
        if (!OXFolderAdminHelper.checkFolderExistence(cid, 2, writeCon)) {
            OXFolderAdminHelper.createSystemPublicFolder(cid, mailAdmin, writeCon, creatingTime);
        }
        systemPermission.setAllPermission(2, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(3, "shared", systemPermission, 0, 5, true, creatingTime, mailAdmin, true, cid, writeCon);
        systemPermission.setAllPermission(2, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(4, "system", systemPermission, 0, 5, true, creatingTime, mailAdmin, true, cid, writeCon);
        if (!OXFolderAdminHelper.checkFolderExistence(cid, 9, writeCon)) {
            OXFolderAdminHelper.createSystemInfostoreFolder(cid, mailAdmin, writeCon, creatingTime);
        }
        systemPermission.setAllPermission(8, 128, 128, 128);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(5, "system_global", systemPermission, 4, 3, true, creatingTime, mailAdmin, true, cid, writeCon);
        int globalAddressBookId = 6;
        if (OXFolderAdminHelper.checkFolderExistence(cid, 6, writeCon)) {
            ContextImpl ctx = new ContextImpl(cid);
            ctx.setMailadmin(mailAdmin);
            try {
                OXFolderSQL.updateLastModified(6, creatingTime, mailAdmin, writeCon, ctx);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            this.createGlobalAddressBook(cid, mailAdmin, writeCon, creatingTime);
        }
        systemPermission.setAllPermission(2, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(7, "user", systemPermission, 0, 5, true, creatingTime, mailAdmin, true, cid, writeCon);
        systemPermission.setAllPermission(8, 4, 2, 2);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(8, "projects", systemPermission, 7, 5, true, creatingTime, mailAdmin, true, cid, writeCon);
        systemPermission.setAllPermission(2, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(10, "userstore", systemPermission, 9, 8, true, creatingTime, mailAdmin, true, cid, writeCon);
        if (!OXFolderAdminHelper.checkFolderExistence(cid, 15, writeCon)) {
            OXFolderAdminHelper.createSystemPublicInfostoreFolder(cid, mailAdmin, writeCon, creatingTime);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("All System folders successfully created for context " + cid));
        }
        this.createSingleUserPermission(5, mailAdmin, new int[]{128, 128, 128, 128}, true, cid, writeCon);
        this.createSingleUserPermission(8, mailAdmin, new int[]{128, 128, 128, 128}, true, cid, writeCon);
        this.addUserToOXFolders(mailAdmin, mailAdminDisplayName, language, cid, writeCon);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Folder rights for mail admin successfully added for context " + cid));
        }
    }

    private static void createPublicFolder(int folderId, int cid, int mailAdmin, Connection writeCon, long creatingTime) throws SQLException {
        if (2 == folderId) {
            OXFolderAdminHelper.createSystemPublicFolder(cid, mailAdmin, writeCon, creatingTime);
        } else if (9 == folderId) {
            OXFolderAdminHelper.createSystemInfostoreFolder(cid, mailAdmin, writeCon, creatingTime);
        } else if (15 == folderId) {
            OXFolderAdminHelper.createSystemPublicInfostoreFolder(cid, mailAdmin, writeCon, creatingTime);
        } else {
            throw new IllegalArgumentException("Specified folder ID is not a public folder ID: " + folderId);
        }
    }

    private static void createSystemPublicFolder(int cid, int mailAdmin, Connection writeCon, long creatingTime) throws SQLException {
        OCLPermission systemPermission = new OCLPermission();
        systemPermission.setEntity(0);
        systemPermission.setGroupPermission(true);
        systemPermission.setAllPermission(8, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(2, "public", systemPermission, 0, 5, true, creatingTime, mailAdmin, true, cid, writeCon);
    }

    private static void createSystemInfostoreFolder(int cid, int mailAdmin, Connection writeCon, long creatingTime) throws SQLException {
        OCLPermission systemPermission = new OCLPermission();
        systemPermission.setEntity(0);
        systemPermission.setGroupPermission(true);
        systemPermission.setAllPermission(2, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(9, "infostore", systemPermission, 0, 5, true, creatingTime, mailAdmin, true, cid, writeCon);
    }

    private static void createSystemPublicInfostoreFolder(int cid, int mailAdmin, Connection writeCon, long creatingTime) throws SQLException {
        OCLPermission systemPermission = new OCLPermission();
        systemPermission.setEntity(0);
        systemPermission.setGroupPermission(true);
        systemPermission.setAllPermission(8, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        OXFolderAdminHelper.createSystemFolder(15, "public_infostore", systemPermission, 9, 8, true, creatingTime, mailAdmin, true, cid, writeCon);
    }

    private static boolean checkGlobalGABPermissionExistence(int cid, Connection con) throws SQLException {
        return OXFolderAdminHelper.checkPermissionExistence(cid, 6, 0, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkPermissionExistence(int cid, int folderId, int userId, Connection con) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT permission_id FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ?");
            stmt.setInt(1, cid);
            stmt.setInt(2, folderId);
            stmt.setInt(3, userId);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getPermissionValue(int cid, int folderId, int entityId, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            int[] nArray;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("SELECT fp, orp, owp, odp FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ?");
                stmt.setInt(1, cid);
                stmt.setInt(2, folderId);
                stmt.setInt(3, entityId);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                nArray = null;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return nArray;
        }
        int[] nArray = new int[]{rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4)};
        DBUtils.closeSQLStuff(rs, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkFolderExistence(int cid, int folderId, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, cid);
            stmt.setInt(2, folderId);
            boolean bl = stmt.executeQuery().next();
            return bl;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void createGlobalAddressBook(int cid, int mailAdmin, Connection writeCon, long creatingTime) throws SQLException {
        OCLPermission adminPermission = new OCLPermission();
        adminPermission.setEntity(mailAdmin);
        adminPermission.setGroupPermission(false);
        OXFolderAdminHelper.setGABPermissions(adminPermission);
        adminPermission.setFolderAdmin(true);
        OXFolderAdminHelper.createSystemFolder(6, "system_ldap", adminPermission, 4, 3, true, creatingTime, mailAdmin, false, cid, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSystemFolder(int systemFolderId, String systemFolderName, OCLPermission systemPermission, int parentId, int module, boolean insertIntoSpecialFolders, long creatingTime, int mailAdminId, boolean isPublic, int cid, Connection writeCon) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_INSERT_SYSTEM_FOLDER);
            stmt.setInt(1, systemFolderId);
            stmt.setInt(2, cid);
            stmt.setInt(3, parentId);
            stmt.setString(4, systemFolderName);
            stmt.setInt(5, module);
            stmt.setInt(6, 5);
            stmt.setLong(7, creatingTime);
            stmt.setInt(8, mailAdminId);
            stmt.setLong(9, creatingTime);
            stmt.setInt(10, mailAdminId);
            stmt.setInt(11, isPublic ? 2 : 3);
            stmt.setInt(12, 1);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement(SQL_INSERT_SYSTEM_PERMISSION);
            stmt.setInt(1, cid);
            stmt.setInt(2, systemFolderId);
            stmt.setInt(3, systemPermission.getEntity());
            stmt.setInt(4, systemPermission.getFolderPermission());
            stmt.setInt(5, systemPermission.getReadPermission());
            stmt.setInt(6, systemPermission.getWritePermission());
            stmt.setInt(7, systemPermission.getDeletePermission());
            stmt.setInt(8, systemPermission.isFolderAdmin() ? 1 : 0);
            stmt.setInt(9, systemPermission.isGroupPermission() ? 1 : 0);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            if (insertIntoSpecialFolders) {
                stmt = writeCon.prepareStatement(SQL_INSERT_SPECIAL_FOLDER);
                stmt.setString(1, systemFolderName);
                stmt.setInt(2, cid);
                stmt.setInt(3, systemFolderId);
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSingleUserPermission(int fuid, int userId, int[] allPerms, boolean isFolderAdmin, int cid, Connection writeCon) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_INSERT_SYSTEM_PERMISSION);
            stmt.setInt(1, cid);
            stmt.setInt(2, fuid);
            stmt.setInt(3, userId);
            stmt.setInt(4, allPerms[0]);
            stmt.setInt(5, allPerms[1]);
            stmt.setInt(6, allPerms[2]);
            stmt.setInt(7, allPerms[3]);
            stmt.setInt(8, isFolderAdmin ? 1 : 0);
            stmt.setInt(9, 0);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSinglePermission(int fuid, OCLPermission addMe, int cid, Connection writeCon) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_INSERT_SYSTEM_PERMISSION);
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, fuid);
            stmt.setInt(pos++, addMe.getEntity());
            stmt.setInt(pos++, addMe.getFolderPermission());
            stmt.setInt(pos++, addMe.getReadPermission());
            stmt.setInt(pos++, addMe.getWritePermission());
            stmt.setInt(pos++, addMe.getDeletePermission());
            stmt.setInt(pos++, addMe.isFolderAdmin() ? 1 : 0);
            stmt.setInt(pos++, addMe.isGroupPermission() ? 1 : 0);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllContextFolders(int cid, Connection readCon, Connection writeCon) {
        try {
            HashSet<String> oxfolderTables = new HashSet<String>();
            HashSet<String> delOxfolderTables = new HashSet<String>();
            DatabaseMetaData databaseMetaData = readCon.getMetaData();
            ResultSet rs = null;
            try {
                rs = databaseMetaData.getTables(null, null, "oxfolder_%", null);
                while (rs.next() && rs.getString(4).equals("TABLE")) {
                    oxfolderTables.add(rs.getString(3));
                }
                rs = databaseMetaData.getTables(null, null, "del_oxfolder_%", null);
                while (rs.next() && rs.getString(4).equals("TABLE")) {
                    delOxfolderTables.add(rs.getString(3));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            String rootTable = STR_OXFOLDERTREE;
            String delRootTable = STR_DELOXFOLDERTREE;
            oxfolderTables.remove(STR_OXFOLDERTREE);
            delOxfolderTables.remove(STR_DELOXFOLDERTREE);
            boolean performCommit = writeCon.getAutoCommit();
            if (performCommit) {
                writeCon.setAutoCommit(false);
            }
            String tableReplaceLabel = STR_TABLE;
            Statement stmt = null;
            try {
                String tblName;
                int i;
                int size = oxfolderTables.size();
                Iterator iter = oxfolderTables.iterator();
                for (i = 0; i < size; ++i) {
                    tblName = (String)iter.next();
                    stmt = writeCon.prepareStatement(SQL_DELETE_TABLE.replaceFirst(STR_TABLE, tblName));
                    stmt.setInt(1, cid);
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                size = delOxfolderTables.size();
                iter = delOxfolderTables.iterator();
                for (i = 0; i < size; ++i) {
                    tblName = (String)iter.next();
                    stmt = writeCon.prepareStatement(SQL_DELETE_TABLE.replaceFirst(STR_TABLE, tblName));
                    stmt.setInt(1, cid);
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                stmt = writeCon.prepareStatement(SQL_DELETE_TABLE.replaceFirst(STR_TABLE, STR_OXFOLDERTREE));
                stmt.setInt(1, cid);
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_TABLE.replaceFirst(STR_TABLE, STR_DELOXFOLDERTREE));
                stmt.setInt(1, cid);
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                if (performCommit) {
                    writeCon.commit();
                    writeCon.setAutoCommit(true);
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (performCommit) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateGroupModification(int group, Connection readCon, Connection writeCon, int cid) throws SQLException {
        try {
            int[] members;
            for (int member : members = GroupStorage.getInstance().getGroup(group, ContextStorage.getStorageContext(cid)).getMember()) {
                CacheFolderStorage.getInstance().clearCache(member, cid);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        long lastModified = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(SQL_SELECT_FOLDER_IN_PERMISSIONS.replaceFirst("#FT#", STR_OXFOLDERTREE).replaceFirst("#PT#", STR_OXFOLDERPERMS));
            stmt.setInt(1, cid);
            stmt.setInt(2, cid);
            stmt.setInt(3, group);
            rs = stmt.executeQuery();
            TIntArrayList list = new TIntArrayList();
            while (rs.next()) {
                list.add(rs.getInt(1));
            }
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            stmt = null;
            if (!list.isEmpty()) {
                stmt = writeCon.prepareStatement(SQL_UPDATE_FOLDER_TIMESTAMP.replaceFirst("#FT#", STR_OXFOLDERTREE));
                do {
                    int fuid = list.removeAt(0);
                    stmt.setLong(1, lastModified);
                    stmt.setInt(2, cid);
                    stmt.setInt(3, fuid);
                    stmt.addBatch();
                    if (!FolderCacheManager.isInitialized()) continue;
                    try {
                        FolderCacheManager.getInstance().removeFolderObject(fuid, new ContextImpl(cid));
                    }
                    catch (OXException e) {
                        LOG.error((Object)"Folder could not be removed from cache", (Throwable)e);
                    }
                } while (!list.isEmpty());
                stmt.executeBatch();
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, null, true, cid);
            throw throwable;
        }
        DBUtils.closeResources(rs, (Statement)stmt, null, true, cid);
    }

    public static void propagateUserModification(int userId, int[] changedFields, long lastModified, Connection readCon, Connection writeCon, int cid) throws OXException {
        Arrays.sort(changedFields);
        int adminID = OXFolderAdminHelper.getContextAdminID(cid, writeCon);
        if (Arrays.binarySearch(changedFields, 500) > -1) {
            OXFolderAdminHelper.propagateDisplayNameModification(userId, lastModified, adminID, readCon, writeCon, cid);
        }
    }

    private static void propagateDisplayNameModification(int userId, long lastModified, int contextAdminID, Connection readCon, Connection writeCon, int cid) throws OXException {
        ContextImpl ctx = new ContextImpl(cid);
        ctx.setMailadmin(contextAdminID);
        try {
            OXFolderSQL.updateLastModified(3, lastModified, contextAdminID, writeCon, ctx);
            if (FolderCacheManager.isInitialized()) {
                FolderCacheManager.getInstance().removeFolderObject(3, ctx);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        try {
            int defaultInfostoreFolderId = OXFolderSQL.getUserDefaultFolder(userId, 8, readCon, ctx);
            String newDisplayName = OXFolderAdminHelper.getUserDisplayName(userId, cid, readCon == null ? writeCon : readCon);
            if (newDisplayName == null) {
                throw LdapExceptionCode.USER_NOT_FOUND.create(new Object[]{LdapExceptionCode.USER_NOT_FOUND, userId, cid}).setPrefix(EnumComponent.USER.getAbbreviation());
            }
            OXFolderSQL.updateName(defaultInfostoreFolderId, newDisplayName, lastModified, contextAdminID, writeCon, ctx);
            if (FolderCacheManager.isInitialized()) {
                FolderCacheManager.getInstance().removeFolderObject(defaultInfostoreFolderId, ctx);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static String getUserDisplayName(int userId, int cid, Connection con) throws OXException {
        String string;
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            try {
                stmt = con.prepareStatement(SQL_SELECT_DISPLAY_NAME);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            rs = null;
            stmt.setInt(1, cid);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            if (!rs.next()) break block7;
            String string2 = rs.getString(1);
            DBUtils.closeSQLStuff(rs, stmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return string;
    }

    public void addUserToOXFolders(int userId, String displayName, String language, int cid, Connection writeCon) throws OXException {
        try {
            String defaultTaskName;
            String defaultConName;
            ContextImpl ctx = new ContextImpl(cid);
            StringHelper strHelper = StringHelper.valueOf(LocaleTools.getLocale((String)language));
            if (OXFolderSQL.lookUpFolder(10, displayName, 8, writeCon, ctx) != -1) {
                throw OXFolderExceptionCode.NO_DEFAULT_INFOSTORE_CREATE.create(displayName, "userstore", 10, ctx.getContextId());
            }
            int globalAddressBookId = 6;
            boolean globalPermEnabled = OXFolderAdminHelper.checkGlobalGABPermissionExistence(cid, writeCon);
            if (globalPermEnabled) {
                LOG.warn((Object)("Individual user permission not added to global address book folder since global permission is active. user=" + userId + ", context=" + cid));
            } else if (!OXFolderAdminHelper.checkPermissionExistence(cid, 6, userId, writeCon)) {
                OCLPermission p = new OCLPermission();
                p.setEntity(userId);
                p.setGroupPermission(false);
                OXFolderAdminHelper.setGABPermissions(p);
                p.setFolderAdmin(false);
                this.createSinglePermission(6, p, cid, writeCon);
            }
            String defaultCalName = strHelper.getString("Calendar");
            if (defaultCalName == null || defaultCalName.length() == 0) {
                defaultCalName = DEFAULT_CAL_NAME;
            }
            if ((defaultConName = strHelper.getString("Contacts")) == null || defaultCalName.length() == 0) {
                defaultConName = DEFAULT_CON_NAME;
            }
            if ((defaultTaskName = strHelper.getString("Tasks")) == null || defaultTaskName.length() == 0) {
                defaultTaskName = DEFAULT_TASK_NAME;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Folder names determined for default folders:\n\t" + "Calendar=" + defaultCalName + "\tContact=" + defaultConName + "\tTask=" + defaultTaskName));
            }
            long creatingTime = System.currentTimeMillis();
            OCLPermission defaultPerm = new OCLPermission();
            defaultPerm.setEntity(userId);
            defaultPerm.setGroupPermission(false);
            defaultPerm.setAllPermission(128, 128, 128, 128);
            defaultPerm.setFolderAdmin(true);
            FolderObject fo = new FolderObject();
            fo.setPermissionsAsArray(new OCLPermission[]{defaultPerm});
            fo.setDefaultFolder(true);
            fo.setParentFolderID(1);
            fo.setType(1);
            fo.setFolderName(defaultCalName);
            fo.setModule(2);
            int newFolderId = OXFolderSQL.getNextSerialForAdmin(ctx, writeCon);
            OXFolderSQL.insertDefaultFolderSQL(newFolderId, userId, fo, creatingTime, ctx, writeCon);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"User's default CALENDAR folder successfully created");
            }
            fo.setFolderName(defaultConName);
            fo.setModule(3);
            newFolderId = OXFolderSQL.getNextSerialForAdmin(ctx, writeCon);
            OXFolderSQL.insertDefaultFolderSQL(newFolderId, userId, fo, creatingTime, ctx, writeCon);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"User's default CONTACT folder successfully created");
            }
            fo.setFolderName(defaultTaskName);
            fo.setModule(1);
            newFolderId = OXFolderSQL.getNextSerialForAdmin(ctx, writeCon);
            OXFolderSQL.insertDefaultFolderSQL(newFolderId, userId, fo, creatingTime, ctx, writeCon);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"User's default TASK folder successfully created");
            }
            fo.reset();
            fo.setPermissionsAsArray(new OCLPermission[]{defaultPerm});
            fo.setDefaultFolder(true);
            fo.setParentFolderID(10);
            fo.setType(2);
            fo.setFolderName(displayName);
            fo.setModule(8);
            newFolderId = OXFolderSQL.getNextSerialForAdmin(ctx, writeCon);
            OXFolderSQL.insertDefaultFolderSQL(newFolderId, userId, fo, creatingTime, ctx, writeCon);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"User's default INFOSTORE folder successfully created");
                LOG.info((Object)"All user default folders were successfully created");
                LOG.info((Object)("User " + userId + " successfully created" + " in context " + cid));
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public int addUserToInfoStore(int userId, String displayName, int cid, Connection writeCon) throws OXException {
        try {
            ContextImpl ctx = new ContextImpl(cid);
            String folderName = displayName;
            int resetLen = folderName.length();
            int count = 0;
            while (OXFolderSQL.lookUpFolder(10, folderName, 8, writeCon, ctx) != -1) {
                folderName = folderName.substring(0, resetLen) + " (" + String.valueOf(++count) + ')';
            }
            long creatingTime = System.currentTimeMillis();
            OCLPermission defaultPerm = new OCLPermission();
            defaultPerm.setEntity(userId);
            defaultPerm.setGroupPermission(false);
            defaultPerm.setAllPermission(128, 128, 128, 128);
            defaultPerm.setFolderAdmin(true);
            FolderObject fo = new FolderObject();
            fo.setPermissionsAsArray(new OCLPermission[]{defaultPerm});
            fo.setDefaultFolder(true);
            fo.setParentFolderID(10);
            fo.setType(2);
            fo.setFolderName(folderName);
            fo.setModule(8);
            int newFolderId = OXFolderSQL.getNextSerialForAdmin(ctx, writeCon);
            OXFolderSQL.insertDefaultFolderSQL(newFolderId, userId, fo, creatingTime, ctx, writeCon);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"User's default INFOSTORE folder successfully created");
            }
            return newFolderId;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static void setGABPermissions(OCLPermission p) {
        p.setAllPermission(2, 4, OXFolderProperties.isEnableInternalUsersEdit() ? 2 : 0, 0);
    }

    private void updateGABWritePermission(int contextId, boolean enable, Connection con) throws OXException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("UPDATE oxfolder_permissions SET fp = ?, orp = ?, owp = ? WHERE cid = ? AND fuid = ? AND permission_id = ?");
            int pos = 1;
            if (enable) {
                ps.setInt(pos++, 2);
                ps.setInt(pos++, 4);
                ps.setInt(pos++, OXFolderProperties.isEnableInternalUsersEdit() ? 2 : 0);
            } else {
                ps.setInt(pos++, 0);
                ps.setInt(pos++, 0);
                ps.setInt(pos++, 0);
            }
            ps.setInt(pos++, contextId);
            ps.setInt(pos++, 6);
            ps.setInt(pos++, 0);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(ps);
        }
    }
}

