/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;

public class IOTools {
    private IOTools() {
    }

    public static final void reallyBloodySkip(InputStream is, long bytes) throws IOException {
        while (bytes > 0L) {
            long skipped = is.skip(bytes);
            if (skipped < 0L) {
                return;
            }
            bytes -= skipped;
        }
    }

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(in);
        BufferedOutputStream outputStream = new BufferedOutputStream(out);
        int i = -1;
        int count = 0;
        while ((i = inputStream.read()) != -1) {
            ++count;
            outputStream.write(i);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytes(InputStream stream) throws IOException {
        BufferedInputStream in = new BufferedInputStream(stream);
        try {
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((i = in.read()) != -1) {
                out.write(i);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileContents(File file) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        Scanner scanner = null;
        try {
            scanner = new Scanner(file, "UTF-8");
            while (scanner.hasNextLine()) {
                sb.append(scanner.nextLine());
                sb.append('\n');
            }
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
        return sb.toString();
    }
}

