/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.ajax.requesthandler.AJAXRequestHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ServerRequestHandlerRegistry {
    private static final ServerRequestHandlerRegistry INSTANCE = new ServerRequestHandlerRegistry();
    private final Map<String, Map<String, AJAXRequestHandler>> requestHandlers = new ConcurrentHashMap<String, Map<String, AJAXRequestHandler>>();
    private static final AJAXRequestHandler[] EMPTY_ARR = new AJAXRequestHandler[0];

    public static ServerRequestHandlerRegistry getInstance() {
        return INSTANCE;
    }

    private ServerRequestHandlerRegistry() {
    }

    public void clearRegistry() {
        this.requestHandlers.clear();
    }

    public void removeHandler(AJAXRequestHandler requestHandler) {
        Map<String, AJAXRequestHandler> actionHandlers = this.requestHandlers.get(requestHandler.getModule());
        if (actionHandlers != null) {
            Set<String> actions = requestHandler.getSupportedActions();
            for (String action : actions) {
                actionHandlers.remove(action);
            }
            if (actionHandlers.isEmpty()) {
                this.requestHandlers.remove(requestHandler.getModule());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(AJAXRequestHandler requestHandler) {
        Map<String, AJAXRequestHandler> actionHandlers = this.requestHandlers.get(requestHandler.getModule());
        if (actionHandlers == null) {
            ServerRequestHandlerRegistry serverRequestHandlerRegistry = this;
            synchronized (serverRequestHandlerRegistry) {
                actionHandlers = this.requestHandlers.get(requestHandler.getModule());
                if (actionHandlers == null) {
                    actionHandlers = new ConcurrentHashMap<String, AJAXRequestHandler>();
                    this.requestHandlers.put(requestHandler.getModule(), actionHandlers);
                }
            }
        }
        Set<String> actions = requestHandler.getSupportedActions();
        for (String action : actions) {
            actionHandlers.put(action, requestHandler);
        }
    }

    public AJAXRequestHandler[] getModuleHandlers(String moduleName) {
        Map<String, AJAXRequestHandler> actionHandlers = this.requestHandlers.get(moduleName);
        if (actionHandlers == null) {
            return EMPTY_ARR;
        }
        HashSet<AJAXRequestHandler> set = new HashSet<AJAXRequestHandler>(actionHandlers.values());
        return set.toArray(new AJAXRequestHandler[set.size()]);
    }

    public AJAXRequestHandler getHandler(String moduleName, String action) {
        Map<String, AJAXRequestHandler> actionHandlers = this.requestHandlers.get(moduleName);
        if (actionHandlers == null) {
            return null;
        }
        return actionHandlers.get(action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Server request handler registry:\n");
        if (this.requestHandlers.isEmpty()) {
            sb.append("<empty>");
        } else {
            Iterator<Map.Entry<String, Map<String, AJAXRequestHandler>>> iter = this.requestHandlers.entrySet().iterator();
            while (true) {
                Map.Entry<String, Map<String, AJAXRequestHandler>> e = iter.next();
                sb.append(e.getKey()).append(": ").append(e.getValue().getClass().getName());
                if (!iter.hasNext()) break;
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

