/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.groupware.contact.ContactInterfaceProvider;
import com.openexchange.groupware.contact.ContactInterfaceProviderRegistry;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContactServiceListener
implements ServiceTrackerCustomizer<ContactInterfaceProvider, ContactInterfaceProvider> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ContactServiceListener.class));
    private final BundleContext context;

    public ContactServiceListener(BundleContext context) {
        this.context = context;
    }

    public ContactInterfaceProvider addingService(ServiceReference<ContactInterfaceProvider> reference) {
        Object id = reference.getProperty("override_folder");
        Object ctx = reference.getProperty("override_context");
        if (id != null && ctx != null) {
            int folderId = Integer.parseInt(id.toString());
            int contextId = Integer.parseInt(ctx.toString());
            ContactInterfaceProviderRegistry contactServices = ContactInterfaceProviderRegistry.getInstance();
            if (!contactServices.containsService(folderId, contextId)) {
                ContactInterfaceProvider provider = (ContactInterfaceProvider)this.context.getService(reference);
                if (contactServices.addService(folderId, contextId, provider)) {
                    return provider;
                }
                this.context.ungetService(reference);
            }
        }
        return null;
    }

    public void modifiedService(ServiceReference<ContactInterfaceProvider> reference, ContactInterfaceProvider service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<ContactInterfaceProvider> reference, ContactInterfaceProvider service) {
        if (null != service) {
            try {
                Object overRiding = reference.getProperty("override_folder");
                Object ctx = reference.getProperty("override_context");
                if (overRiding != null && ctx != null) {
                    int folderId = Integer.parseInt(overRiding.toString());
                    int contextId = Integer.parseInt(ctx.toString());
                    LOG.info((Object)new StringBuilder("Removing Service Bundle Contact Interface Provider: ").append(reference.getBundle().getSymbolicName()).append(" for folder ").append(folderId).append(" and context ").append(contextId));
                    ContactInterfaceProviderRegistry.getInstance().removeService(folderId, contextId, (ContactInterfaceProvider)this.context.getService(reference));
                }
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

