/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountTreeAction;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;

public final class GetTreeAction
extends AbstractMailAccountTreeAction {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(GetTreeAction.class));
    public static final String ACTION = "get_tree";

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        int id = GetTreeAction.parseIntParameter("id", requestData);
        try {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            MailAccount mailAccount = storageService.getMailAccount(id, session.getUserId(), session.getContextId());
            if (GetTreeAction.isUnifiedINBOXAccount(mailAccount)) {
                throw MailAccountExceptionCodes.NOT_FOUND.create(id, session.getUserId(), session.getContextId());
            }
            if (!session.getUserConfiguration().isMultipleMailAccounts() && !GetTreeAction.isDefaultMailAccount(mailAccount)) {
                throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
            }
            MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(session, mailAccount.getId());
            return new AJAXRequestResult(GetTreeAction.actionValidateTree0(mailAccess, session));
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }
}

