/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.config.MailProperties;
import com.sun.mail.imap.protocol.BASE64MailboxDecoder;
import com.sun.mail.imap.protocol.BASE64MailboxEncoder;

public final class MailFolderUtility {
    private static final int LEN = "default".length();

    private MailFolderUtility() {
    }

    public static String encode(String fullName) {
        return BASE64MailboxEncoder.encode((String)fullName);
    }

    public static String decode(String encoded) {
        return BASE64MailboxDecoder.decode((String)encoded);
    }

    public static FullnameArgument prepareMailFolderParam(String fullnameArgument) {
        int accountId;
        int index;
        if (fullnameArgument == null) {
            return null;
        }
        if (!fullnameArgument.startsWith("default")) {
            return new FullnameArgument(fullnameArgument);
        }
        int len = fullnameArgument.length();
        char separator = MailProperties.getInstance().getDefaultSeparator();
        char c = '\u0000';
        for (index = LEN; index < len && Character.isDigit(c = fullnameArgument.charAt(index)) && c != separator; ++index) {
        }
        try {
            accountId = index == LEN ? 0 : Integer.parseInt(fullnameArgument.substring(LEN, index));
        }
        catch (NumberFormatException e) {
            IllegalArgumentException err = new IllegalArgumentException("Mail account identifier is not a number: " + fullnameArgument);
            err.initCause(e);
            throw err;
        }
        if (index >= len) {
            return new FullnameArgument(accountId, "default");
        }
        return new FullnameArgument(accountId, fullnameArgument.substring(index + 1));
    }

    public static boolean equalsFullname(String fullnameArgument, String fullname) {
        if (fullnameArgument == null) {
            return fullname == null;
        }
        return MailFolderUtility.prepareMailFolderParam(fullnameArgument).getFullname().equals(fullname);
    }

    public static String prepareFullname(int accountId, String fullname) {
        if (fullname == null) {
            return null;
        }
        int length = fullname.length();
        if ("default".equals(fullname) || 0 == length) {
            return new StringBuilder(length + 4).append(fullname).append(accountId).toString();
        }
        if (fullname.startsWith("default")) {
            String tmpFullname = MailFolderUtility.prepareMailFolderParam(fullname).getFullname();
            if ("default".equals(tmpFullname)) {
                return new StringBuilder(length + 4).append(fullname).append(tmpFullname).toString();
            }
            return new StringBuilder(LEN + length + 4).append("default").append(accountId).append(MailProperties.getInstance().getDefaultSeparator()).append(tmpFullname).toString();
        }
        return new StringBuilder(LEN + length + 4).append("default").append(accountId).append(MailProperties.getInstance().getDefaultSeparator()).append(fullname).toString();
    }

    public static boolean isEmpty(String str) {
        char[] chars;
        if (null == str || str.length() == 0) {
            return true;
        }
        for (char c : chars = str.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }
}

