/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.usersetting;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public final class CachingUserSettingMailStorage
extends UserSettingMailStorage {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CachingUserSettingMailStorage.class));
    private static final String CACHE_REGION_NAME = "UserSettingMail";
    private Cache cache;
    private final Lock cacheWriteLock = new ReentrantLock();
    private static final String SQL_LOAD = "SELECT bits, send_addr, reply_to_addr, msg_format, display_msg_headers, auto_linebreak, std_trash, std_sent, std_drafts, std_spam, upload_quota, upload_quota_per_file, confirmed_spam, confirmed_ham FROM user_setting_mail WHERE cid = ? AND user = ?";
    private static final String SQL_INSERT = "INSERT INTO user_setting_mail (cid, user, bits, send_addr, reply_to_addr, msg_format, display_msg_headers, auto_linebreak, std_trash, std_sent, std_drafts, std_spam, upload_quota, upload_quota_per_file, confirmed_spam, confirmed_ham) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_UPDATE = "UPDATE user_setting_mail SET bits = ?, send_addr = ?, reply_to_addr = ?, msg_format = ?, display_msg_headers = ?, auto_linebreak = ?, std_trash = ?, std_sent = ?, std_drafts = ?, std_spam = ?, upload_quota = ?, upload_quota_per_file = ?, confirmed_spam = ?, confirmed_ham = ? WHERE cid = ? AND user = ?";
    private static final String SQL_UPDATE_BITS = "UPDATE user_setting_mail SET bits = ? WHERE cid = ? AND user = ?";
    private static final String SQL_DELETE = "DELETE FROM user_setting_mail WHERE cid = ? AND user = ?";
    private static final String SQL_DELETE_SIGNATURES = "DELETE FROM user_setting_mail_signature WHERE cid = ? AND user = ?";
    private static final String SQL_LOAD_SIGNATURES = "SELECT id, signature FROM user_setting_mail_signature WHERE cid = ? AND user = ?";
    private static final String SQL_INSERT_SIGNATURE = "INSERT INTO user_setting_mail_signature (cid, user, id, signature) VALUES (?, ?, ?, ?)";

    protected CachingUserSettingMailStorage() {
        try {
            this.initCache();
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initCache() throws OXException {
        if (null != this.cache) {
            return;
        }
        this.cache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_REGION_NAME);
    }

    private void releaseCache() throws OXException {
        if (null == this.cache) {
            return;
        }
        this.cache.clear();
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            cacheService.freeCache(CACHE_REGION_NAME);
        }
        this.cache = null;
    }

    private boolean useCache() {
        return this.cache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserSettingMail(UserSettingMail usm, int user, Context ctx, Connection writeConArg) throws OXException {
        block14: {
            if (usm.isNoSave()) {
                return;
            }
            try {
                Connection writeCon = writeConArg;
                boolean closeCon = false;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                boolean insert = false;
                Connection tmpCon = null;
                try {
                    tmpCon = DBPool.pickup(ctx);
                    stmt = tmpCon.prepareStatement("SELECT 1 FROM user_setting_mail WHERE cid = ? AND user = ?");
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, user);
                    rs = stmt.executeQuery();
                    insert = !rs.next();
                }
                catch (Throwable throwable) {
                    DBUtils.closeResources(rs, (Statement)stmt, tmpCon, true, ctx);
                    rs = null;
                    stmt = null;
                    tmpCon = null;
                    throw throwable;
                }
                DBUtils.closeResources(rs, (Statement)stmt, tmpCon, true, ctx);
                rs = null;
                stmt = null;
                tmpCon = null;
                try {
                    if (writeCon == null) {
                        writeCon = DBPool.pickupWriteable(ctx);
                        closeCon = true;
                    }
                    stmt = insert ? CachingUserSettingMailStorage.getInsertStmt(usm, user, ctx, writeCon) : CachingUserSettingMailStorage.getUpdateStmt(usm, user, ctx, writeCon);
                    stmt.executeUpdate();
                    CachingUserSettingMailStorage.saveSignatures(usm, user, ctx, writeCon);
                    DBUtils.closeResources(rs, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResources(rs, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
                    throw throwable;
                }
                usm.setModifiedDuringSession(false);
                if (!this.useCache()) break block14;
                this.cacheWriteLock.lock();
                try {
                    usm.setNoSave(false);
                    CacheKey key = this.cache.newCacheKey(ctx.getContextId(), user);
                    if (null != this.cache.get((Serializable)key)) {
                        this.cache.remove((Serializable)key);
                    }
                    this.cache.put((Serializable)key, (Serializable)usm.clone());
                }
                catch (OXException e) {
                    LOG.error((Object)"UserSettingMail could not be put into cache", (Throwable)e);
                }
                finally {
                    this.cacheWriteLock.unlock();
                }
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserSettingMailBits(UserSettingMail usm, int user, Context ctx, Connection writeConArg) throws OXException {
        block12: {
            if (usm.isNoSave()) {
                return;
            }
            try {
                Connection writeCon = writeConArg;
                boolean closeCon = false;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    if (writeCon == null) {
                        writeCon = DBPool.pickupWriteable(ctx);
                        closeCon = true;
                    }
                    stmt = CachingUserSettingMailStorage.getUpdateStmtBits(usm, user, ctx, writeCon);
                    stmt.executeUpdate();
                    CachingUserSettingMailStorage.saveSignatures(usm, user, ctx, writeCon);
                    DBUtils.closeResources(rs, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResources(rs, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
                    throw throwable;
                }
                usm.setModifiedDuringSession(false);
                if (!this.useCache()) break block12;
                this.cacheWriteLock.lock();
                try {
                    usm.setNoSave(false);
                    CacheKey key = this.cache.newCacheKey(ctx.getContextId(), user);
                    if (null != this.cache.get((Serializable)key)) {
                        this.cache.remove((Serializable)key);
                    }
                    this.cache.put((Serializable)key, (Serializable)usm.clone());
                }
                catch (OXException e) {
                    LOG.error((Object)"UserSettingMail could not be put into cache", (Throwable)e);
                }
                finally {
                    this.cacheWriteLock.unlock();
                }
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUserSettingMail(int user, Context ctx, Connection writeConArg) throws OXException {
        try {
            Connection writeCon = writeConArg;
            boolean closeWriteCon = false;
            PreparedStatement stmt = null;
            try {
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                stmt = writeCon.prepareStatement(SQL_DELETE_SIGNATURES);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, user);
                stmt.executeUpdate();
                stmt.close();
                stmt = writeCon.prepareStatement(SQL_DELETE);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, user);
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
                if (this.useCache()) {
                    this.cacheWriteLock.lock();
                    try {
                        this.cache.remove((Serializable)this.cache.newCacheKey(ctx.getContextId(), user));
                    }
                    catch (OXException e) {
                        LOG.error((Object)"UserSettingMail could not be removed from cache", (Throwable)e);
                    }
                    finally {
                        this.cacheWriteLock.unlock();
                    }
                }
                DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
                stmt = null;
                throw throwable;
            }
            stmt = null;
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSettingMail loadUserSettingMail(int user, Context ctx, Connection readConArg) throws OXException {
        UserSettingMail usm;
        boolean useCache = this.useCache();
        UserSettingMail userSettingMail = usm = useCache ? (UserSettingMail)this.cache.get((Serializable)this.cache.newCacheKey(ctx.getContextId(), user)) : null;
        if (null != usm) {
            return (UserSettingMail)usm.clone();
        }
        this.cacheWriteLock.lock();
        try {
            usm = useCache ? (UserSettingMail)this.cache.get((Serializable)this.cache.newCacheKey(ctx.getContextId(), user)) : null;
            if (null == usm) {
                usm = new UserSettingMail(user, ctx.getContextId());
                Connection readCon = readConArg;
                boolean closeCon = false;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    if (readCon == null) {
                        readCon = DBPool.pickup(ctx);
                        closeCon = true;
                    }
                    stmt = readCon.prepareStatement(SQL_LOAD);
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, user);
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        throw UserConfigurationCodes.MAIL_SETTING_NOT_FOUND.create(user, ctx.getContextId());
                    }
                    usm.parseBits(rs.getInt(1));
                    usm.setSendAddr(rs.getString(2));
                    usm.setReplyToAddr(rs.getString(3));
                    usm.setMsgFormat(rs.getInt(4));
                    CachingUserSettingMailStorage.setDisplayMsgHeadersString(usm, rs.getString(5));
                    usm.setAutoLinebreak(rs.getInt(6) >= 0 ? rs.getInt(6) : 0);
                    usm.setStdTrashName(rs.getString(7));
                    usm.setStdSentName(rs.getString(8));
                    usm.setStdDraftsName(rs.getString(9));
                    usm.setStdSpamName(rs.getString(10));
                    usm.setUploadQuota(rs.getLong(11));
                    usm.setUploadQuotaPerFile(rs.getLong(12));
                    usm.setConfirmedSpam(rs.getString(13));
                    usm.setConfirmedHam(rs.getString(14));
                    CachingUserSettingMailStorage.loadSignatures(usm, user, ctx, readCon);
                    usm.setModifiedDuringSession(false);
                    if (useCache) {
                        usm.setNoSave(false);
                        try {
                            this.cache.put((Serializable)this.cache.newCacheKey(ctx.getContextId(), user), (Serializable)usm);
                        }
                        catch (OXException e) {
                            LOG.error((Object)"UserSettingMail could not be put into cache", (Throwable)e);
                        }
                    }
                    DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                    throw throwable;
                }
            }
            UserSettingMail userSettingMail2 = (UserSettingMail)usm.clone();
            this.cacheWriteLock.unlock();
            return userSettingMail2;
        }
        catch (Throwable throwable) {
            try {
                this.cacheWriteLock.unlock();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSignatures(UserSettingMail usm, int user, Context ctx, Connection readConArg) throws OXException {
        try {
            Connection readCon = readConArg;
            boolean closeCon = false;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeCon = true;
                }
                stmt = readCon.prepareStatement(SQL_LOAD_SIGNATURES);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, user);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    HashMap<String, String> sigMap = new HashMap<String, String>();
                    do {
                        sigMap.put(rs.getString(1), rs.getString(2));
                    } while (rs.next());
                    int size = sigMap.size();
                    UserSettingMail.Signature[] signatures = new UserSettingMail.Signature[size];
                    Iterator iter = sigMap.entrySet().iterator();
                    for (int i = 0; i < size; ++i) {
                        Map.Entry e = iter.next();
                        signatures[i] = new UserSettingMail.Signature((String)e.getKey(), (String)e.getValue());
                    }
                    usm.setSignatures(signatures);
                } else {
                    usm.setSignatures(null);
                }
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static PreparedStatement getUpdateStmt(UserSettingMail usm, int user, Context ctx, Connection writeCon) throws SQLException {
        PreparedStatement stmt = writeCon.prepareStatement(SQL_UPDATE);
        stmt.setInt(1, usm.getBitsValue());
        stmt.setString(2, usm.getSendAddr() == null ? "" : usm.getSendAddr());
        stmt.setString(3, usm.getReplyToAddr() == null ? "" : usm.getReplyToAddr());
        stmt.setInt(4, usm.getMsgFormat());
        String s = CachingUserSettingMailStorage.getDisplayMsgHeadersString(usm);
        if (s == null) {
            stmt.setNull(5, 12);
        } else {
            stmt.setString(5, s);
        }
        s = null;
        stmt.setInt(6, usm.getAutoLinebreak());
        stmt.setString(7, usm.getStdTrashName() == null ? MailStrings.TRASH : usm.getStdTrashName());
        stmt.setString(8, usm.getStdSentName() == null ? MailStrings.SENT : usm.getStdSentName());
        stmt.setString(9, usm.getStdDraftsName() == null ? MailStrings.DRAFTS : usm.getStdDraftsName());
        stmt.setString(10, usm.getStdSpamName() == null ? MailStrings.SPAM : usm.getStdSpamName());
        stmt.setLong(11, usm.getUploadQuota());
        stmt.setLong(12, usm.getUploadQuotaPerFile());
        stmt.setString(13, usm.getConfirmedSpam() == null ? MailStrings.CONFIRMED_SPAM : usm.getConfirmedSpam());
        stmt.setString(14, usm.getConfirmedHam() == null ? MailStrings.CONFIRMED_HAM : usm.getConfirmedHam());
        stmt.setInt(15, ctx.getContextId());
        stmt.setInt(16, user);
        return stmt;
    }

    private static PreparedStatement getUpdateStmtBits(UserSettingMail usm, int user, Context ctx, Connection writeCon) throws SQLException {
        PreparedStatement stmt = writeCon.prepareStatement(SQL_UPDATE_BITS);
        stmt.setInt(1, usm.getBitsValue());
        stmt.setInt(2, ctx.getContextId());
        stmt.setInt(3, user);
        return stmt;
    }

    private static PreparedStatement getInsertStmt(UserSettingMail usm, int user, Context ctx, Connection writeCon) throws SQLException {
        PreparedStatement stmt = writeCon.prepareStatement(SQL_INSERT);
        stmt.setInt(1, ctx.getContextId());
        stmt.setInt(2, user);
        stmt.setInt(3, usm.getBitsValue());
        stmt.setString(4, usm.getSendAddr() == null ? "" : usm.getSendAddr());
        stmt.setString(5, usm.getReplyToAddr() == null ? "" : usm.getReplyToAddr());
        stmt.setInt(6, usm.getMsgFormat());
        String s = CachingUserSettingMailStorage.getDisplayMsgHeadersString(usm);
        if (s == null) {
            stmt.setNull(7, 12);
        } else {
            stmt.setString(7, s);
        }
        s = null;
        stmt.setInt(8, usm.getAutoLinebreak());
        stmt.setString(9, usm.getStdTrashName() == null ? MailStrings.TRASH : usm.getStdTrashName());
        stmt.setString(10, usm.getStdSentName() == null ? MailStrings.SENT : usm.getStdSentName());
        stmt.setString(11, usm.getStdDraftsName() == null ? MailStrings.DRAFTS : usm.getStdDraftsName());
        stmt.setString(12, usm.getStdSpamName() == null ? MailStrings.SPAM : usm.getStdSpamName());
        stmt.setLong(13, usm.getUploadQuota());
        stmt.setLong(14, usm.getUploadQuotaPerFile());
        stmt.setString(15, usm.getConfirmedSpam() == null ? MailStrings.CONFIRMED_SPAM : usm.getConfirmedSpam());
        stmt.setString(16, usm.getConfirmedHam() == null ? MailStrings.CONFIRMED_HAM : usm.getConfirmedHam());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean saveSignatures(UserSettingMail usm, int user, Context ctx, Connection writeConArg) throws OXException {
        try {
            boolean bl;
            UserSettingMail.Signature[] signatures;
            PreparedStatement stmt;
            boolean closeCon;
            Connection writeCon;
            block7: {
                writeCon = writeConArg;
                closeCon = false;
                stmt = null;
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeCon = true;
                }
                stmt = writeCon.prepareStatement(SQL_DELETE_SIGNATURES);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, user);
                stmt.executeUpdate();
                stmt.close();
                signatures = usm.getSignatures();
                if (signatures != null && signatures.length != 0) break block7;
                boolean bl2 = true;
                DBUtils.closeResources(null, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
                return bl2;
            }
            try {
                stmt = writeCon.prepareStatement(SQL_INSERT_SIGNATURE);
                for (int i = 0; i < signatures.length; ++i) {
                    UserSettingMail.Signature sig = signatures[i];
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, user);
                    stmt.setString(3, sig.getId());
                    stmt.setString(4, sig.getSignature());
                    stmt.addBatch();
                }
                bl = stmt.executeBatch().length > 0;
                DBUtils.closeResources(null, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(null, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
                throw throwable;
            }
            return bl;
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static String getDisplayMsgHeadersString(UserSettingMail usm) {
        String[] displayMsgHeaders = usm.getDisplayMsgHeaders();
        if (displayMsgHeaders == null || displayMsgHeaders.length == 0) {
            return null;
        }
        StringBuilder tmp = new StringBuilder(256);
        tmp.append(displayMsgHeaders[0]);
        for (int i = 1; i < displayMsgHeaders.length; ++i) {
            tmp.append(',').append(displayMsgHeaders[i]);
        }
        return tmp.toString();
    }

    private static void setDisplayMsgHeadersString(UserSettingMail usm, String displayMsgHeadersStr) {
        if (displayMsgHeadersStr == null) {
            usm.setDisplayMsgHeaders(null);
            usm.setModifiedDuringSession(true);
            return;
        }
        usm.setDisplayMsgHeaders(displayMsgHeadersStr.split(" *, *"));
        usm.setModifiedDuringSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() throws OXException {
        if (this.useCache()) {
            this.cacheWriteLock.lock();
            try {
                this.cache.clear();
            }
            catch (OXException e) {
                LOG.error((Object)"UserSettingMail's cache could not be cleared", (Throwable)e);
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserSettingMail(int user, Context ctx) throws OXException {
        if (this.useCache()) {
            this.cacheWriteLock.lock();
            try {
                this.cache.remove((Serializable)this.cache.newCacheKey(ctx.getContextId(), user));
            }
            catch (OXException e) {
                LOG.error((Object)"UserSettingMail could not be removed from cache", (Throwable)e);
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
    }

    @Override
    public void shutdownStorage() {
        try {
            this.releaseCache();
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void handleAbsence() throws OXException {
        this.releaseCache();
    }

    @Override
    public void handleAvailability() throws OXException {
        this.initCache();
    }
}

