/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config;

import com.openexchange.config.ConfigurationService;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TransportProperties
implements ITransportProperties {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TransportProperties.class));
    private static final TransportProperties instance = new TransportProperties();
    private final AtomicBoolean loaded = new AtomicBoolean();
    private int referencedPartLimit;
    private String defaultTransportProvider;
    private boolean publishOnExceededQuota;
    private String publishingInfostoreFolder;
    private boolean publishPrimaryAccountOnly;
    private boolean sendAttachmentToExternalRecipients;
    private boolean provideLinksInAttachment;
    private long publishedDocumentTimeToLive;
    private Locale externalRecipientsLocale;

    public static TransportProperties getInstance() {
        return instance;
    }

    private TransportProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadProperties() {
        if (!this.loaded.get()) {
            AtomicBoolean atomicBoolean = this.loaded;
            synchronized (atomicBoolean) {
                if (!this.loaded.get()) {
                    this.loadProperties0();
                    this.loaded.set(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetProperties() {
        if (this.loaded.get()) {
            AtomicBoolean atomicBoolean = this.loaded;
            synchronized (atomicBoolean) {
                if (this.loaded.get()) {
                    this.resetFields();
                    this.loaded.set(false);
                }
            }
        }
    }

    private void resetFields() {
        this.referencedPartLimit = 0;
        this.publishingInfostoreFolder = null;
        this.publishOnExceededQuota = false;
        this.publishPrimaryAccountOnly = true;
        this.sendAttachmentToExternalRecipients = false;
        this.provideLinksInAttachment = false;
        this.publishedDocumentTimeToLive = 604800000L;
        this.externalRecipientsLocale = null;
    }

    private void loadProperties0() {
        String defaultTransProvStr;
        StringBuilder logBuilder = new StringBuilder(1024);
        logBuilder.append("\nLoading global transport properties...\n");
        ConfigurationService configuration = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        String referencedPartLimitStr = configuration.getProperty("com.openexchange.mail.transport.referencedPartLimit", "1048576").trim();
        try {
            this.referencedPartLimit = Integer.parseInt(referencedPartLimitStr);
            logBuilder.append("\tReferenced Part Limit: ").append(this.referencedPartLimit).append('\n');
        }
        catch (NumberFormatException e) {
            this.referencedPartLimit = 0x100000;
            logBuilder.append("\tReferenced Part Limit: Invalid value \"").append(referencedPartLimitStr).append("\". Setting to fallback ").append(this.referencedPartLimit).append('\n');
        }
        this.defaultTransportProvider = defaultTransProvStr = configuration.getProperty("com.openexchange.mail.defaultTransportProvider", "smtp").trim();
        logBuilder.append("\tDefault Transport Provider: ").append(this.defaultTransportProvider).append('\n');
        String tmp = configuration.getProperty("com.openexchange.mail.transport.enablePublishOnExceededQuota", "false").trim();
        this.publishOnExceededQuota = Boolean.parseBoolean(tmp);
        logBuilder.append("\tPublish On Exceeded Quota: ").append(this.publishOnExceededQuota).append('\n');
        this.publishingInfostoreFolder = tmp = configuration.getProperty("com.openexchange.mail.transport.publishingPublicInfostoreFolder", "Email attachments").trim();
        logBuilder.append("\tPublishing Infostore Folder Name: \"").append(this.publishingInfostoreFolder).append('\"').append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.transport.publishPrimaryAccountOnly", "true").trim();
        this.publishPrimaryAccountOnly = Boolean.parseBoolean(tmp);
        logBuilder.append("\tPublish Primary Account Only: ").append(this.publishPrimaryAccountOnly).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.transport.sendAttachmentToExternalRecipients", "false").trim();
        this.sendAttachmentToExternalRecipients = Boolean.parseBoolean(tmp);
        logBuilder.append("\tSend Attachment to External Recipients: ").append(this.sendAttachmentToExternalRecipients).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.transport.provideLinksInAttachment", "false").trim();
        this.provideLinksInAttachment = Boolean.parseBoolean(tmp);
        logBuilder.append("\tProvide Links In Attachment: ").append(this.provideLinksInAttachment).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.transport.publishedDocumentTimeToLive", "604800000").trim();
        try {
            this.publishedDocumentTimeToLive = Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Value of property \"com.openexchange.mail.transport.publishedDocumentTimeToLive\" is not a number: " + tmp + ". Using fallback 604800000 instead."), (Throwable)e);
            this.publishedDocumentTimeToLive = 604800000L;
        }
        logBuilder.append("\tPublished Document Time-to-Live: ").append(this.publishedDocumentTimeToLive).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.transport.externalRecipientsLocale", "user-defined").trim();
        if ("user-defined".equalsIgnoreCase(tmp)) {
            this.externalRecipientsLocale = null;
            logBuilder.append("\tExternal Recipients Locale: ").append("user-defined").append('\n');
        } else {
            try {
                this.externalRecipientsLocale = LocaleTools.getLocale((String)tmp);
            }
            catch (Exception e) {
                LOG.warn((Object)("Value of property \"com.openexchange.mail.transport.externalRecipientsLocale\"" + " is not a valid locale identifier (such as \"en_US\"): " + tmp + ". Using fallback \"en\" instead."), (Throwable)e);
                this.externalRecipientsLocale = Locale.ENGLISH;
            }
            if (null == this.externalRecipientsLocale) {
                LOG.warn((Object)("Value of property \"com.openexchange.mail.transport.externalRecipientsLocale\"" + " is not a valid locale identifier (such as \"en_US\"): " + tmp + ". Using fallback \"en\" instead."));
                this.externalRecipientsLocale = Locale.ENGLISH;
            }
            logBuilder.append("\tExternal Recipients Locale: ").append(this.externalRecipientsLocale.toString()).append('\n');
        }
        logBuilder.append("Global transport properties successfully loaded!");
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)logBuilder.toString());
        }
    }

    @Override
    public int getReferencedPartLimit() {
        return this.referencedPartLimit;
    }

    public String getDefaultTransportProvider() {
        return this.defaultTransportProvider;
    }

    public String getPublishingInfostoreFolder() {
        return this.publishingInfostoreFolder;
    }

    public boolean isPublishOnExceededQuota() {
        return this.publishOnExceededQuota;
    }

    public boolean isPublishPrimaryAccountOnly() {
        return this.publishPrimaryAccountOnly;
    }

    public boolean isSendAttachmentToExternalRecipients() {
        return this.sendAttachmentToExternalRecipients;
    }

    public boolean isProvideLinksInAttachment() {
        return this.provideLinksInAttachment;
    }

    public long getPublishedDocumentTimeToLive() {
        return this.publishedDocumentTimeToLive;
    }

    public boolean publishedDocumentsExpire() {
        return this.publishedDocumentTimeToLive > 0L;
    }

    public Locale getExternalRecipientsLocale() {
        return this.externalRecipientsLocale;
    }
}

