/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Enriched2HtmlConverter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Enriched2HtmlConverter.class));
    private static final int EOF = -1;
    private boolean doReset;
    private String font;
    private String color;
    private int size;
    private int excerpt;
    private int paraType;
    private int paramCounter;
    private int nofill;
    private int newlineCounter;
    private boolean colorParam;
    private boolean fontParam;
    private boolean paraParam;
    private static final char CHAR_LT = '<';
    private static final char CHAR_GT = '>';
    private static final char CHAR_SLASH = '/';
    private static final char CHAR_LF = '\n';
    private static final char CHAR_AMP = '&';
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_QT = '\"';
    private static final String HTML_LOWERTHAN = "&lt;";
    private static final String HTML_GREATERTHAN = "&gt;";
    private static final String HTML_AMP = "&amp;";
    private static final String HTML_BREAK = "<br>\n";
    private static final String HTML_DL_DD = "<dl><dd>";
    private static final String HTML_END_DL = "</dl>";
    private static final String HTML_PRE = "<pre>\n";
    private static final String HTML_END_PRE = "</pre>\n";
    private static final String HTML_DIV = "div";
    private static final String HTML_END_DIV = "</div>";
    private static final String HTML_DIV_ALIGN = "<div align=left>";
    private static final String HTML_CENTER = "center";
    private static final String HTML_UNDERLINED = "u";
    private static final String HTML_TT = "tt";
    private static final String HTML_ITALIC = "i";
    private static final String HTML_BOLD = "b";
    private static final String ENRICHED_BOLD = "bold";
    private static final String ENRICHED_ITALIC = "italic";
    private static final String ENRICHED_FIXED = "fixed";
    private static final String ENRICHED_UNDERLINE = "underline";
    private static final String ENRICHED_CENTER = "center";
    private static final String ENRICHED_FLUSHLEFT = "flushleft";
    private static final String ENRICHED_BIGGER = "bigger";
    private static final String ENRICHED_SMALLER = "smaller";
    private static final String ENRICHED_INDENT = "indent";
    private static final String ENRICHED_EXCERPT = "excerpt";
    private static final String ENRICHED_COLOR = "color";
    private static final String ENRICHED_FONTFAMILY = "fontfamily";
    private static final String ENRICHED_PARAINDENT = "paraindent";
    private static final String ENRICHED_FLUSHBOTH = "flushboth";
    private static final String ENRICHED_INDENTRIGHT = "indentright";
    private static final String ENRICHED_PARAM = "param";
    private static final String ENRICHED_NOFILL = "nofill";
    private static final String ENRICHED_PREFIX = "x-tad-";
    private static final String FONT_PREFIX = "<font";
    private static final String FONT_SIZE_PLUS = " size=+";
    private static final String FONT_SIZE_MINUS = " size=-";
    private static final String FONT_COLOR = " color=\"";
    private static final String FONT_FACE = " face=\"";
    private static final String FONT_CLOSE_TAG = "</font>";

    public static final String convertEnriched2Html(String enrichedText) {
        return new Enriched2HtmlConverter().convert(enrichedText);
    }

    private final void reset() {
        this.font = null;
        this.color = null;
        this.size = 0;
        this.excerpt = 0;
        this.paraType = 0;
        this.paramCounter = 0;
        this.nofill = 0;
        this.newlineCounter = 0;
        this.colorParam = false;
        this.fontParam = false;
        this.paraParam = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String convert(String enrichedText) {
        try {
            if (this.doReset) {
                this.reset();
            } else {
                this.doReset = true;
            }
            StringBuilder sb = new StringBuilder(enrichedText.length());
            StringReader input = null;
            try {
                input = new StringReader(enrichedText.replaceAll("\r\n", "\n"));
                int c = -1;
                StringBuilder tokenBuilder = new StringBuilder();
                c = input.read();
                while (c != -1) {
                    boolean readNext = true;
                    if (c == 60) {
                        if (this.newlineCounter == 1) {
                            sb.append(' ');
                        }
                        this.newlineCounter = 0;
                        int next = input.read();
                        if (next == 60) {
                            if (this.paramCounter <= 0) {
                                sb.append(HTML_LOWERTHAN);
                            }
                        } else {
                            this.handleEnrichedTag(Enriched2HtmlConverter.getTagName(next, input), sb);
                        }
                    } else if (this.paramCounter > 0) {
                        if (c != -1) {
                            tokenBuilder.append(Character.toLowerCase((char)c));
                        }
                        while ((c = input.read()) != -1 && c != 60) {
                            tokenBuilder.append(Character.toLowerCase((char)c));
                        }
                        if (c == -1) break;
                        String token = tokenBuilder.toString();
                        tokenBuilder.setLength(0);
                        readNext = false;
                        if (this.colorParam) {
                            this.color = token;
                            Enriched2HtmlConverter.openFont(this.size, this.font, this.color, sb);
                        } else if (this.fontParam) {
                            this.font = token;
                            Enriched2HtmlConverter.openFont(this.size, this.font, this.color, sb);
                        } else if (this.paraParam) {
                            if (ParaType.PT_LEFT.str.equals(token)) {
                                this.paraType = ParaType.PT_LEFT.type;
                                sb.append(HTML_DL_DD);
                            } else if (ParaType.PT_RIGHT.str.equals(token)) {
                                this.paraType = ParaType.PT_RIGHT.type;
                            } else if (ParaType.PT_IN.str.equals(token)) {
                                this.paraType = ParaType.PT_IN.type;
                            } else if (ParaType.PT_OUT.str.equals(token)) {
                                this.paraType = ParaType.PT_OUT.type;
                            }
                        }
                    } else if (c == 10 && this.nofill <= 0) {
                        if (++this.newlineCounter > 1) {
                            sb.append(HTML_BREAK);
                            if (this.excerpt > 0) {
                                sb.append(HTML_GREATERTHAN).append(' ');
                            }
                        }
                    } else if (c == 62) {
                        sb.append(HTML_GREATERTHAN);
                    } else if (c == 38) {
                        sb.append(HTML_AMP);
                    } else {
                        if (this.newlineCounter == 1) {
                            sb.append(' ');
                        }
                        this.newlineCounter = 0;
                        sb.append((char)c);
                    }
                    if (!readNext) continue;
                    c = input.read();
                }
                sb.append('\n');
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            return sb.toString();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return enrichedText;
        }
    }

    private final void handleEnrichedTag(String tagArg, StringBuilder sb) {
        boolean isEndTag = tagArg.charAt(0) == '/';
        String tag = isEndTag ? tagArg.substring(1) : tagArg;
        if (tag.startsWith(ENRICHED_PREFIX)) {
            tag = tag.substring(6);
        }
        if (ENRICHED_BOLD.equals(tag)) {
            Enriched2HtmlConverter.mapSimpleTag(HTML_BOLD, isEndTag, sb);
        } else if (ENRICHED_ITALIC.equals(tag)) {
            Enriched2HtmlConverter.mapSimpleTag(HTML_ITALIC, isEndTag, sb);
        } else if (ENRICHED_FIXED.equals(tag)) {
            Enriched2HtmlConverter.mapSimpleTag(HTML_TT, isEndTag, sb);
        } else if (ENRICHED_UNDERLINE.equals(tag)) {
            Enriched2HtmlConverter.mapSimpleTag(HTML_UNDERLINED, isEndTag, sb);
        } else if ("center".equals(tag)) {
            Enriched2HtmlConverter.mapSimpleTag("center", isEndTag, sb);
        } else if (ENRICHED_FLUSHLEFT.equals(tag)) {
            sb.append(isEndTag ? HTML_END_DIV : HTML_DIV_ALIGN);
        } else if (ENRICHED_BIGGER.equals(tag)) {
            int n = this.size = isEndTag ? this.size - 2 : this.size + 2;
            if (isEndTag) {
                Enriched2HtmlConverter.closeFont(sb);
            } else {
                Enriched2HtmlConverter.openFont(this.size, this.font, this.color, sb);
            }
        } else if (ENRICHED_SMALLER.equals(tag)) {
            int n = this.size = isEndTag ? this.size + 2 : this.size - 2;
            if (isEndTag) {
                Enriched2HtmlConverter.closeFont(sb);
            } else {
                Enriched2HtmlConverter.openFont(this.size, this.font, this.color, sb);
            }
        } else if (ENRICHED_INDENT.equals(tag)) {
            sb.append(isEndTag ? HTML_END_DL : HTML_DL_DD);
        } else if (ENRICHED_EXCERPT.equals(tag)) {
            this.excerpt = isEndTag ? this.excerpt - 1 : this.excerpt + 1;
        } else if (ENRICHED_COLOR.equals(tag)) {
            if (isEndTag) {
                this.colorParam = false;
                this.color = null;
                Enriched2HtmlConverter.closeFont(sb);
            } else {
                this.colorParam = true;
            }
        } else if (ENRICHED_FONTFAMILY.equals(tag)) {
            if (isEndTag) {
                this.fontParam = false;
                this.font = null;
                Enriched2HtmlConverter.closeFont(sb);
            } else {
                this.fontParam = true;
            }
        } else if (ENRICHED_PARAINDENT.equals(tag)) {
            if (isEndTag) {
                this.paraParam = false;
                if (this.paraType == ParaType.PT_LEFT.type) {
                    sb.append(HTML_END_DL);
                }
                this.paraType = 0;
            } else {
                this.paraParam = true;
            }
        } else if (ENRICHED_FLUSHBOTH.equals(tag)) {
            Enriched2HtmlConverter.mapSimpleTag(HTML_DIV, isEndTag, sb);
        } else if (ENRICHED_INDENTRIGHT.equals(tag)) {
            sb.append(isEndTag ? HTML_END_DL : HTML_DL_DD);
        } else if (ENRICHED_PARAM.equals(tag)) {
            this.paramCounter = isEndTag ? this.paramCounter - 1 : this.paramCounter + 1;
        } else if (ENRICHED_NOFILL.equals(tag)) {
            if (isEndTag) {
                --this.nofill;
                sb.append(HTML_END_PRE);
            } else {
                ++this.nofill;
                sb.append(HTML_PRE);
            }
        } else {
            sb.append('?').append(HTML_LOWERTHAN);
            if (isEndTag) {
                sb.append('/');
            }
            sb.append(tag).append(HTML_GREATERTHAN);
        }
    }

    private static final void mapSimpleTag(String rpl, boolean isEndTag, StringBuilder sb) {
        sb.append('<');
        if (isEndTag) {
            sb.append('/');
        }
        sb.append(rpl).append('>');
    }

    private static final void openFont(int size, String font, String color, StringBuilder sb) {
        sb.append(FONT_PREFIX);
        if (size > 0) {
            sb.append(FONT_SIZE_PLUS).append(size);
        } else if (size < 0) {
            sb.append(FONT_SIZE_MINUS).append(size);
        }
        if (color != null) {
            sb.append(FONT_COLOR).append(color).append('\"');
        }
        if (font != null) {
            sb.append(FONT_FACE).append(font).append('\"');
        }
        sb.append('>');
    }

    private static final void closeFont(StringBuilder sb) {
        sb.append(FONT_CLOSE_TAG);
    }

    private static final String getTagName(int firstChar, Reader r) throws IOException {
        int c;
        StringBuilder result = new StringBuilder();
        result.append(Character.toLowerCase((char)firstChar));
        int level = 1;
        while (level > 0 && (c = r.read()) != -1) {
            if (c == 60) {
                ++level;
                continue;
            }
            if (c == 62) {
                --level;
                continue;
            }
            result.append(Character.toLowerCase((char)c));
        }
        return result.toString();
    }

    private static enum ParaType {
        PT_LEFT(1, "left"),
        PT_RIGHT(2, "right"),
        PT_IN(3, "in"),
        PT_OUT(4, "out");

        public final int type;
        public final String str;

        private ParaType(int type, String str) {
            this.type = type;
            this.str = str;
        }
    }
}

