/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.uuencode.UUEncodedPart;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RawJSONMessageHandler
implements MailMessageHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(RawJSONMessageHandler.class));
    private static final int MAX_BODY_SIZE = 16384;
    private final int accountId;
    private final MailPath mailPath;
    private JSONObject jsonObject;
    private long totalConsumedBodySize;
    private JSONArray bodyArr;
    private JSONArray attachmentsArr;
    private JSONArray nestedMsgsArr;
    private boolean bodyAdded;
    private boolean textWasEmpty;
    private boolean isAlternative;
    private String altId;
    private static final Set<HeaderName> COVERED_HEADER_NAMES = new HashSet<HeaderName>(Arrays.asList(MessageHeaders.CONTENT_DISPOSITION, MessageHeaders.CONTENT_ID, MessageHeaders.CONTENT_TYPE, MessageHeaders.BCC, MessageHeaders.CC, MessageHeaders.DATE, MessageHeaders.DISP_NOT_TO, MessageHeaders.FROM, MessageHeaders.X_PRIORITY, MessageHeaders.SUBJECT, MessageHeaders.TO));

    public RawJSONMessageHandler(int accountId, String mailPath) throws OXException {
        this.accountId = accountId;
        this.mailPath = new MailPath(mailPath);
        this.jsonObject = new JSONObject();
    }

    public RawJSONMessageHandler(int accountId, MailPath mailPath, MailMessage mail) throws OXException {
        this.accountId = accountId;
        this.mailPath = mailPath;
        this.jsonObject = new JSONObject();
        try {
            if (null != mail) {
                if (mail.containsFolder() && mail.getMailId() != null) {
                    this.jsonObject.put("folder_id", (Object)MailFolderUtility.prepareFullname(accountId, mail.getFolder()));
                    this.jsonObject.put("id", (Object)mail.getMailId());
                }
                this.jsonObject.put(MailJSONField.HAS_ATTACHMENTS.getKey(), mail.containsHasAttachment() ? mail.hasAttachment() : mail.getContentType().isMimeType("multipart/mixed"));
                this.jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)mail.getContentType().getBaseType());
                this.jsonObject.put(MailJSONField.SIZE.getKey(), mail.getSize());
                this.jsonObject.put(MailJSONField.ACCOUNT_NAME.getKey(), (Object)mail.getAccountName());
                this.jsonObject.put(MailJSONField.ACCOUNT_ID.getKey(), mail.getAccountId());
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private long addConsumedBodySize(long consumedBodySize) {
        this.totalConsumedBodySize += consumedBodySize;
        return this.totalConsumedBodySize;
    }

    private void discardJSONObject() {
        this.bodyArr = null;
        this.attachmentsArr = null;
        this.nestedMsgsArr = null;
        this.jsonObject = null;
    }

    private JSONArray getAttachmentsArr() throws JSONException {
        if (this.attachmentsArr == null) {
            this.attachmentsArr = new JSONArray();
            this.jsonObject.put(MailJSONField.ATTACHMENTS.getKey(), (Object)this.attachmentsArr);
        }
        return this.attachmentsArr;
    }

    private JSONArray getBodyArr() throws JSONException {
        if (this.bodyArr == null) {
            this.bodyArr = new JSONArray();
            this.jsonObject.put("body", (Object)this.bodyArr);
        }
        return this.bodyArr;
    }

    private JSONArray getNestedMsgsArr() throws JSONException {
        if (this.nestedMsgsArr == null) {
            this.nestedMsgsArr = new JSONArray();
            this.jsonObject.put(MailJSONField.NESTED_MESSAGES.getKey(), (Object)this.nestedMsgsArr);
        }
        return this.nestedMsgsArr;
    }

    @Override
    public boolean handleMultipartEnd(MailPart mp, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleAttachment(MailPart part, boolean isInline, String baseContentType, String fileName, String id) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MailListField.ID.getKey(), (Object)(part.containsSequenceId() ? part.getSequenceId() : id));
            if (fileName == null) {
                Object val;
                if (isInline) {
                    val = JSONObject.NULL;
                } else {
                    val = MailMessageParser.generateFilename(id, baseContentType);
                    part.setFileName((String)val);
                }
                jsonObject.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), val);
            } else {
                jsonObject.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), (Object)fileName);
            }
            if (part.containsSize()) {
                jsonObject.put(MailJSONField.SIZE.getKey(), part.getSize());
            }
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"attachment");
            if (part.containsContentId() && part.getContentId() != null) {
                jsonObject.put(MailJSONField.CID.getKey(), (Object)part.getContentId());
            }
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)part.getContentType().toString());
            jsonObject.put(MailJSONField.CONTENT.getKey(), JSONObject.NULL);
            this.getAttachmentsArr().put((Object)jsonObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleBccRecipient(InternetAddress[] recipientAddrs) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)MessageWriter.getAddressesAsArray(recipientAddrs));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleCcRecipient(InternetAddress[] recipientAddrs) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.RECIPIENT_CC.getKey(), (Object)MessageWriter.getAddressesAsArray(recipientAddrs));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.COLOR_LABEL.getKey(), colorLabel);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleContentId(String contentId) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.CID.getKey(), (Object)contentId);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleFrom(InternetAddress[] fromAddrs) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.FROM.getKey(), (Object)MessageWriter.getAddressesAsArray(fromAddrs));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleHeaders(int size, Iterator<Map.Entry<String, String>> iter) throws OXException {
        if (size == 0) {
            return true;
        }
        try {
            JSONObject hdrObject = new JSONObject();
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, String> entry = iter.next();
                String headerName = entry.getKey();
                if ("Disposition-Notification-To".equalsIgnoreCase(headerName)) continue;
                if ("Importance".equalsIgnoreCase(headerName)) {
                    int priority = 3;
                    if (null == entry.getValue()) continue;
                    priority = MimeMessageConverter.parseImportance(entry.getValue());
                    this.jsonObject.put(MailJSONField.PRIORITY.getKey(), priority);
                    continue;
                }
                if ("X-Priority".equalsIgnoreCase(headerName)) {
                    if (this.jsonObject.has(MailJSONField.PRIORITY.getKey())) continue;
                    int priority = 3;
                    if (null != entry.getValue()) {
                        priority = MimeMessageConverter.parsePriority(entry.getValue());
                    }
                    this.jsonObject.put(MailJSONField.PRIORITY.getKey(), priority);
                    continue;
                }
                if ("X-Mailer".equalsIgnoreCase(headerName)) {
                    hdrObject.put(headerName, (Object)entry.getValue());
                    continue;
                }
                if ("X-OX-VCard-Attached".equalsIgnoreCase(headerName)) {
                    this.jsonObject.put(MailJSONField.VCARD.getKey(), true);
                    continue;
                }
                if ("X-OX-Notification".equalsIgnoreCase(headerName)) {
                    this.jsonObject.put(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), (Object)entry.getValue());
                    continue;
                }
                if (COVERED_HEADER_NAMES.contains(HeaderName.valueOf(headerName))) continue;
                if (hdrObject.has(headerName)) {
                    JSONArray ja;
                    Object previous = hdrObject.get(headerName);
                    if (previous instanceof JSONArray) {
                        ja = (JSONArray)previous;
                        ja.put((Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
                        continue;
                    }
                    ja = new JSONArray();
                    ja.put(previous);
                    ja.put((Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
                    hdrObject.put(headerName, (Object)ja);
                    continue;
                }
                hdrObject.put(headerName, (Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
            }
            this.jsonObject.put(MailJSONField.HEADERS.getKey(), (Object)hdrObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleImagePart(MailPart part, String imageCID, String baseContentType, boolean isInline, String fileName, String id) throws OXException {
        return this.handleAttachment(part, isInline, baseContentType, fileName, id);
    }

    @Override
    public boolean handleInlineHtml(String htmlContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        if (this.bodyAdded) {
            if (this.isAlternative) {
                if (this.containsContent("text/htm")) {
                    this.asAttachment(id, contentType.getBaseType(), size, fileName, null);
                } else {
                    if (this.addConsumedBodySize(htmlContent.length()) > 16384L) {
                        this.discardJSONObject();
                        return false;
                    }
                    this.asRawContent(id, contentType.getBaseType(), htmlContent, fileName);
                }
            } else {
                this.asAttachment(id, contentType.getBaseType(), size, fileName, null);
            }
        } else {
            if (this.addConsumedBodySize(htmlContent.length()) > 16384L) {
                this.discardJSONObject();
                return false;
            }
            this.asRawContent(id, contentType.getBaseType(), htmlContent, fileName);
            this.bodyAdded = true;
        }
        return true;
    }

    @Override
    public boolean handleInlinePlainText(String plainTextContentArg, ContentType contentType, long size, String fileName, String id) throws OXException {
        if (this.bodyAdded) {
            if (this.isAlternative) {
                if (this.containsContent(contentType.getBaseType())) {
                    if (this.textWasEmpty) {
                        if (this.addConsumedBodySize(null == plainTextContentArg ? 0L : (long)plainTextContentArg.length()) > 16384L) {
                            this.discardJSONObject();
                            return false;
                        }
                        this.replaceEmptyContent(id, contentType.getBaseType(), plainTextContentArg);
                        this.textWasEmpty = null == plainTextContentArg || 0 == plainTextContentArg.length();
                    } else {
                        this.asAttachment(id, contentType.getBaseType(), size, fileName, null);
                    }
                } else {
                    if (this.addConsumedBodySize(null == plainTextContentArg ? 0L : (long)plainTextContentArg.length()) > 16384L) {
                        this.discardJSONObject();
                        return false;
                    }
                    this.asRawContent(id, contentType.getBaseType(), plainTextContentArg, fileName);
                    this.textWasEmpty = null == plainTextContentArg || 0 == plainTextContentArg.length();
                }
            } else if (this.textWasEmpty) {
                if (this.addConsumedBodySize(null == plainTextContentArg ? 0L : (long)plainTextContentArg.length()) > 16384L) {
                    this.discardJSONObject();
                    return false;
                }
                this.replaceEmptyContent(id, contentType.getBaseType(), plainTextContentArg);
                this.textWasEmpty = null == plainTextContentArg || 0 == plainTextContentArg.length();
            } else {
                this.asAttachment(id, contentType.getBaseType(), size, fileName, plainTextContentArg);
            }
        } else {
            if (this.addConsumedBodySize(null == plainTextContentArg ? 0L : (long)plainTextContentArg.length()) > 16384L) {
                this.discardJSONObject();
                return false;
            }
            this.asRawContent(id, contentType.getBaseType(), plainTextContentArg, fileName);
            this.textWasEmpty = null == plainTextContentArg || 0 == plainTextContentArg.length();
            this.bodyAdded = true;
        }
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(UUEncodedPart part, String id) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MailListField.ID.getKey(), (Object)id);
            String contentType = "application/octet-stream";
            String filename = part.getFileName();
            try {
                Locale locale = Locale.ENGLISH;
                contentType = MimeType2ExtMap.getContentType(new File(filename.toLowerCase(locale)).getName()).toLowerCase(locale);
            }
            catch (Exception e) {
                Throwable t = new Throwable("Unable to fetch content/type for '" + filename + "': " + e);
                LOG.warn((Object)t.getMessage(), t);
            }
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)contentType);
            jsonObject.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), (Object)filename);
            jsonObject.put(MailJSONField.SIZE.getKey(), part.getFileSize());
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"attachment");
            if (contentType.startsWith("text/")) {
                String content = part.getPart().toString();
                if (this.addConsumedBodySize(content.length()) > 16384L) {
                    this.discardJSONObject();
                    return false;
                }
                jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)content);
            } else {
                jsonObject.put(MailJSONField.CONTENT.getKey(), JSONObject.NULL);
            }
            this.getAttachmentsArr().put((Object)jsonObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        return this.handleInlinePlainText(decodedTextContent, contentType, size, fileName, id);
    }

    @Override
    public void handleMessageEnd(MailMessage mail) throws OXException {
        mail.setFlags(mail.getFlags() | 0x20);
        if (null != this.jsonObject) {
            try {
                this.jsonObject.put("alternative", this.isAlternative);
                if (null != this.mailPath) {
                    this.jsonObject.put(MailJSONField.MSGREF.getKey(), (Object)this.mailPath.toString());
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean handleMultipart(MailPart mp, int bodyPartCount, String id) throws OXException {
        if (mp.getContentType().startsWith("multipart/alternative") && bodyPartCount >= 2) {
            this.isAlternative = true;
            this.altId = id;
        } else if (null != this.altId && !id.startsWith(this.altId)) {
            this.isAlternative = false;
        }
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        try {
            String name;
            MailMessage nestedMail;
            Object content = mailPart.getContent();
            if (content instanceof MailMessage) {
                nestedMail = (MailMessage)content;
            } else if (content instanceof InputStream) {
                try {
                    nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)content));
                }
                catch (MessagingException e) {
                    throw MimeMailException.handleMessagingException(e);
                }
            } else {
                StringBuilder sb = new StringBuilder(128);
                sb.append("Ignoring nested message.").append("Cannot handle part's content which should be a RFC822 message according to its content type: ");
                sb.append(null == content ? "null" : content.getClass().getSimpleName());
                LOG.error((Object)sb.toString());
                return true;
            }
            RawJSONMessageHandler msgHandler = new RawJSONMessageHandler(this.accountId, null, null);
            msgHandler.totalConsumedBodySize = this.totalConsumedBodySize;
            new MailMessageParser().parseMailMessage(nestedMail, msgHandler, id);
            this.totalConsumedBodySize = msgHandler.totalConsumedBodySize;
            if (this.totalConsumedBodySize > 16384L) {
                this.discardJSONObject();
                return false;
            }
            JSONObject nestedObject = msgHandler.getJSONObject();
            nestedObject.put(MailListField.ID.getKey(), (Object)(mailPart.containsSequenceId() ? mailPart.getSequenceId() : id));
            if (mailPart.containsFileName() && null != (name = mailPart.getFileName())) {
                nestedObject.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), (Object)name);
            }
            this.getNestedMsgsArr().put((Object)nestedObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handlePriority(int priority) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.PRIORITY.getKey(), priority);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleMsgRef(String msgRef) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.MSGREF.getKey(), (Object)msgRef);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleDispositionNotification(InternetAddress dispositionNotificationTo, boolean seen) throws OXException {
        try {
            if (!seen) {
                this.jsonObject.put(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), (Object)dispositionNotificationTo.toUnicodeString());
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.RECEIVED_DATE.getKey(), receivedDate == null ? JSONObject.NULL : Long.valueOf(receivedDate.getTime()));
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSentDate(Date sentDate) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.SENT_DATE.getKey(), sentDate == null ? JSONObject.NULL : Long.valueOf(sentDate.getTime()));
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSpecialPart(MailPart part, String baseContentType, String fileName, String id) throws OXException {
        return this.handleAttachment(part, false, baseContentType, fileName, id);
    }

    @Override
    public boolean handleSubject(String subject) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.SUBJECT.getKey(), subject == null ? JSONObject.NULL : subject.trim());
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        try {
            if (this.jsonObject.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
                int prevFlags = this.jsonObject.getInt(MailJSONField.FLAGS.getKey());
                this.jsonObject.put(MailJSONField.FLAGS.getKey(), prevFlags | flags);
            } else {
                this.jsonObject.put(MailJSONField.FLAGS.getKey(), flags);
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleToRecipient(InternetAddress[] recipientAddrs) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)MessageWriter.getAddressesAsArray(recipientAddrs));
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        if (userFlags == null) {
            return true;
        }
        try {
            JSONArray userFlagsArr = new JSONArray();
            for (String userFlag : userFlags) {
                int flags;
                if (MailMessage.isColorLabel(userFlag)) {
                    this.jsonObject.put(MailJSONField.COLOR_LABEL.getKey(), MailMessage.getColorLabelIntValue(userFlag));
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(userFlag)) {
                    if (this.jsonObject.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
                        flags = this.jsonObject.getInt(MailJSONField.FLAGS.getKey());
                        this.jsonObject.put(MailJSONField.FLAGS.getKey(), flags | 0x100);
                        continue;
                    }
                    this.jsonObject.put(MailJSONField.FLAGS.getKey(), 256);
                    continue;
                }
                if ("$MDNSent".equalsIgnoreCase(userFlag)) {
                    if (this.jsonObject.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
                        flags = this.jsonObject.getInt(MailJSONField.FLAGS.getKey());
                        this.jsonObject.put(MailJSONField.FLAGS.getKey(), flags | 0x200);
                        continue;
                    }
                    this.jsonObject.put(MailJSONField.FLAGS.getKey(), 512);
                    continue;
                }
                userFlagsArr.put((Object)userFlag);
            }
            this.jsonObject.put(MailJSONField.USER.getKey(), (Object)userFlagsArr);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    public MailPath getMailPath() {
        return this.mailPath;
    }

    private boolean containsContent(String baseContentType) throws OXException {
        try {
            JSONArray bodyArr = this.getBodyArr();
            int len = bodyArr.length();
            for (int i = 0; i < len; ++i) {
                String ct = bodyArr.getJSONObject(i).optString(MailJSONField.CONTENT_TYPE.getKey());
                if (null == ct || !RawJSONMessageHandler.startsWith(ct, baseContentType)) continue;
                return true;
            }
            return false;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private static String toLowerCase(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    private static boolean startsWith(String s, String prefix) {
        return RawJSONMessageHandler.toLowerCase(s).startsWith(RawJSONMessageHandler.toLowerCase(prefix), 0);
    }

    private void asRawContent(String id, String baseContentType, String content, String filename) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MailListField.ID.getKey(), (Object)id);
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)baseContentType);
            jsonObject.put(MailJSONField.SIZE.getKey(), content.length());
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"inline");
            jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)content);
            jsonObject.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), (Object)filename);
            this.getBodyArr().put((Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void asAttachment(String id, String baseContentType, long size, String fileName, String optContent) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MailListField.ID.getKey(), (Object)id);
            if (fileName == null) {
                jsonObject.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), JSONObject.NULL);
            } else {
                jsonObject.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), (Object)fileName);
            }
            jsonObject.put(MailJSONField.SIZE.getKey(), size);
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"attachment");
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)baseContentType);
            if (null == optContent) {
                jsonObject.put(MailJSONField.CONTENT.getKey(), JSONObject.NULL);
            } else {
                jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)optContent);
            }
            this.getAttachmentsArr().put((Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void replaceEmptyContent(String id, String baseContentType, String content) throws OXException {
        try {
            int i;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MailListField.ID.getKey(), (Object)id);
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)baseContentType);
            jsonObject.put(MailJSONField.SIZE.getKey(), content.length());
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"inline");
            jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)content);
            JSONArray bodyArr = this.getBodyArr();
            int len = bodyArr.length();
            for (i = 0; i < len && !baseContentType.equals(bodyArr.getJSONObject(i).get(MailJSONField.CONTENT_TYPE.getKey())); ++i) {
            }
            bodyArr.put(i, (Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }
}

